/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.CommandContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuHelper {
    public static final String ACTION_SET_CMD_PREFIX = "AS::";
    public static final String MAIN_MENU_ID = "org.eclipse.ui.main.menu";
    private static Field urlField;

    public static void trace(String msg, Throwable error) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)msg, (Throwable)error);
    }

    public static int indexForId(MElementContainer<MMenuElement> parentMenu, String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        int i = 0;
        for (MMenuElement item : parentMenu.getChildren()) {
            if (id.equals(item.getElementId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = MenuHelper.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = MenuHelper.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            if (parent.getName().equals("actionSet")) {
                actionSetId = MenuHelper.getId(parent);
            }
            obj = parent.getParent();
        }
        return ACTION_SET_CMD_PREFIX + actionSetId + '/' + id;
    }

    public static String getImageUrl(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Class<?> idc = imageDescriptor.getClass();
        if (idc.getName().endsWith("URLImageDescriptor")) {
            URL url = MenuHelper.getUrl(idc, imageDescriptor);
            return url.toExternalForm();
        }
        return null;
    }

    private static URL getUrl(Class idc, ImageDescriptor imageDescriptor) {
        try {
            if (urlField == null) {
                urlField = idc.getDeclaredField("url");
                urlField.setAccessible(true);
            }
            return (URL)urlField.get(imageDescriptor);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static MCommand getCommandById(MApplication app, String cmdId) {
        List cmds = app.getCommands();
        for (MCommand cmd : cmds) {
            if (!cmdId.equals(cmd.getElementId())) continue;
            return cmd;
        }
        return null;
    }

    static boolean getVisibleEnabled(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren("visibleWhen");
        String checkEnabled = null;
        if (children.length > 0) {
            checkEnabled = children[0].getAttribute("checkEnabled");
        }
        return checkEnabled != null && checkEnabled.equalsIgnoreCase("true");
    }

    static MExpression getVisibleWhen(IConfigurationElement commandAddition) {
        try {
            IConfigurationElement[] visibleChild;
            IConfigurationElement[] visibleConfig = commandAddition.getChildren("visibleWhen");
            if (visibleConfig.length > 0 && visibleConfig.length < 2 && (visibleChild = visibleConfig[0].getChildren()).length > 0) {
                Expression visWhen = ExpressionConverter.getDefault().perform(visibleChild[0]);
                MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
                exp.setCoreExpressionId("programmatic.value");
                exp.setCoreExpression((Object)visWhen);
                return exp;
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getKey(MMenuContribution contribution) {
        String key = contribution.getParentID();
        key = String.valueOf(key) + "?" + (contribution.getPositionInParent() == null ? "after=additions" : contribution.getPositionInParent());
        return key;
    }

    public static void printContributions(ArrayList<MMenuContribution> contributions) {
        for (MMenuContribution c : contributions) {
            MenuHelper.trace("\n" + c, null);
            for (MMenuElement element : c.getChildren()) {
                MenuHelper.printElement(1, element);
            }
        }
    }

    private static void printElement(int level, MMenuElement element) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < level) {
            buf.append('\t');
            ++i;
        }
        buf.append(element.toString());
        MenuHelper.trace(buf.toString(), null);
        if (element instanceof MMenu) {
            for (MMenuElement item : ((MMenu)element).getChildren()) {
                MenuHelper.printElement(level + 1, item);
            }
        }
    }

    public static void mergeContributions(ArrayList<MMenuContribution> contributions, ArrayList<MMenuContribution> result) {
        ArrayList slot;
        String key;
        HashMap<String, ArrayList> buckets = new HashMap<String, ArrayList>();
        MenuHelper.trace("mergeContributions size: " + contributions.size(), null);
        MenuHelper.printContributions(contributions);
        for (MMenuContribution contribution : contributions) {
            key = MenuHelper.getKey(contribution);
            slot = (ArrayList)buckets.get(key);
            if (slot == null) {
                slot = new ArrayList();
                buckets.put(key, slot);
            }
            slot.add(contribution);
        }
        Iterator<MMenuContribution> i = contributions.iterator();
        while (i.hasNext() && !buckets.isEmpty()) {
            MMenuContribution contribution = i.next();
            key = MenuHelper.getKey(contribution);
            slot = (ArrayList)buckets.remove(key);
            if (slot == null) continue;
            MMenuContribution toContribute = null;
            for (MMenuContribution item : slot) {
                if (toContribute == null) {
                    toContribute = item;
                    continue;
                }
                Object[] array = item.getChildren().toArray();
                int c = 0;
                while (c < array.length) {
                    MMenuElement me = (MMenuElement)array[c];
                    if (!MenuHelper.containsMatching(toContribute.getChildren(), me)) {
                        toContribute.getChildren().add(me);
                    }
                    ++c;
                }
            }
            if (toContribute == null) continue;
            result.add(toContribute);
        }
        MenuHelper.trace("mergeContributions: final size: " + result.size(), null);
    }

    private static boolean containsMatching(List<MMenuElement> children, MMenuElement me) {
        for (MMenuElement element : children) {
            if (!Util.equals(me.getElementId(), element.getElementId()) || !element.getClass().isInstance(me) || !(element instanceof MMenuSeparator) && !(element instanceof MMenu)) continue;
            return true;
        }
        return false;
    }

    public static void mergeActionSetContributions(ArrayList<MMenuContribution> contributions, ArrayList<MMenuContribution> result) {
        ListIterator<MMenuContribution> i = contributions.listIterator(contributions.size());
        MMenuContribution currentContribution = null;
        while (i.hasPrevious()) {
            MMenuContribution c = i.previous();
            if (currentContribution == null) {
                currentContribution = c;
                continue;
            }
            if (c.getParentID().equals(currentContribution.getParentID()) && c.getPositionInParent().equals(currentContribution.getPositionInParent())) {
                ListIterator j = c.getChildren().listIterator(c.getChildren().size());
                while (j.hasPrevious()) {
                    currentContribution.getChildren().add((MMenuElement)j.previous());
                }
                c.getChildren().clear();
                continue;
            }
            result.add(currentContribution);
            currentContribution = c;
        }
        if (currentContribution != null) {
            result.add(currentContribution);
        }
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = MenuHelper.getCommandId(element);
        }
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    static String getName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    static int getMode(IConfigurationElement element) {
        if ("FORCE_TEXT".equals(element.getAttribute("mode"))) {
            return CommandContributionItem.MODE_FORCE_TEXT;
        }
        return 0;
    }

    static String getLabel(IConfigurationElement element) {
        return element.getAttribute("label");
    }

    static String getPath(IConfigurationElement element) {
        return element.getAttribute("path");
    }

    static String getMenuBarPath(IConfigurationElement element) {
        return element.getAttribute("menubarPath");
    }

    static String getMnemonic(IConfigurationElement element) {
        return element.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement element) {
        return element.getAttribute("tooltip");
    }

    static String getIconPath(IConfigurationElement element) {
        return element.getAttribute("icon");
    }

    static String getDisabledIconPath(IConfigurationElement element) {
        return element.getAttribute("disabledIcon");
    }

    static String getHoverIconPath(IConfigurationElement element) {
        return element.getAttribute("hoverIcon");
    }

    static String getIconUrl(IConfigurationElement element, String attr) {
        String extendingPluginId = element.getDeclaringExtension().getContributor().getName();
        String iconPath = element.getAttribute(attr);
        if (iconPath == null) {
            return null;
        }
        if (!iconPath.startsWith("platform:")) {
            iconPath = "platform:/plugin/" + extendingPluginId + "/" + iconPath;
        }
        URL url = null;
        try {
            url = FileLocator.find((URL)new URL(iconPath));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url == null ? null : url.toString();
    }

    static String getHelpContextId(IConfigurationElement element) {
        return element.getAttribute("helpContextId");
    }

    public static boolean isSeparatorVisible(IConfigurationElement element) {
        String val = element.getAttribute("visible");
        return Boolean.valueOf(val);
    }

    public static String getClassSpec(IConfigurationElement element) {
        return element.getAttribute("class");
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static ItemType getStyle(IConfigurationElement element) {
        String style = element.getAttribute("style");
        if (style == null || style.length() == 0) {
            return ItemType.PUSH;
        }
        if ("toggle".equals(style)) {
            return ItemType.CHECK;
        }
        if ("radio".equals(style)) {
            return ItemType.RADIO;
        }
        if ("pulldown".equals(style)) {
            MenuHelper.trace("Failed to get style for pulldown", null);
        }
        return ItemType.PUSH;
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.valueOf(r);
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static Map<String, String> getParameters(IConfigurationElement element) {
        HashMap<String, String> map = new HashMap<String, String>();
        IConfigurationElement[] parameters = element.getChildren("parameter");
        int i = 0;
        while (i < parameters.length) {
            String name = parameters[i].getAttribute("name");
            String value = parameters[i].getAttribute("value");
            if (name != null && value != null) {
                map.put(name, value);
            }
            ++i;
        }
        return map;
    }

    public static MMenu createMenuAddition(IConfigurationElement menuAddition) {
        int idx;
        MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
        String id = MenuHelper.getId(menuAddition);
        element.setElementId(id);
        String text = MenuHelper.getLabel(menuAddition);
        String mnemonic = MenuHelper.getMnemonic(menuAddition);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        element.setIconURI(MenuHelper.getIconUrl(menuAddition, "icon"));
        element.setLabel(Util.safeString(text));
        return element;
    }

    public static MMenuElement createLegacyActionAdditions(MApplication app, IConfigurationElement element) {
        int idx;
        String id = MenuHelper.getId(element);
        String text = MenuHelper.getLabel(element);
        String mnemonic = MenuHelper.getMnemonic(element);
        if (text != null && mnemonic != null && (idx = text.indexOf(mnemonic)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
        }
        String iconUri = MenuHelper.getIconUrl(element, "icon");
        String cmdId = MenuHelper.getActionSetCommandId(element);
        if (cmdId == null) {
            return null;
        }
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setElementId(id);
        item.setLabel(text);
        MCommand cmd = MenuHelper.getCommandById(app, cmdId);
        if (cmd == null) {
            MenuHelper.trace("Failed to find command: " + cmdId, null);
            return null;
        }
        item.setCommand(cmd);
        if (iconUri != null) {
            item.setIconURI(iconUri);
        }
        return item;
    }
}

