/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class RawType
extends HierarchyType {
    private HierarchyType fTypeDeclaration;

    protected RawType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, IType javaElementType) {
        Assert.isTrue((boolean)binding.isRawType());
        super.initialize(binding, javaElementType);
        TypeEnvironment environment = this.getEnvironment();
        this.fTypeDeclaration = (HierarchyType)environment.create(binding.getTypeDeclaration());
    }

    public int getKind() {
        return 8;
    }

    public boolean doEquals(TType type) {
        return this.getJavaElementType().equals(((RawType)type).getJavaElementType());
    }

    public int hashCode() {
        return this.getJavaElementType().hashCode();
    }

    public TType getTypeDeclaration() {
        return this.fTypeDeclaration;
    }

    public TType getErasure() {
        return this.fTypeDeclaration;
    }

    HierarchyType getHierarchyType() {
        return this.fTypeDeclaration;
    }

    protected boolean doCanAssignTo(TType lhs) {
        int targetType = lhs.getKind();
        switch (targetType) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return this.canAssignToStandardType((StandardType)lhs);
            }
            case 6: {
                return false;
            }
            case 7: {
                return this.isSubType((ParameterizedType)lhs);
            }
            case 8: {
                return this.isSubType((HierarchyType)lhs);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)lhs).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)lhs).checkLowerBound(this);
            }
        }
        return false;
    }

    protected boolean isTypeEquivalentTo(TType other) {
        int otherElementType = other.getKind();
        if (otherElementType == 7 || otherElementType == 6) {
            return this.getErasure().isTypeEquivalentTo(other.getErasure());
        }
        return super.isTypeEquivalentTo(other);
    }

    public String getName() {
        return this.getJavaElementType().getElementName();
    }

    protected String getPlainPrettySignature() {
        return this.getJavaElementType().getFullyQualifiedName('.');
    }
}

