/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.internal.opengl.glx.GLX;
import org.eclipse.swt.internal.opengl.glx.XVisualInfo;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int xWindow;
    int context;
    int colormap;
    XVisualInfo vinfo;
    static final int MAX_ATTRIBUTES = 32;

    public GLCanvas(Composite parent, int style, GLData data) {
        super(parent, style);
        if (data == null) {
            SWT.error(4);
        }
        int[] glxAttrib = new int[32];
        int pos = 0;
        glxAttrib[pos++] = 4;
        if (data.doubleBuffer) {
            glxAttrib[pos++] = 5;
        }
        if (data.stereo) {
            glxAttrib[pos++] = 6;
        }
        if (data.redSize > 0) {
            glxAttrib[pos++] = 8;
            glxAttrib[pos++] = data.redSize;
        }
        if (data.greenSize > 0) {
            glxAttrib[pos++] = 9;
            glxAttrib[pos++] = data.greenSize;
        }
        if (data.blueSize > 0) {
            glxAttrib[pos++] = 10;
            glxAttrib[pos++] = data.blueSize;
        }
        if (data.alphaSize > 0) {
            glxAttrib[pos++] = 11;
            glxAttrib[pos++] = data.alphaSize;
        }
        if (data.depthSize > 0) {
            glxAttrib[pos++] = 12;
            glxAttrib[pos++] = data.depthSize;
        }
        if (data.stencilSize > 0) {
            glxAttrib[pos++] = 13;
            glxAttrib[pos++] = data.stencilSize;
        }
        if (data.accumRedSize > 0) {
            glxAttrib[pos++] = 14;
            glxAttrib[pos++] = data.accumRedSize;
        }
        if (data.accumGreenSize > 0) {
            glxAttrib[pos++] = 15;
            glxAttrib[pos++] = data.accumGreenSize;
        }
        if (data.accumBlueSize > 0) {
            glxAttrib[pos++] = 16;
            glxAttrib[pos++] = data.accumBlueSize;
        }
        if (data.accumAlphaSize > 0) {
            glxAttrib[pos++] = 17;
            glxAttrib[pos++] = data.accumAlphaSize;
        }
        if (data.sampleBuffers > 0) {
            glxAttrib[pos++] = 100000;
            glxAttrib[pos++] = data.sampleBuffers;
        }
        if (data.samples > 0) {
            glxAttrib[pos++] = 100001;
            glxAttrib[pos++] = data.samples;
        }
        glxAttrib[pos++] = 0;
        new GC(this).dispose();
        int xDisplay = OS.XtDisplay(this.handle);
        int xScreen = OS.XDefaultScreen(xDisplay);
        int infoPtr = GLX.glXChooseVisual(xDisplay, xScreen, glxAttrib);
        if (infoPtr == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.vinfo = new XVisualInfo();
        GLX.memmove(this.vinfo, infoPtr, XVisualInfo.sizeof);
        OS.XFree(infoPtr);
        int share = data.shareContext != null ? data.shareContext.context : 0;
        this.context = GLX.glXCreateContext(xDisplay, this.vinfo, share, true);
        if (this.context == 0) {
            SWT.error(2);
        }
        int xParent = OS.XtWindow(this.handle);
        XSetWindowAttributes attributes = new XSetWindowAttributes();
        int mask = 14336;
        attributes.colormap = this.colormap = OS.XCreateColormap(xDisplay, xParent, this.vinfo.visual, 0);
        this.xWindow = OS.XCreateWindow(xDisplay, xParent, 0, 0, 1, 1, 0, this.vinfo.depth, 1, this.vinfo.visual, mask, attributes);
        int event_mask = OS.XtBuildEventMask(this.handle);
        OS.XSelectInput(xDisplay, this.xWindow, event_mask);
        OS.XMapWindow(xDisplay, this.xWindow);
        OS.XtRegisterDrawable(xDisplay, this.xWindow, this.handle);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int xDisplay = OS.XtDisplay(GLCanvas.this.handle);
                switch (event.type) {
                    case 9: {
                        int[] viewport = new int[4];
                        GLX.glGetIntegerv(2978, viewport);
                        GLX.glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 11: {
                        Rectangle clientArea = GLCanvas.this.getClientArea();
                        OS.XMoveResizeWindow(xDisplay, GLCanvas.this.xWindow, clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                        break;
                    }
                    case 12: {
                        if (GLCanvas.this.context != 0) {
                            if (GLX.glXGetCurrentContext() == GLCanvas.this.context) {
                                GLX.glXMakeCurrent(xDisplay, 0, 0);
                            }
                            GLX.glXDestroyContext(xDisplay, GLCanvas.this.context);
                            GLCanvas.this.context = 0;
                        }
                        if (GLCanvas.this.xWindow != 0) {
                            OS.XtUnregisterDrawable(xDisplay, GLCanvas.this.xWindow);
                            OS.XDestroyWindow(xDisplay, GLCanvas.this.xWindow);
                            GLCanvas.this.xWindow = 0;
                        }
                        if (GLCanvas.this.colormap == 0) break;
                        OS.XFreeColormap(xDisplay, GLCanvas.this.colormap);
                        GLCanvas.this.colormap = 0;
                    }
                }
            }
        };
        this.addListener(1, listener);
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    public GLData getGLData() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        GLData data = new GLData();
        int[] value = new int[1];
        GLX.glXGetConfig(xDisplay, this.vinfo, 5, value);
        data.doubleBuffer = value[0] != 0;
        GLX.glXGetConfig(xDisplay, this.vinfo, 6, value);
        data.stereo = value[0] != 0;
        GLX.glXGetConfig(xDisplay, this.vinfo, 8, value);
        data.redSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 9, value);
        data.greenSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 10, value);
        data.blueSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 11, value);
        data.alphaSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 12, value);
        data.depthSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 13, value);
        data.stencilSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 14, value);
        data.accumRedSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 15, value);
        data.accumGreenSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 16, value);
        data.accumBlueSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 17, value);
        data.accumAlphaSize = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 100000, value);
        data.sampleBuffers = value[0];
        GLX.glXGetConfig(xDisplay, this.vinfo, 100001, value);
        data.samples = value[0];
        return data;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return GLX.glXGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (GLX.glXGetCurrentContext() == this.context) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        GLX.glXMakeCurrent(xDisplay, this.xWindow, this.context);
    }

    public void swapBuffers() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        GLX.glXSwapBuffers(xDisplay, this.xWindow);
    }
}

