/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.addons.dndaddon.CursorInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StackDropAgent
extends DropAgent {
    public boolean canDrop(MUIElement dragElement, CursorInfo info) {
        if (info.curElement == dragElement.getParent() && info.curElement != null && info.curElement == dragElement.getParent()) {
            CTabFolder ctf = (CTabFolder)dragElement.getParent().getWidget();
            return ctf.getItemCount() > 1;
        }
        return dragElement instanceof MPart && info.curElement instanceof MPartStack;
    }

    public boolean drop(MUIElement dragElement, CursorInfo info) {
        MPartStack dropStack = (MPartStack)info.curElement;
        if (dragElement.getCurSharedRef() != null) {
            dragElement = dragElement.getCurSharedRef();
        }
        if (dragElement.getParent() == info.curElement) {
            CTabFolder ctf = (CTabFolder)dropStack.getWidget();
            CTabItem[] cTabItemArray = ctf.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem cti = cTabItemArray[n2];
                if (cti.getData("modelElement") == dragElement && info.itemIndex >= 0 && ctf.indexOf(cti) < info.itemIndex) {
                    --info.itemIndex;
                }
                ++n2;
            }
        }
        if (dragElement.getParent() != null) {
            dragElement.getParent().getChildren().remove(dragElement);
        }
        if (info.itemIndex == -1) {
            dropStack.getChildren().add((MStackElement)dragElement);
        } else {
            dropStack.getChildren().add(info.itemIndex, (MStackElement)dragElement);
        }
        dropStack.setSelectedElement((MUIElement)((MStackElement)dragElement));
        return true;
    }

    public Rectangle getRectangle(MUIElement dragElement, CursorInfo info) {
        CTabFolder ctf = (CTabFolder)info.curElement.getWidget();
        if (info.itemElement != null) {
            if (info.curElement.getWidget() instanceof CTabFolder) {
                CTabItem[] cTabItemArray = ctf.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem cti = cTabItemArray[n2];
                    if (cti.getData("modelElement") == info.itemElement || cti.getData("modelElement") == info.itemElementRef) {
                        Rectangle itemRect = cti.getBounds();
                        itemRect.width = 3;
                        return cti.getDisplay().map((Control)cti.getParent(), null, itemRect);
                    }
                    ++n2;
                }
            }
        } else {
            if (ctf.getItemCount() == 0) {
                Rectangle ctfBounds = ctf.getBounds();
                ctfBounds.height = ctf.getTabHeight();
                ctfBounds.width = 3;
                return ctf.getDisplay().map((Control)ctf, null, ctfBounds);
            }
            CTabItem cti = ctf.getItem(ctf.getItemCount() - 1);
            Rectangle itemRect = cti.getBounds();
            itemRect.x = itemRect.x + itemRect.width - 3;
            itemRect.width = 3;
            return cti.getDisplay().map((Control)cti.getParent(), null, itemRect);
        }
        return null;
    }
}

