/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.di;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.internal.extensions.EventObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class UIEventObjectSupplier
extends EventObjectSupplier {
    @Inject
    @Optional
    protected Display contextDisplay;
    @Inject
    @Optional
    protected Logger logger;

    protected EventHandler makeHandler(IRequestor requestor) {
        return new UIEventHandler(requestor);
    }

    protected String getTopic(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        UIEventTopic qualifier = (UIEventTopic)descriptor.getQualifier(UIEventTopic.class);
        return qualifier.value();
    }

    class UIEventHandler
    implements EventHandler {
        protected final IRequestor requestor;

        public UIEventHandler(IRequestor requestor) {
            this.requestor = requestor;
        }

        public void handleEvent(Event event) {
            UIEventObjectSupplier.this.addCurrentEvent(event.getTopic(), event);
            this.requestor.resolveArguments();
            UIEventObjectSupplier.this.removeCurrentEvent(event.getTopic());
            Display display = this.getDisplay();
            if (display == null || display.isDisposed()) {
                if (UIEventObjectSupplier.this.logger != null) {
                    UIEventObjectSupplier.this.logger.log(Level.WARNING, "No display found to process UI event " + event);
                }
                return;
            }
            display.syncExec(new Runnable(){

                public void run() {
                    UIEventHandler.this.requestor.execute();
                }
            });
        }

        private Display getDisplay() {
            if (UIEventObjectSupplier.this.contextDisplay != null) {
                return UIEventObjectSupplier.this.contextDisplay;
            }
            Display display = Display.getCurrent();
            if (display != null) {
                return display;
            }
            try {
                return Display.getDefault();
            }
            catch (SWTException sWTException) {
                return null;
            }
        }
    }
}

