/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.impl.dom.StyleSheetListImpl;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class DocumentCSSImpl
implements ExtendedDocumentCSS {
    private StyleSheetListImpl styleSheetList = new StyleSheetListImpl();
    private Map styleDeclarationMap = null;

    public StyleSheetList getStyleSheets() {
        return this.styleSheetList;
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String s) {
        return null;
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        this.styleSheetList.addStyleSheet(styleSheet);
    }

    public void removeAllStyleSheets() {
        this.styleSheetList.removeAllStyleSheets();
        this.styleDeclarationMap = null;
    }

    public List queryConditionSelector(int conditionType) {
        return this.querySelector(0, conditionType);
    }

    public List querySelector(int selectorType, int conditionType) {
        List list = this.getCSSStyleDeclarationList(selectorType, conditionType);
        if (list != null) {
            return list;
        }
        int l = this.styleSheetList.getLength();
        int i = 0;
        while (i < l) {
            CSSStyleSheet styleSheet = (CSSStyleSheet)this.styleSheetList.item(i);
            CSSRuleList ruleList = styleSheet.getCssRules();
            list = this.querySelector(ruleList, selectorType, conditionType);
            this.setCSSStyleDeclarationList(list, selectorType, conditionType);
            ++i;
        }
        return list;
    }

    protected List querySelector(CSSRuleList ruleList, int selectorType, int selectorConditionType) {
        ArrayList<Selector> list = new ArrayList<Selector>();
        int length = ruleList.getLength();
        int i = 0;
        while (i < length) {
            CSSRule rule = ruleList.item(i);
            switch (rule.getType()) {
                case 1: {
                    if (!(rule instanceof ExtendedCSSRule)) break;
                    ExtendedCSSRule r = (ExtendedCSSRule)rule;
                    SelectorList selectorList = r.getSelectorList();
                    int l = selectorList.getLength();
                    int j = 0;
                    while (j < l) {
                        Selector selector = selectorList.item(j);
                        if (selector.getSelectorType() == selectorType) {
                            switch (selectorType) {
                                case 0: {
                                    ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                                    short conditionType = conditionalSelector.getCondition().getConditionType();
                                    if (selectorConditionType != conditionType) break;
                                    list.add(selector);
                                }
                            }
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    protected List getCSSStyleDeclarationList(int selectorType, int conditionType) {
        Integer key = this.getKey(selectorType, conditionType);
        return (List)this.getStyleDeclarationMap().get(key);
    }

    protected void setCSSStyleDeclarationList(List list, int selectorType, int conditionType) {
        Integer key = this.getKey(selectorType, conditionType);
        this.getStyleDeclarationMap().put(key, list);
    }

    protected Integer getKey(int selectorType, int conditionType) {
        if (selectorType == 0) {
            if (conditionType == SAC_CLASS_CONDITION) {
                return SAC_CLASS_CONDITION;
            }
            if (conditionType == SAC_ID_CONDITION) {
                return SAC_ID_CONDITION;
            }
            if (conditionType == SAC_PSEUDO_CLASS_CONDITION) {
                return SAC_PSEUDO_CLASS_CONDITION;
            }
            return OTHER_SAC_CONDITIONAL_SELECTOR;
        }
        return OTHER_SAC_SELECTOR;
    }

    protected Map getStyleDeclarationMap() {
        if (this.styleDeclarationMap == null) {
            this.styleDeclarationMap = new HashMap();
        }
        return this.styleDeclarationMap;
    }
}

