/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellActivationListener
implements Listener {
    public static final String DIALOG_IGNORE_KEY = "org.eclipse.e4.ui.ignoreDialog";
    private static final String ECLIPSE_CONTEXT_DIALOG_ID = "org.eclipse.e4.ui.dialogContext";
    private static final String ECLIPSE_CONTEXT_PREV_CHILD = "org.eclipse.e4.ui.dialogContext.prevChild";
    private MApplication application;

    ShellActivationListener(MApplication application) {
        this.application = application;
    }

    public void handleEvent(Event event) {
        if (!(event.widget instanceof Shell)) {
            return;
        }
        Shell shell = (Shell)event.widget;
        Object obj = shell.getData("modelElement");
        if (obj instanceof MWindow) {
            if (event.type == 27) {
                Object local = ((MWindow)obj).getContext().getLocal("activeChildContext");
                WorkbenchSWTActivator.trace("/trace/workbench", "setting mwindow context " + local, null);
                shell.setData(ECLIPSE_CONTEXT_PREV_CHILD, local);
            }
            return;
        }
        obj = shell.getData(DIALOG_IGNORE_KEY);
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            return;
        }
        switch (event.type) {
            case 26: {
                this.activate(shell);
                break;
            }
            case 27: {
                this.deactivate(shell);
            }
        }
    }

    private void activate(Shell shell) {
        final IEclipseContext parentContext = this.getParentContext(shell);
        final IEclipseContext shellContext = this.getShellContext(shell, parentContext);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                parentContext.set("activeChildContext", (Object)shellContext);
            }

            public void handleException(Throwable exception) {
                WorkbenchSWTActivator.trace("/trace/workbench", "failed setting dialog child", exception);
            }
        });
    }

    private void deactivate(Shell shell) {
        Shell parent = (Shell)shell.getParent();
        if (parent == null) {
            return;
        }
        final IEclipseContext prevChild = (IEclipseContext)parent.getData(ECLIPSE_CONTEXT_PREV_CHILD);
        if (prevChild == null) {
            return;
        }
        final IEclipseContext parentContext = this.getParentContext(shell);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                parentContext.set("activeChildContext", (Object)prevChild);
            }

            public void handleException(Throwable exception) {
                WorkbenchSWTActivator.trace("/trace/workbench", "failed resetting previous child", exception);
            }
        });
    }

    private IEclipseContext getShellContext(final Shell shell, IEclipseContext parentContext) {
        IEclipseContext shellContext = (IEclipseContext)shell.getData(ECLIPSE_CONTEXT_DIALOG_ID);
        if (shellContext != null) {
            return shellContext;
        }
        final IEclipseContext context = parentContext.createChild("org.eclipse.ui.contexts.dialog");
        context.set("localActiveShell", (Object)shell);
        shell.setData(ECLIPSE_CONTEXT_DIALOG_ID, (Object)context);
        EContextService contextService = (EContextService)context.get(EContextService.class);
        contextService.activateContext("org.eclipse.ui.contexts.dialog");
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ShellActivationListener.this.deactivate(shell);
                context.dispose();
            }
        });
        return context;
    }

    private IEclipseContext getParentContext(Shell shell) {
        IEclipseContext shellContext = (IEclipseContext)shell.getData(ECLIPSE_CONTEXT_DIALOG_ID);
        if (shellContext != null) {
            return shellContext.getParent();
        }
        Shell current = null;
        Shell parent = (Shell)shell.getParent();
        while (parent != null) {
            current = parent;
            Object obj = current.getData("modelElement");
            if (obj instanceof MWindow) {
                return ((MWindow)obj).getContext();
            }
            obj = current.getData(ECLIPSE_CONTEXT_DIALOG_ID);
            if (obj != null) {
                return (IEclipseContext)obj;
            }
            parent = (Shell)parent.getParent();
        }
        return this.application.getContext();
    }
}

