/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTable {
    public static final Comparator<Binding> BEST_SEQUENCE = new Comparator<Binding>(){

        @Override
        public int compare(Binding o1, Binding o2) {
            Trigger[] currentTriggers;
            Trigger[] bestTriggers = o1.getTriggerSequence().getTriggers();
            int compareTo = bestTriggers.length - (currentTriggers = o2.getTriggerSequence().getTriggers()).length;
            if (compareTo != 0) {
                return compareTo;
            }
            compareTo = this.countStrokes(bestTriggers) - this.countStrokes(currentTriggers);
            if (compareTo != 0) {
                return compareTo;
            }
            return o1.getTriggerSequence().format().length() - o2.getTriggerSequence().format().length();
        }

        private final int countStrokes(Trigger[] triggers) {
            int strokeCount = triggers.length;
            int i = 0;
            while (i < triggers.length) {
                Trigger trigger = triggers[i];
                if (trigger instanceof KeyStroke) {
                    IKeyLookup lookup;
                    KeyStroke keyStroke = (KeyStroke)trigger;
                    int modifierKeys = keyStroke.getModifierKeys();
                    if ((modifierKeys & (lookup = KeyLookupFactory.getDefault()).getAlt()) != 0) {
                        strokeCount += 8;
                    }
                    if ((modifierKeys & lookup.getCtrl()) != 0) {
                        strokeCount += 2;
                    }
                    if ((modifierKeys & lookup.getShift()) != 0) {
                        strokeCount += 4;
                    }
                    if ((modifierKeys & lookup.getCommand()) != 0) {
                        strokeCount += 2;
                    }
                } else {
                    strokeCount += 99;
                }
                ++i;
            }
            return strokeCount;
        }
    };
    private Context tableId;
    private ArrayList<Binding> bindings = new ArrayList();
    private Map<TriggerSequence, Binding> bindingsByTrigger = new HashMap<TriggerSequence, Binding>();
    private Map<ParameterizedCommand, ArrayList<Binding>> bindingsByCommand = new HashMap<ParameterizedCommand, ArrayList<Binding>>();
    private Map<TriggerSequence, ArrayList<Binding>> bindingsByPrefix = new HashMap<TriggerSequence, ArrayList<Binding>>();

    public BindingTable(Context context) {
        this.tableId = context;
    }

    public Context getTableId() {
        return this.tableId;
    }

    public String getId() {
        return this.tableId.getId();
    }

    public void addBinding(Binding binding) {
        if (!this.getId().equals(binding.getContextId())) {
            throw new IllegalArgumentException("Binding context " + binding.getContextId() + " does not match " + this.getId());
        }
        this.bindings.add(binding);
        this.bindingsByTrigger.put(binding.getTriggerSequence(), binding);
        ArrayList<Object> sequences = this.bindingsByCommand.get(binding.getParameterizedCommand());
        if (sequences == null) {
            sequences = new ArrayList();
            this.bindingsByCommand.put(binding.getParameterizedCommand(), sequences);
        }
        sequences.add(binding);
        Collections.sort(sequences, BEST_SEQUENCE);
        TriggerSequence[] prefs = binding.getTriggerSequence().getPrefixes();
        int i = 1;
        while (i < prefs.length) {
            ArrayList<Object> bindings = this.bindingsByPrefix.get(prefs[i]);
            if (bindings == null) {
                bindings = new ArrayList();
                this.bindingsByPrefix.put(prefs[i], bindings);
            }
            bindings.add(binding);
            ++i;
        }
    }

    public void removeBinding(Binding binding) {
        if (!this.getId().equals(binding.getContextId())) {
            throw new IllegalArgumentException("Binding context " + binding.getContextId() + " does not match " + this.getId());
        }
        this.bindings.remove(binding);
        this.bindingsByTrigger.remove(binding.getTriggerSequence());
        ArrayList<Binding> sequences = this.bindingsByCommand.get(binding.getParameterizedCommand());
        sequences.remove(binding);
        TriggerSequence[] prefs = binding.getTriggerSequence().getPrefixes();
        int i = 1;
        while (i < prefs.length) {
            ArrayList<Binding> bindings = this.bindingsByPrefix.get(prefs[i]);
            bindings.remove(binding);
            ++i;
        }
    }

    public Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingsByTrigger.get(trigger);
    }

    public Binding getBestSequenceFor(ParameterizedCommand command) {
        ArrayList<Binding> sequences = this.bindingsByCommand.get(command);
        if (sequences != null && sequences.size() > 0) {
            return sequences.get(0);
        }
        return null;
    }

    public Collection<Binding> getSequencesFor(ParameterizedCommand command) {
        ArrayList<Binding> triggers = this.bindingsByCommand.get(command);
        return (Collection)(triggers == null ? Collections.EMPTY_LIST : triggers.clone());
    }

    public Collection<Binding> getPartialMatches(TriggerSequence sequence) {
        return this.bindingsByPrefix.get(sequence);
    }

    public boolean isPartialMatch(TriggerSequence seq) {
        return this.bindingsByPrefix.get(seq) != null;
    }
}

