/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jface.dialogs.MessageDialog;

public class StepIntoSelectionHandler
implements IDebugEventFilter {
    private IMethod fMethod;
    private String fResolvedSignature;
    private IJavaThread fThread;
    private String fOriginalName;
    private String fOriginalSignature;
    private String fOriginalTypeName;
    private int fOriginalStackDepth;
    private boolean fFirstStep = true;
    private boolean fStepFilterEnabledState;
    private int fExpectedKind = -1;
    private int fExpectedDetail = -1;

    public StepIntoSelectionHandler(IJavaThread thread, IJavaStackFrame frame, IMethod method) {
        this.fMethod = method;
        this.fThread = thread;
        try {
            this.fOriginalName = frame.getName();
            this.fOriginalSignature = frame.getSignature();
            this.fOriginalTypeName = frame.getDeclaringTypeName();
            this.fResolvedSignature = method.isBinary() ? method.getSignature() : ToggleBreakpointAdapter.resolveMethodSignature(method);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected IJavaThread getThread() {
        return this.fThread;
    }

    protected IJavaDebugTarget getDebugTarget() {
        return (IJavaDebugTarget)this.getThread().getDebugTarget();
    }

    protected IMethod getMethod() {
        return this.fMethod;
    }

    protected String getSignature() {
        return this.fResolvedSignature;
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        DebugEvent event = null;
        int index = -1;
        int threadEvents = 0;
        int i = 0;
        while (i < events.length) {
            DebugEvent e = events[i];
            if (this.isExpectedEvent(e)) {
                event = e;
                index = i;
                ++threadEvents;
            } else if (e.getSource() == this.getThread()) {
                ++threadEvents;
            }
            ++i;
        }
        if (event == null) {
            return events;
        }
        DebugEvent[] filtered = new DebugEvent[events.length - 1];
        if (filtered.length > 0) {
            int j = 0;
            int i2 = 0;
            while (i2 < events.length) {
                if (i2 != index) {
                    filtered[j] = events[i2];
                    ++j;
                }
                ++i2;
            }
        }
        if (threadEvents > 1) {
            this.cleanup();
            return filtered;
        }
        switch (event.getKind()) {
            case 1: {
                this.setExpectedEvent(2, 8);
                if (this.fFirstStep) {
                    this.fFirstStep = false;
                    return events;
                }
                return filtered;
            }
            case 2: {
                try {
                    final IJavaStackFrame frame = (IJavaStackFrame)this.getThread().getTopStackFrame();
                    int stackDepth = frame.getThread().getStackFrames().length;
                    String name = null;
                    if (frame.isConstructor()) {
                        name = frame.getDeclaringTypeName();
                        index = name.lastIndexOf(46);
                        if (index >= 0) {
                            name = name.substring(index + 1);
                        }
                    } else {
                        name = frame.getName();
                    }
                    if (name.equals(this.getMethod().getElementName()) && frame.getSignature().equals(this.getSignature())) {
                        this.cleanup();
                        return events;
                    }
                    Runnable r = null;
                    if (stackDepth > this.fOriginalStackDepth) {
                        r = frame.isSynthetic() ? new Runnable(){

                            public void run() {
                                try {
                                    StepIntoSelectionHandler.this.setExpectedEvent(1, 1);
                                    frame.stepInto();
                                }
                                catch (DebugException e) {
                                    JDIDebugUIPlugin.log(e);
                                    StepIntoSelectionHandler.this.cleanup();
                                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                }
                            }
                        } : new Runnable(){

                            public void run() {
                                try {
                                    StepIntoSelectionHandler.this.setExpectedEvent(1, 4);
                                    frame.stepReturn();
                                }
                                catch (DebugException e) {
                                    JDIDebugUIPlugin.log(e);
                                    StepIntoSelectionHandler.this.cleanup();
                                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                }
                            }
                        };
                    } else if (stackDepth == this.fOriginalStackDepth) {
                        if (!(frame.getSignature().equals(this.fOriginalSignature) && frame.getName().equals(this.fOriginalName) && frame.getDeclaringTypeName().equals(this.fOriginalTypeName))) {
                            this.missed();
                            return events;
                        }
                        r = new Runnable(){

                            public void run() {
                                try {
                                    StepIntoSelectionHandler.this.setExpectedEvent(1, 1);
                                    frame.stepInto();
                                }
                                catch (DebugException e) {
                                    JDIDebugUIPlugin.log(e);
                                    StepIntoSelectionHandler.this.cleanup();
                                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                }
                            }
                        };
                    } else {
                        this.missed();
                        return events;
                    }
                    DebugPlugin.getDefault().asyncExec(r);
                    return filtered;
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                    this.cleanup();
                    return events;
                }
            }
        }
        return events;
    }

    protected void missed() {
        this.cleanup();
        Runnable r = new Runnable(){

            public void run() {
                String methodName = null;
                try {
                    methodName = Signature.toString((String)StepIntoSelectionHandler.this.getMethod().getSignature(), (String)StepIntoSelectionHandler.this.getMethod().getElementName(), (String[])StepIntoSelectionHandler.this.getMethod().getParameterNames(), (boolean)false, (boolean)false);
                }
                catch (JavaModelException javaModelException) {
                    methodName = StepIntoSelectionHandler.this.getMethod().getElementName();
                }
                new MessageDialog(JDIDebugUIPlugin.getActiveWorkbenchShell(), ActionMessages.StepIntoSelectionHandler_1, null, MessageFormat.format((String)ActionMessages.StepIntoSelectionHandler_Execution_did_not_enter____0____before_the_current_method_returned__1, (Object[])new String[]{methodName}), 2, new String[]{ActionMessages.StepIntoSelectionHandler_2}, 0).open();
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void step() {
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
        this.fStepFilterEnabledState = this.getDebugTarget().isStepFiltersEnabled();
        this.getDebugTarget().setStepFiltersEnabled(false);
        try {
            this.fOriginalStackDepth = this.getThread().getStackFrames().length;
            this.setExpectedEvent(1, 1);
            this.getThread().stepInto();
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            this.cleanup();
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.getDebugTarget(), 16)});
        }
    }

    protected void cleanup() {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
        this.getDebugTarget().setStepFiltersEnabled(this.fStepFilterEnabledState);
    }

    private void setExpectedEvent(int kind, int detail) {
        this.fExpectedKind = kind;
        this.fExpectedDetail = detail;
    }

    protected boolean isExpectedEvent(DebugEvent event) {
        return event.getSource().equals(this.getThread()) && event.getKind() == this.fExpectedKind && event.getDetail() == this.fExpectedDetail;
    }
}

