/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jdt.junit.TestRunListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class JUnitCorePlugin
extends Plugin {
    private static JUnitCorePlugin fgPlugin = null;
    public static final String CORE_PLUGIN_ID = "org.eclipse.jdt.junit.core";
    public static final String PLUGIN_ID = "org.eclipse.jdt.junit";
    public static final String ID_EXTENSION_POINT_TESTRUN_LISTENERS = "org.eclipse.jdt.junit.testRunListeners";
    public static final String ID_EXTENSION_POINT_TEST_KINDS = "org.eclipse.jdt.junit.internal_testKinds";
    public static final String TEST_SUPERCLASS_NAME = "junit.framework.TestCase";
    public static final String TEST_INTERFACE_NAME = "junit.framework.Test";
    public static final String JUNIT4_ANNOTATION_NAME = "org.junit.Test";
    public static final String SIMPLE_TEST_INTERFACE_NAME = "Test";
    public static final String JUNIT_HOME = "JUNIT_HOME";
    public static final String JUNIT_SRC_HOME = "JUNIT_SRC_HOME";
    private static final String HISTORY_DIR_NAME = "history";
    private final JUnitModel fJUnitModel = new JUnitModel();
    private List fLegacyTestRunListeners;
    private ListenerList fNewTestRunListeners;
    private BundleContext fBundleContext;
    private static boolean fIsStopped = false;
    static /* synthetic */ Class class$0;

    public JUnitCorePlugin() {
        fgPlugin = this;
        this.fNewTestRunListeners = new ListenerList();
    }

    public static JUnitCorePlugin getDefault() {
        return fgPlugin;
    }

    public static String getPluginId() {
        return CORE_PLUGIN_ID;
    }

    public static void log(Throwable e) {
        JUnitCorePlugin.log((IStatus)new Status(4, JUnitCorePlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitCorePlugin.getDefault().getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.fJUnitModel.start();
    }

    public void stop(BundleContext context) throws Exception {
        fIsStopped = true;
        try {
            this.fJUnitModel.stop();
        }
        finally {
            super.stop(context);
        }
        this.fBundleContext = null;
    }

    public Object getService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.fBundleContext.getService(reference);
    }

    public static JUnitModel getModel() {
        return JUnitCorePlugin.getDefault().fJUnitModel;
    }

    private synchronized void loadTestRunListeners() {
        if (this.fLegacyTestRunListeners != null) {
            return;
        }
        this.fLegacyTestRunListeners = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_LISTENERS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(CORE_PLUGIN_ID, 0, "Could not load some testRunner extension points", null);
        int i = 0;
        while (i < configs.length) {
            try {
                Object testRunListener = configs[i].createExecutableExtension("class");
                if (testRunListener instanceof TestRunListener) {
                    this.fNewTestRunListeners.add(testRunListener);
                } else if (testRunListener instanceof ITestRunListener) {
                    this.fLegacyTestRunListeners.add(testRunListener);
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            JUnitCorePlugin.log((IStatus)status);
        }
    }

    public ITestRunListener[] getTestRunListeners() {
        this.loadTestRunListeners();
        return this.fLegacyTestRunListeners.toArray(new ITestRunListener[this.fLegacyTestRunListeners.size()]);
    }

    public Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Bundle[] getBundles(String bundleName, String version) {
        ServiceReference serviceRef;
        PackageAdmin admin;
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bundles = (admin = (PackageAdmin)this.fBundleContext.getService(serviceRef = this.fBundleContext.getServiceReference(clazz.getName()))).getBundles(bundleName, version)) != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public void addTestRunListener(ITestRunListener newListener) {
        this.loadTestRunListeners();
        Iterator iter = this.fLegacyTestRunListeners.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o != newListener) continue;
            return;
        }
        this.fLegacyTestRunListeners.add(newListener);
    }

    public void removeTestRunListener(ITestRunListener newListener) {
        if (this.fLegacyTestRunListeners != null) {
            this.fLegacyTestRunListeners.remove(newListener);
        }
    }

    public ListenerList getNewTestRunListeners() {
        this.loadTestRunListeners();
        return this.fNewTestRunListeners;
    }

    public static boolean isStopped() {
        return fIsStopped;
    }

    public static File getHistoryDirectory() throws IllegalStateException {
        File historyDir = JUnitCorePlugin.getDefault().getStateLocation().append(HISTORY_DIR_NAME).toFile();
        if (!historyDir.isDirectory()) {
            historyDir.mkdir();
        }
        return historyDir;
    }
}

