/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.wizards.CompareOperation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class CompareToBaselineWizardPage
extends WizardPage {
    static final String SETTINGS_SECTION = "org.eclipse.pde.api.tools.ui.api.compare";
    static final String BASELINE_STATE = "org.eclipse.pde.api.tools.ui.api.compare.baseline";
    private IStructuredSelection selection = null;
    private Combo baselinecombo = null;
    String baselineName = null;
    private Link link = null;
    static /* synthetic */ Class class$0;

    protected CompareToBaselineWizardPage(IStructuredSelection selection) {
        super(ActionMessages.CompareDialogTitle);
        this.selection = selection;
        this.setTitle(ActionMessages.CompareToBaselineWizardPage_compare_with_baseline);
        this.setMessage(ActionMessages.CompareToBaselineWizardPage_compare_with_selected_baseline);
        this.setImageDescriptor(ApiUIPlugin.getImageDescriptor("IMG_WIZBAN_COMPARE_TO_BASELINE"));
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 768);
        this.setControl((Control)comp);
        SWTFactory.createLabel(comp, ActionMessages.SelectABaseline, 1);
        this.baselinecombo = SWTFactory.createCombo(comp, 0x800808, 1, 768, null);
        this.baselinecombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedBaselineName;
                Combo combo = (Combo)e.widget;
                String[] baselineNames = (String[])combo.getData();
                CompareToBaselineWizardPage.this.baselineName = selectedBaselineName = baselineNames[combo.getSelectionIndex()];
                CompareToBaselineWizardPage.this.setPageComplete(CompareToBaselineWizardPage.this.isPageComplete());
            }
        });
        this.link = SWTFactory.createLink(comp, ActionMessages.AddNewBaseline, JFaceResources.getDialogFont(), 1, 896);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAdaptable element = CompareToBaselineWizardPage.this.getAdaptable();
                if (element == null) {
                    return;
                }
                CompareToBaselineWizardPage.this.baselineName = null;
                SWTFactory.showPreferencePage(CompareToBaselineWizardPage.this.getShell(), "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage", element);
                CompareToBaselineWizardPage.this.initialize();
                CompareToBaselineWizardPage.this.setPageComplete(CompareToBaselineWizardPage.this.isPageComplete());
            }
        });
        this.link.setToolTipText(ActionMessages.CompareToBaselineWizardPage_open_baseline_pref_page);
        this.initialize();
        this.getShell().pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_COMPARE_WIZARD_PAGE);
    }

    public boolean isPageComplete() {
        if (this.baselineName == null || "".equals(this.baselineName)) {
            this.setMessage(ActionMessages.CompareToBaselineWizardPage_create_baseline);
            this.link.forceFocus();
            return false;
        }
        this.setMessage(ActionMessages.CompareToBaselineWizardPage_compare_with_selected_baseline);
        this.baselinecombo.setFocus();
        return true;
    }

    void initialize() {
        IApiBaselineManager apiBaselineManager = ApiPlugin.getDefault().getApiBaselineManager();
        IApiBaseline defaultBaseline = apiBaselineManager.getDefaultApiBaseline();
        String defaultBaselineName = defaultBaseline != null ? defaultBaseline.getName() : null;
        IApiBaseline[] baselines = apiBaselineManager.getApiBaselines();
        int length = baselines.length;
        String[] baselinesItems = new String[length];
        Object[] baselinesNames = new String[length];
        int i = 0;
        while (i < length) {
            String currentBaselineName = baselines[i].getName();
            baselinesNames[i] = currentBaselineName;
            ++i;
        }
        Arrays.sort(baselinesNames);
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            Object currentBaselineName = baselinesNames[i2];
            if (defaultBaselineName != null && defaultBaselineName.equals(currentBaselineName)) {
                baselinesItems[i2] = NLS.bind((String)ActionMessages.SetAsDefault, (Object)currentBaselineName);
                this.baselineName = currentBaselineName;
                index = i2;
            } else {
                baselinesItems[i2] = currentBaselineName;
            }
            ++i2;
        }
        this.baselinecombo.setItems(baselinesItems);
        this.baselinecombo.setData((Object)baselinesNames);
        this.baselinecombo.select(index);
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.restoreComboSelection(this.baselinecombo, BASELINE_STATE, settings, (String[])baselinesNames);
        }
    }

    private void restoreComboSelection(Combo combo, String id, IDialogSettings settings, String[] baselinesNames) {
        String value = settings.get(id);
        if (value != null) {
            int index = 0;
            int length = baselinesNames.length;
            int i = 0;
            while (i < length) {
                String currentBaselineName = baselinesNames[i];
                if (value.equals(currentBaselineName)) {
                    this.baselineName = value;
                    index = i;
                    break;
                }
                ++i;
            }
            combo.select(index);
        }
    }

    IAdaptable getAdaptable() {
        Object o = this.selection.getFirstElement();
        if (o instanceof IAdaptable) {
            IResource resource;
            IAdaptable adapt = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adapt.getAdapter((Class)clazz)) != null) {
                return resource instanceof IProject ? resource : resource.getProject();
            }
        }
        return null;
    }

    boolean finish() {
        this.saveWidgetState();
        IApiBaseline baseline = ApiBaselineManager.getManager().getApiBaseline(this.baselineName);
        if (baseline == null) {
            return false;
        }
        CompareOperation op = new CompareOperation(baseline, this.selection);
        op.setSystem(false);
        op.setPriority(30);
        op.schedule();
        return true;
    }

    void saveWidgetState() {
        IDialogSettings rootsettings = ApiUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = rootsettings.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = rootsettings.addNewSection(SETTINGS_SECTION);
        }
        settings.put(BASELINE_STATE, this.baselineName);
    }
}

