/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.IOException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.services.EclipseAdapter;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.internal.workbench.ActiveChildLookupFunction;
import org.eclipse.e4.ui.internal.workbench.ActivePartLookupFunction;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ExceptionHandler;
import org.eclipse.e4.ui.internal.workbench.ReflectionContributionFactory;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.internal.workbench.WorkbenchLogger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IExceptionHandler;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class E4Application
implements IApplication {
    private String[] args;
    private IModelResourceHandler handler;
    private Display display = null;
    public static final String THEME_ID = "cssTheme";

    public Display getApplicationDisplay() {
        if (this.display == null) {
            this.display = Display.getDefault();
        }
        return this.display;
    }

    public Object start(IApplicationContext applicationContext) throws Exception {
        Display display = this.getApplicationDisplay();
        E4Workbench workbench = this.createE4Workbench(applicationContext);
        IEclipseContext workbenchContext = workbench.getContext();
        workbenchContext.set(Display.class, (Object)display);
        workbench.createAndRunUI((MApplicationElement)workbench.getApplication());
        this.saveModel();
        workbench.close();
        return 0;
    }

    public void saveModel() {
        try {
            this.handler.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public E4Workbench createE4Workbench(IApplicationContext applicationContext) {
        this.args = (String[])applicationContext.getArguments().get("application.args");
        IEclipseContext appContext = E4Application.createDefaultContext();
        appContext.set(IApplicationContext.class, (Object)applicationContext);
        IContributionFactory factory = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
        String lifeCycleURI = this.getArgValue("lifeCycleURI", applicationContext);
        Object lcManager = null;
        if (lifeCycleURI != null && (lcManager = factory.create(lifeCycleURI, appContext)) != null) {
            factory.call(lcManager, null, "postContextCreate", appContext, null);
        }
        MApplication appModel = this.loadApplicationModel(applicationContext, appContext);
        appModel.setContext(appContext);
        if (!E4Workbench.getServiceContext().containsKey(MApplication.class.getName())) {
            E4Workbench.getServiceContext().set(MApplication.class.getName(), (Object)appModel);
        }
        appContext.set(MApplication.class.getName(), (Object)appModel);
        if (lcManager != null) {
            factory.call(lcManager, null, "processAdditions", appContext, null);
            factory.call(lcManager, null, "processRemovals", appContext, null);
        }
        for (MContribution addon : appModel.getAddons()) {
            Object obj = factory.create(addon.getContributionURI(), appContext);
            addon.setObject(obj);
        }
        String xmiURI = this.getArgValue("applicationXMI", applicationContext);
        appContext.set("applicationXMI", (Object)xmiURI);
        String themeId = this.getArgValue(THEME_ID, applicationContext);
        appContext.set(THEME_ID, (Object)themeId);
        String cssURI = this.getArgValue("applicationCSS", applicationContext);
        if (cssURI != null) {
            appContext.set("applicationCSS", (Object)cssURI);
        }
        if (cssURI != null && !cssURI.startsWith("platform:")) {
            System.err.println("Warning " + cssURI + " changed its meaning it is used now to run without theme support");
            appContext.set(THEME_ID, (Object)cssURI);
        }
        String cssResourcesURI = this.getArgValue("applicationCSSResources", applicationContext);
        appContext.set("applicationCSSResources", (Object)cssResourcesURI);
        appContext.set("rendererFactoryUri", (Object)this.getArgValue("rendererFactoryUri", applicationContext));
        String presentationURI = this.getArgValue("presentationURI", applicationContext);
        if (presentationURI == null) {
            presentationURI = "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
        }
        appContext.set("presentationURI", (Object)presentationURI);
        E4Workbench workbench = new E4Workbench((MApplicationElement)appModel, appContext);
        return workbench;
    }

    private MApplication loadApplicationModel(IApplicationContext appContext, IEclipseContext eclipseContext) {
        MApplication theApp = null;
        Location instanceLocation = WorkbenchSWTActivator.getDefault().getInstanceLocation();
        String appModelPath = this.getArgValue("applicationXMI", appContext);
        Assert.isNotNull((Object)appModelPath, (String)"applicationXMI argument missing");
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appModelPath, (boolean)true);
        String value = this.getArgValue("saveAndRestore", appContext);
        boolean saveAndRestore = value == null || Boolean.getBoolean(value);
        eclipseContext.set("saveAndRestore", (Object)saveAndRestore);
        eclipseContext.set("initialWorkbenchModelURI", (Object)initialWorkbenchDefinitionInstance);
        eclipseContext.set("instanceLocation", (Object)instanceLocation);
        String resourceHandler = this.getArgValue("modelResourceHandler", appContext);
        if (resourceHandler == null) {
            resourceHandler = "platform:/plugin/org.eclipse.e4.ui.workbench/" + ResourceHandler.class.getName();
        }
        IContributionFactory factory = (IContributionFactory)eclipseContext.get(IContributionFactory.class);
        this.handler = (IModelResourceHandler)factory.create(resourceHandler, eclipseContext);
        Resource resource = this.handler.loadMostRecentModel();
        theApp = (MApplication)resource.getContents().get(0);
        return theApp;
    }

    private String getArgValue(String argName, IApplicationContext appContext) {
        if (argName == null || argName.length() == 0) {
            return null;
        }
        int i = 0;
        while (i < this.args.length) {
            if (argName.equals(this.args[i])) {
                return this.args[i + 1];
            }
            i += 2;
        }
        return appContext.getBrandingProperty(argName);
    }

    public void stop() {
    }

    public static IEclipseContext createDefaultContext() {
        IEclipseContext serviceContext = E4Workbench.getServiceContext();
        final IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        ReflectionContributionFactory contributionFactory = new ReflectionContributionFactory(registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(Logger.class.getName(), ContextInjectionFactory.make(WorkbenchLogger.class, (IEclipseContext)appContext));
        appContext.set(Adapter.class.getName(), ContextInjectionFactory.make(EclipseAdapter.class, (IEclipseContext)appContext));
        appContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        appContext.set("activeContexts", (Object)new ActiveContextsFunction());
        appContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        appContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                Object o = appContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    appContext.set("activePartId", (Object)((MPart)o).getElementId());
                }
                return true;
            }

            public String toString() {
                return "activePartId";
            }
        });
        appContext.set("partServiceRoot", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                MContext perceivedRoot = (MContext)context.get(MWindow.class.getName());
                if (perceivedRoot == null && (perceivedRoot = (MContext)context.get(MApplication.class.getName())) == null) {
                    return null;
                }
                IEclipseContext current = perceivedRoot.getContext();
                if (current == null) {
                    return null;
                }
                IEclipseContext next = (IEclipseContext)current.getLocal("activeChildContext");
                MPerspective candidate = null;
                while (next != null) {
                    current = next;
                    MPerspective perspective = (MPerspective)current.get(MPerspective.class);
                    if (perspective != null) {
                        candidate = perspective;
                    }
                    next = (IEclipseContext)current.getLocal("activeChildContext");
                }
                if (candidate != null) {
                    return candidate;
                }
                MUIElement window = (MUIElement)current.get(MWindow.class.getName());
                if (window == null) {
                    return null;
                }
                MElementContainer parent = window.getParent();
                while (parent != null && !(parent instanceof MApplication)) {
                    window = parent;
                    parent = parent.getParent();
                }
                return window;
            }
        });
        appContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", "localActiveShell"));
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }
        });
        appContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        appContext.set(IEclipseContext.class.getName(), (Object)appContext);
        appContext.set(IShellProvider.class.getName(), (Object)new IShellProvider(){

            public Shell getShell() {
                return null;
            }
        });
        return appContext;
    }
}

