/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.ArraySuperTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class ArrayTypeSet
extends TypeSet {
    protected TypeSet fElemTypeSet;
    private EnumeratedTypeSet fEnumCache = null;

    protected ArrayTypeSet(TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
    }

    public ArrayTypeSet(TypeSet s) {
        super(s.getTypeSetEnvironment());
        this.fElemTypeSet = s;
    }

    public TypeSet getElemTypeSet() {
        return this.fElemTypeSet;
    }

    public boolean isUniverse() {
        return false;
    }

    public TypeSet makeClone() {
        return new ArrayTypeSet(this.fElemTypeSet);
    }

    public boolean isEmpty() {
        return this.fElemTypeSet.isEmpty();
    }

    public TypeSet upperBound() {
        return new ArrayTypeSet(this.fElemTypeSet.upperBound());
    }

    public TypeSet lowerBound() {
        return new ArrayTypeSet(this.fElemTypeSet.lowerBound());
    }

    public boolean hasUniqueLowerBound() {
        return this.fElemTypeSet.hasUniqueLowerBound();
    }

    public boolean hasUniqueUpperBound() {
        return this.fElemTypeSet.hasUniqueUpperBound();
    }

    public TType uniqueLowerBound() {
        return TTypes.createArrayType(this.fElemTypeSet.uniqueLowerBound(), 1);
    }

    public TType uniqueUpperBound() {
        return TTypes.createArrayType(this.fElemTypeSet.uniqueUpperBound(), 1);
    }

    public boolean contains(TType t) {
        if (!(t instanceof ArrayType)) {
            return false;
        }
        ArrayType at = (ArrayType)t;
        return this.fElemTypeSet.contains(at.getComponentType());
    }

    public boolean containsAll(TypeSet s) {
        if (s instanceof ArrayTypeSet && !(s instanceof ArraySuperTypeSet)) {
            ArrayTypeSet ats = (ArrayTypeSet)s;
            return this.fElemTypeSet.containsAll(ats.fElemTypeSet);
        }
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            TType t = (TType)iter.next();
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.iterator();
        }
        return new Iterator(){
            Iterator fElemIter;
            {
                this.fElemIter = ArrayTypeSet.this.fElemTypeSet.iterator();
            }

            public boolean hasNext() {
                return this.fElemIter.hasNext();
            }

            public Object next() {
                return TTypes.createArrayType((TType)this.fElemIter.next(), 1);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            Iterator iter = this.fElemTypeSet.iterator();
            while (iter.hasNext()) {
                TType t = (TType)iter.next();
                this.fEnumCache.add(TTypes.createArrayType(t, 1));
            }
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean isSingleton() {
        return this.fElemTypeSet.isSingleton();
    }

    public TType anyMember() {
        return TTypes.createArrayType(this.fElemTypeSet.anyMember(), 1);
    }

    public TypeSet superTypes() {
        return new ArraySuperTypeSet(this.fElemTypeSet);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayTypeSet) {
            ArrayTypeSet other = (ArrayTypeSet)obj;
            return this.fElemTypeSet.equals(other.fElemTypeSet);
        }
        return false;
    }

    public int hashCode() {
        return this.fElemTypeSet.hashCode();
    }

    public String toString() {
        return "{" + this.fID + ": array(" + this.fElemTypeSet + ")}";
    }
}

