/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.TypeMismatchSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MissingReturnTypeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ReplaceCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.swt.graphics.Image;

public class ReturnTypeSubProcessor {
    public static void addMethodWithConstrNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)selectedNode;
            ASTRewrite rewrite = ASTRewrite.create((AST)declaration.getAST());
            rewrite.set((ASTNode)declaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
            String label = CorrectionMessages.ReturnTypeSubProcessor_constrnamemethod_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal);
        }
    }

    public static void addVoidMethodReturnsProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration && selectedNode.getNodeType() == 41) {
            ReturnStatement returnStatement = (ReturnStatement)selectedNode;
            Expression expr = returnStatement.getExpression();
            if (expr != null) {
                AST ast = astRoot.getAST();
                ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                if (binding == null) {
                    binding = ast.resolveWellKnownType("java.lang.Object");
                }
                if (binding.isWildcardType()) {
                    binding = ASTResolving.normalizeWildcardType(binding, true, ast);
                }
                MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_voidmethodreturns_description, BindingLabelProvider.getBindingLabel((IBinding)binding, BindingLabelProvider.DEFAULT_TEXTFLAGS));
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
                ImportRewrite imports = proposal.createImportRewrite(astRoot);
                ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)methodDeclaration, imports);
                Type newReturnType = imports.addImport(binding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
                if (methodDeclaration.isConstructor()) {
                    rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
                    rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)newReturnType, null);
                } else {
                    rewrite.replace((ASTNode)methodDeclaration.getReturnType2(), (ASTNode)newReturnType, null);
                }
                String key = "return_type";
                proposal.addLinkedPosition(rewrite.track((ASTNode)newReturnType), true, key);
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, binding);
                int i = 0;
                while (i < bindings.length) {
                    proposal.addLinkedPositionProposal(key, bindings[i]);
                    ++i;
                }
                Javadoc javadoc = methodDeclaration.getJavadoc();
                if (javadoc != null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@return");
                    TextElement commentStart = ast.newTextElement();
                    newTag.fragments().add(commentStart);
                    JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
                    proposal.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
                }
                proposals.add(proposal);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)decl.getAST());
            rewrite.remove((ASTNode)returnStatement.getExpression(), null);
            String label = CorrectionMessages.ReturnTypeSubProcessor_removereturn_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal);
        }
    }

    public static void addMissingReturnTypeProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)decl;
            ReturnStatementCollector eval = new ReturnStatementCollector();
            decl.accept((ASTVisitor)eval);
            AST ast = astRoot.getAST();
            ITypeBinding typeBinding = eval.getTypeBinding(decl.getAST());
            typeBinding = Bindings.normalizeTypeBinding(typeBinding);
            if (typeBinding == null) {
                typeBinding = ast.resolveWellKnownType("void");
            }
            if (typeBinding.isWildcardType()) {
                typeBinding = ASTResolving.normalizeWildcardType(typeBinding, true, ast);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            String label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_missingreturntype_description, BindingLabelProvider.getBindingLabel((IBinding)typeBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS));
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 6, image);
            ImportRewrite imports = proposal.createImportRewrite(astRoot);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)decl, imports);
            Type type = imports.addImport(typeBinding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext);
            rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
            rewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null && typeBinding != null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@return");
                TextElement commentStart = ast.newTextElement();
                newTag.fragments().add(commentStart);
                JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
                proposal.addLinkedPosition(rewrite.track((ASTNode)commentStart), false, "comment_start");
            }
            String key = "return_type";
            proposal.addLinkedPosition(rewrite.track((ASTNode)type), true, key);
            if (typeBinding != null) {
                ITypeBinding[] bindings = ASTResolving.getRelaxingTypes(ast, typeBinding);
                int i = 0;
                while (i < bindings.length) {
                    proposal.addLinkedPositionProposal(key, bindings[i]);
                    ++i;
                }
            }
            proposals.add(proposal);
            ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
            if (parentType instanceof AbstractTypeDeclaration) {
                boolean isInterface;
                boolean bl = isInterface = parentType instanceof TypeDeclaration && ((TypeDeclaration)parentType).isInterface();
                if (!isInterface) {
                    String constructorName = ((AbstractTypeDeclaration)parentType).getName().getIdentifier();
                    SimpleName nameNode = methodDeclaration.getName();
                    label = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_wrongconstructorname_description, BasicElementLabels.getJavaElementName(constructorName));
                    proposals.add(new ReplaceCorrectionProposal(label, cu, nameNode.getStartPosition(), nameNode.getLength(), constructorName, 5));
                }
            }
        }
    }

    public static void addMissingReturnStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)decl;
            Block block = methodDecl.getBody();
            if (block == null) {
                return;
            }
            ReturnStatement existingStatement = selectedNode instanceof ReturnStatement ? (ReturnStatement)selectedNode : null;
            proposals.add(new MissingReturnTypeCorrectionProposal(cu, methodDecl, existingStatement, 6));
            Type returnType = methodDecl.getReturnType2();
            if (returnType != null && !"void".equals(ASTNodes.asString((ASTNode)returnType))) {
                TagElement tagElement;
                AST ast = methodDecl.getAST();
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                rewrite.replace((ASTNode)returnType, (ASTNode)ast.newPrimitiveType(PrimitiveType.VOID), null);
                Javadoc javadoc = methodDecl.getJavadoc();
                if (javadoc != null && (tagElement = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) != null) {
                    rewrite.remove((ASTNode)tagElement, null);
                }
                String label = CorrectionMessages.ReturnTypeSubProcessor_changetovoid_description;
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
                proposals.add(proposal);
            }
        }
    }

    public static void addMethodRetunsVoidProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws JavaModelException {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof ReturnStatement)) {
            return;
        }
        ReturnStatement returnStatement = (ReturnStatement)selectedNode;
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            return;
        }
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            MethodDeclaration methDecl = (MethodDeclaration)decl;
            Type retType = methDecl.getReturnType2();
            if (retType == null || retType.resolveBinding() == null) {
                return;
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, expression, retType.resolveBinding(), false, 4, proposals);
        }
    }

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList fResult = new ArrayList();

        private ReturnStatementCollector() {
        }

        public ITypeBinding getTypeBinding(AST ast) {
            boolean couldBeObject = false;
            int i = 0;
            while (i < this.fResult.size()) {
                ReturnStatement node = (ReturnStatement)this.fResult.get(i);
                Expression expr = node.getExpression();
                if (expr != null) {
                    ITypeBinding binding = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
                    if (binding != null) {
                        return binding;
                    }
                } else {
                    return ast.resolveWellKnownType("void");
                }
                couldBeObject = true;
                ++i;
            }
            if (couldBeObject) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
            return ast.resolveWellKnownType("void");
        }

        public boolean visit(ReturnStatement node) {
            this.fResult.add(node);
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(EnumDeclaration node) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return false;
        }
    }
}

