/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class ASTNode
implements BaseTypes,
CompilerModifiers,
TypeConstants,
TypeIds {
    public int sourceStart;
    public int sourceEnd;
    public static final Constant NotAConstant = Constant.NotAConstant;
    public static final int Bit1 = 1;
    public static final int Bit2 = 2;
    public static final int Bit3 = 4;
    public static final int Bit4 = 8;
    public static final int Bit5 = 16;
    public static final int Bit6 = 32;
    public static final int Bit7 = 64;
    public static final int Bit8 = 128;
    public static final int Bit9 = 256;
    public static final int Bit10 = 512;
    public static final int Bit11 = 1024;
    public static final int Bit12 = 2048;
    public static final int Bit13 = 4096;
    public static final int Bit14 = 8192;
    public static final int Bit15 = 16384;
    public static final int Bit16 = 32768;
    public static final int Bit17 = 65536;
    public static final int Bit18 = 131072;
    public static final int Bit19 = 262144;
    public static final int Bit20 = 524288;
    public static final int Bit21 = 0x100000;
    public static final int Bit22 = 0x200000;
    public static final int Bit23 = 0x400000;
    public static final int Bit24 = 0x800000;
    public static final int Bit25 = 0x1000000;
    public static final int Bit26 = 0x2000000;
    public static final int Bit27 = 0x4000000;
    public static final int Bit28 = 0x8000000;
    public static final int Bit29 = 0x10000000;
    public static final int Bit30 = 0x20000000;
    public static final int Bit31 = 0x40000000;
    public static final int Bit32 = Integer.MIN_VALUE;
    public static final long Bit32L = 0x80000000L;
    public static final long Bit33L = 0x100000000L;
    public static final long Bit34L = 0x200000000L;
    public static final long Bit35L = 0x400000000L;
    public static final long Bit36L = 0x800000000L;
    public static final long Bit37L = 0x1000000000L;
    public static final long Bit38L = 0x2000000000L;
    public static final long Bit39L = 0x4000000000L;
    public static final long Bit40L = 0x8000000000L;
    public static final long Bit41L = 0x10000000000L;
    public static final long Bit42L = 0x20000000000L;
    public static final long Bit43L = 0x40000000000L;
    public static final long Bit44L = 0x80000000000L;
    public static final long Bit45L = 0x100000000000L;
    public static final long Bit46L = 0x200000000000L;
    public static final long Bit47L = 0x400000000000L;
    public static final long Bit48L = 0x800000000000L;
    public static final long Bit49L = 0x1000000000000L;
    public static final long Bit50L = 0x2000000000000L;
    public static final long Bit51L = 0x4000000000000L;
    public static final long Bit52L = 0x8000000000000L;
    public static final long Bit53L = 0x10000000000000L;
    public static final long Bit54L = 0x20000000000000L;
    public static final long Bit55L = 0x40000000000000L;
    public static final long Bit56L = 0x80000000000000L;
    public int bits = Integer.MIN_VALUE;
    public static final int ReturnTypeIDMASK = 15;
    public static final int OperatorSHIFT = 6;
    public static final int OperatorMASK = 4032;
    public static final int ValueForReturnMASK = 16;
    public static final int UnnecessaryCastMASK = 16384;
    public static final int IgnoreNeedForCastCheckMASK = 32;
    public static final int NeedRuntimeCheckCastMASK = 64;
    public static final int UnsafeCastMask = 128;
    public static final int RestrictiveFlagMASK = 7;
    public static final int FirstAssignmentToLocalMASK = 8;
    public static final int IsImplicitThisMask = 4;
    public static final int DepthSHIFT = 5;
    public static final int DepthMASK = 8160;
    public static final int IsReachableMASK = Integer.MIN_VALUE;
    public static final int IsLocalDeclarationReachableMASK = 0x40000000;
    public static final int AddAssertionMASK = 1;
    public static final int IsLocalTypeMASK = 256;
    public static final int IsAnonymousTypeMASK = 512;
    public static final int AnonymousAndLocalMask = 768;
    public static final int IsMemberTypeMASK = 1024;
    public static final int HasAbstractMethods = 2048;
    public static final int HasLocalTypeMASK = 2;
    public static final int ParenthesizedSHIFT = 21;
    public static final int ParenthesizedMASK = 534773760;
    public static final int IsAssignmentWithNoEffectMASK = 0x20000000;
    public static final int IsStrictlyAssignedMASK = 8192;
    public static final int IsCompoundAssignedMASK = 65536;
    public static final int IsUsefulEmptyStatementMASK = 1;
    public static final int UndocumentedEmptyBlockMASK = 8;
    public static final int HasAllMethodBodies = 16;
    public static final int InsideJavadoc = 32768;
    public static final int IsElseIfStatement = 0x20000000;
    public static final int IsSuperType = 16;
    public static final int IsVarArgs = 16384;
    public static final int IsAnnotationDefaultValue = 1;

    private static boolean checkInvocationArgument(BlockScope scope, Expression argument, TypeBinding parameterType, TypeBinding argumentType, TypeBinding originalParameterType) {
        TypeBinding checkedParameterType;
        argument.computeConversion(scope, parameterType, argumentType);
        if (argumentType != NullBinding && parameterType.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)parameterType;
            if (wildcard.boundKind != 2 && wildcard.otherBounds == null) {
                return true;
            }
        }
        TypeBinding typeBinding = checkedParameterType = originalParameterType == null ? parameterType : originalParameterType;
        if (argumentType != checkedParameterType && argumentType.needsUncheckedConversion(checkedParameterType)) {
            scope.problemReporter().unsafeTypeConversion(argument, argumentType, checkedParameterType);
        }
        return false;
    }

    public static void checkInvocationArguments(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding method, Expression[] arguments, TypeBinding[] argumentTypes, boolean argsContainCast, InvocationSite invocationSite) {
        MethodBinding rawOriginalGenericMethod;
        boolean unsafeWildcardInvocation;
        block18: {
            block20: {
                int paramLength;
                TypeBinding[] params;
                block19: {
                    int dimensions;
                    TypeBinding lastArgType;
                    ArrayBinding varargType;
                    block22: {
                        block21: {
                            unsafeWildcardInvocation = false;
                            params = method.parameters;
                            paramLength = params.length;
                            boolean isRawMemberInvocation = !method.isStatic() && !receiverType.isUnboundWildcard() && method.declaringClass.isRawType() && method.hasSubstitutedParameters();
                            rawOriginalGenericMethod = null;
                            if (!isRawMemberInvocation && method instanceof ParameterizedGenericMethodBinding) {
                                ParameterizedGenericMethodBinding paramMethod = (ParameterizedGenericMethodBinding)method;
                                if (paramMethod.isUnchecked || paramMethod.isRaw && method.hasSubstitutedParameters()) {
                                    rawOriginalGenericMethod = method.original();
                                }
                            }
                            if (arguments == null) break block18;
                            if (!method.isVarargs()) break block19;
                            int lastIndex = paramLength - 1;
                            int i = 0;
                            while (i < lastIndex) {
                                TypeBinding originalRawParam;
                                TypeBinding typeBinding = originalRawParam = rawOriginalGenericMethod == null ? null : rawOriginalGenericMethod.parameters[i];
                                if (ASTNode.checkInvocationArgument(scope, arguments[i], params[i], argumentTypes[i], originalRawParam)) {
                                    unsafeWildcardInvocation = true;
                                }
                                ++i;
                            }
                            int argLength = arguments.length;
                            if (lastIndex < argLength) {
                                TypeBinding parameterType = params[lastIndex];
                                TypeBinding originalRawParam = null;
                                if (paramLength != argLength || parameterType.dimensions() != argumentTypes[lastIndex].dimensions()) {
                                    parameterType = ((ArrayBinding)parameterType).elementsType();
                                    originalRawParam = rawOriginalGenericMethod == null ? null : ((ArrayBinding)rawOriginalGenericMethod.parameters[lastIndex]).elementsType();
                                }
                                int i2 = lastIndex;
                                while (i2 < argLength) {
                                    if (ASTNode.checkInvocationArgument(scope, arguments[i2], parameterType, argumentTypes[i2], originalRawParam)) {
                                        unsafeWildcardInvocation = true;
                                    }
                                    ++i2;
                                }
                            }
                            if (paramLength != argumentTypes.length) break block20;
                            int varargIndex = paramLength - 1;
                            varargType = (ArrayBinding)params[varargIndex];
                            lastArgType = argumentTypes[varargIndex];
                            if (lastArgType != NullBinding) break block21;
                            if (!varargType.leafComponentType().isBaseType() || varargType.dimensions() != 1) {
                                scope.problemReporter().varargsArgumentNeedCast(method, lastArgType, invocationSite);
                            }
                            break block20;
                        }
                        if (varargType.dimensions > lastArgType.dimensions()) break block20;
                        dimensions = lastArgType.dimensions();
                        if (lastArgType.leafComponentType().isBaseType()) {
                            --dimensions;
                        }
                        if (varargType.dimensions >= dimensions) break block22;
                        scope.problemReporter().varargsArgumentNeedCast(method, lastArgType, invocationSite);
                        break block20;
                    }
                    if (varargType.dimensions != dimensions || varargType.leafComponentType == lastArgType.leafComponentType()) break block20;
                    scope.problemReporter().varargsArgumentNeedCast(method, lastArgType, invocationSite);
                    break block20;
                }
                int i = 0;
                while (i < paramLength) {
                    TypeBinding originalRawParam;
                    TypeBinding typeBinding = originalRawParam = rawOriginalGenericMethod == null ? null : rawOriginalGenericMethod.parameters[i];
                    if (ASTNode.checkInvocationArgument(scope, arguments[i], params[i], argumentTypes[i], originalRawParam)) {
                        unsafeWildcardInvocation = true;
                    }
                    ++i;
                }
            }
            if (argsContainCast) {
                CastExpression.checkNeedForArgumentCasts(scope, receiver, receiverType, method, arguments, argumentTypes, invocationSite);
            }
        }
        if (unsafeWildcardInvocation) {
            scope.problemReporter().wildcardInvocation((ASTNode)((Object)invocationSite), receiverType, method, argumentTypes);
        } else if (!method.isStatic() && !receiverType.isUnboundWildcard() && method.declaringClass.isRawType() && method.hasSubstitutedParameters()) {
            scope.problemReporter().unsafeRawInvocation((ASTNode)((Object)invocationSite), method);
        } else if (rawOriginalGenericMethod != null) {
            scope.problemReporter().unsafeRawGenericMethodInvocation((ASTNode)((Object)invocationSite), method);
        }
    }

    public ASTNode concreteStatement() {
        return this;
    }

    public final boolean isFieldUseDeprecated(FieldBinding field, Scope scope, boolean isStrictlyAssigned) {
        if (!isStrictlyAssigned && (field.isPrivate() || field.declaringClass != null && field.declaringClass.isLocalType()) && !scope.isDefinedInField(field)) {
            field.original().modifiers |= 0x8000000;
        }
        if (!field.isViewedAsDeprecated()) {
            return false;
        }
        if (scope.isDefinedInSameUnit(field.declaringClass)) {
            return false;
        }
        return scope.compilerOptions().reportDeprecationInsideDeprecatedCode || !scope.isInsideDeprecatedCode();
    }

    public boolean isImplicitThis() {
        return false;
    }

    public final boolean isMethodUseDeprecated(MethodBinding method, Scope scope) {
        if ((method.isPrivate() || method.declaringClass.isLocalType()) && !scope.isDefinedInMethod(method)) {
            method.original().modifiers |= 0x8000000;
        }
        if (!method.isViewedAsDeprecated()) {
            return false;
        }
        if (scope.isDefinedInSameUnit(method.declaringClass)) {
            return false;
        }
        return scope.compilerOptions().reportDeprecationInsideDeprecatedCode || !scope.isInsideDeprecatedCode();
    }

    public boolean isSuper() {
        return false;
    }

    public boolean isThis() {
        return false;
    }

    public final boolean isTypeUseDeprecated(TypeBinding type, Scope scope) {
        AccessRestriction restriction;
        if (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        if (type.isBaseType()) {
            return false;
        }
        ReferenceBinding refType = (ReferenceBinding)type;
        if (refType.isPrivate() && !scope.isDefinedInType(refType)) {
            ((ReferenceBinding)refType.erasure()).modifiers |= 0x8000000;
        }
        if (refType.hasRestrictedAccess() && (restriction = scope.environment().getAccessRestriction(type)) != null) {
            scope.problemReporter().forbiddenReference(type, this, restriction.getMessageTemplate(), restriction.getProblemId());
        }
        if (!refType.isViewedAsDeprecated()) {
            return false;
        }
        if (scope.isDefinedInSameUnit(refType)) {
            return false;
        }
        return scope.compilerOptions().reportDeprecationInsideDeprecatedCode || !scope.isInsideDeprecatedCode();
    }

    public abstract StringBuffer print(int var1, StringBuffer var2);

    public static StringBuffer printAnnotations(Annotation[] annotations, StringBuffer output) {
        int length = annotations.length;
        int i = 0;
        while (i < length) {
            annotations[i].print(0, output);
            output.append(" ");
            ++i;
        }
        return output;
    }

    public static StringBuffer printIndent(int indent, StringBuffer output) {
        int i = indent;
        while (i > 0) {
            output.append("  ");
            --i;
        }
        return output;
    }

    public static StringBuffer printModifiers(int modifiers, StringBuffer output) {
        if ((modifiers & 1) != 0) {
            output.append("public ");
        }
        if ((modifiers & 2) != 0) {
            output.append("private ");
        }
        if ((modifiers & 4) != 0) {
            output.append("protected ");
        }
        if ((modifiers & 8) != 0) {
            output.append("static ");
        }
        if ((modifiers & 0x10) != 0) {
            output.append("final ");
        }
        if ((modifiers & 0x20) != 0) {
            output.append("synchronized ");
        }
        if ((modifiers & 0x40) != 0) {
            output.append("volatile ");
        }
        if ((modifiers & 0x80) != 0) {
            output.append("transient ");
        }
        if ((modifiers & 0x100) != 0) {
            output.append("native ");
        }
        if ((modifiers & 0x400) != 0) {
            output.append("abstract ");
        }
        return output;
    }

    public static void resolveAnnotations(BlockScope scope, Annotation[] annotations, Binding recipient) {
        if (recipient != null) {
            switch (recipient.kind()) {
                case 16: {
                    PackageBinding packageBinding = (PackageBinding)recipient;
                    if ((packageBinding.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    packageBinding.tagBits |= 0x200000000L;
                    break;
                }
                case 4: 
                case 2052: 
                case 4100: {
                    ReferenceBinding type = (ReferenceBinding)recipient;
                    if ((type.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    type.tagBits |= 0x200000000L;
                    break;
                }
                case 8: {
                    MethodBinding method = (MethodBinding)recipient;
                    if ((method.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    method.tagBits |= 0x200000000L;
                    break;
                }
                case 1: {
                    FieldBinding field = (FieldBinding)recipient;
                    if ((field.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    field.tagBits |= 0x200000000L;
                    break;
                }
                case 2: {
                    LocalVariableBinding local = (LocalVariableBinding)recipient;
                    if ((local.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    local.tagBits |= 0x200000000L;
                }
            }
        }
        if (annotations == null) {
            return;
        }
        int length = annotations.length;
        TypeBinding[] annotationTypes = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            Annotation annotation = annotations[i];
            annotation.recipient = recipient;
            annotationTypes[i] = annotation.resolveType(scope);
            ++i;
        }
        i = 0;
        while (i < length) {
            TypeBinding annotationType = annotationTypes[i];
            if (annotationType != null) {
                boolean foundDuplicate = false;
                int j = i + 1;
                while (j < length) {
                    if (annotationTypes[j] == annotationType) {
                        foundDuplicate = true;
                        annotationTypes[j] = null;
                        scope.problemReporter().duplicateAnnotation(annotations[j]);
                    }
                    ++j;
                }
                if (foundDuplicate) {
                    scope.problemReporter().duplicateAnnotation(annotations[i]);
                }
            }
            ++i;
        }
    }

    public int sourceStart() {
        return this.sourceStart;
    }

    public int sourceEnd() {
        return this.sourceEnd;
    }

    public String toString() {
        return this.print(0, new StringBuffer(30)).toString();
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
    }
}

