/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.internal.services.LegacyEvalContext;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;

final class HandlerActivation
extends RunAndTrack
implements IHandlerActivation {
    IEclipseContext context;
    private String commandId;
    private IHandler handler;
    E4HandlerProxy proxy;
    private Expression activeWhen;
    private boolean active;
    private int sourcePriority;
    boolean participating = true;

    public HandlerActivation(IEclipseContext context, String cmdId, IHandler handler, E4HandlerProxy handlerProxy, Expression expr) {
        this.context = context;
        this.commandId = cmdId;
        this.handler = handler;
        this.proxy = handlerProxy;
        this.activeWhen = expr;
        this.sourcePriority = SourcePriorityNameMapping.computeSourcePriority(this.activeWhen);
        this.proxy.activation = this;
    }

    public void clearResult() {
    }

    public Expression getExpression() {
        return this.activeWhen;
    }

    public int getSourcePriority() {
        return this.sourcePriority;
    }

    public boolean evaluate(IEvaluationContext context) {
        if (this.activeWhen == null) {
            this.active = true;
        } else {
            try {
                this.active = this.activeWhen.evaluate(context) != EvaluationResult.FALSE;
            }
            catch (CoreException e) {
                Activator.trace((String)"/trace/commands", (String)"Failed to calculate active", (Throwable)e);
            }
        }
        return this.active;
    }

    public void setResult(boolean result) {
    }

    public int compareTo(Object o) {
        int difference;
        HandlerActivation activation = (HandlerActivation)o;
        int thisPriority = this.getSourcePriority();
        int thatPriority = activation.getSourcePriority();
        int thisLsb = 0;
        int thatLsb = 0;
        if ((thisPriority & Integer.MIN_VALUE | thatPriority & Integer.MIN_VALUE) != 0) {
            thisLsb = thisPriority & 1;
            thisPriority = thisPriority >> 1 & Integer.MAX_VALUE;
            thatLsb = thatPriority & 1;
            thatPriority = thatPriority >> 1 & Integer.MAX_VALUE;
        }
        if ((difference = thisPriority - thatPriority) != 0) {
            return difference;
        }
        difference = thisLsb - thatLsb;
        if (difference != 0) {
            return difference;
        }
        int thisDepth = this.getDepth();
        int thatDepth = activation.getDepth();
        difference = thisDepth - thatDepth;
        return difference;
    }

    public boolean changed(IEclipseContext context) {
        if (!this.participating) {
            return false;
        }
        EHandlerService hs = (EHandlerService)this.context.get(EHandlerService.class.getName());
        Object obj = HandlerServiceImpl.lookUpHandler((IEclipseContext)this.context, (String)this.commandId);
        if (this.evaluate(new LegacyEvalContext(this.context))) {
            if (obj instanceof E4HandlerProxy) {
                HandlerActivation bestActivation = ((E4HandlerProxy)obj).activation;
                int comparison = bestActivation.compareTo(this);
                if (comparison < 0) {
                    hs.activateHandler(this.commandId, (Object)this.proxy);
                }
            } else if (obj == null) {
                hs.activateHandler(this.commandId, (Object)this.proxy);
            }
        } else if (obj == this.proxy) {
            hs.deactivateHandler(this.commandId, (Object)this.proxy);
        }
        return this.participating;
    }

    public void clearActive() {
    }

    public String getCommandId() {
        return this.commandId;
    }

    public int getDepth() {
        return 0;
    }

    public IHandler getHandler() {
        return this.handler;
    }

    public IHandlerService getHandlerService() {
        return (IHandlerService)this.context.get(IHandlerService.class.getName());
    }

    public boolean isActive(IEvaluationContext context) {
        return this.active;
    }

    public String toString() {
        return "EHA: " + this.active + ":" + this.sourcePriority + ":" + this.commandId + ": " + this.proxy + ": " + this.handler + ": " + this.context;
    }
}

