/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

public final class ServiceLocator
implements IDisposable,
INestable,
IServiceLocator {
    boolean activated = false;
    private boolean disposed;
    private final IDisposable owner;
    private IEclipseContext e4Context;

    public ServiceLocator() {
        this(null, null, null);
    }

    public ServiceLocator(IServiceLocator parent, AbstractServiceFactory factory, IDisposable owner) {
        this.owner = owner;
    }

    public final void activate() {
        this.activated = true;
    }

    public final void deactivate() {
        this.activated = false;
    }

    public final void dispose() {
        this.e4Context = null;
        this.disposed = true;
    }

    public final Object getService(Class key) {
        if (this.disposed) {
            return null;
        }
        return this.e4Context.get(key.getName());
    }

    public final boolean hasService(Class key) {
        if (this.disposed) {
            return false;
        }
        return this.e4Context.containsKey(key.getName());
    }

    public final void registerService(Class api, Object service) {
        if (api == null) {
            throw new NullPointerException("The service key cannot be null");
        }
        if (!api.isInstance(service)) {
            throw new IllegalArgumentException("The service does not implement the given interface");
        }
        this.e4Context.set(api.getName(), service);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void unregisterServices(String[] serviceNames) {
        if (this.owner != null) {
            this.owner.dispose();
        }
    }

    public void setContext(IEclipseContext context) {
        this.e4Context = context;
    }

    public IEclipseContext getContext() {
        return this.e4Context;
    }
}

