/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.views.ViewContextManager;
import org.eclipse.debug.internal.ui.views.ViewContextService;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PerspectiveManager
implements ILaunchListener,
ISuspendTriggerListener,
ISaveParticipant {
    private Set fPerspectiveContexts = null;
    public static final String ATTR_DELEGATE_ID = "delegate";
    private boolean fPrompting;
    private PerspectiveSwitchLock fPerspectiveSwitchLock = new PerspectiveSwitchLock();
    private Map fLaunchToContextActivations = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void startup() {
        DebugUIPlugin.getDefault().addSaveParticipant(this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        this.initPerspectives();
    }

    public void shutdown() {
        DebugUIPlugin.getDefault().removeSaveParticipant(this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
    }

    public synchronized void launchRemoved(final ILaunch launch) {
        ISuspendTrigger trigger;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.contexts.ISuspendTrigger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((trigger = (ISuspendTrigger)launch.getAdapter((Class)clazz)) != null) {
            trigger.removeSuspendTriggerListener(this);
        }
        Runnable r = new Runnable(){

            public void run() {
                IContextActivation[] activations = (IContextActivation[])PerspectiveManager.this.fLaunchToContextActivations.remove(launch);
                if (activations != null) {
                    int i = 0;
                    while (i < activations.length) {
                        IContextActivation activation = activations[i];
                        activation.getContextService().deactivateContext(activation);
                        ++i;
                    }
                }
            }
        };
        this.async(r);
    }

    public void launchChanged(ILaunch launch) {
    }

    public synchronized void launchAdded(ILaunch launch) {
        ISuspendTrigger trigger;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.contexts.ISuspendTrigger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((trigger = (ISuspendTrigger)launch.getAdapter((Class)clazz)) != null) {
            trigger.addSuspendTriggerListener(this);
        }
        this.fPerspectiveSwitchLock.startSwitch();
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            String name = DebugUIPlugin.getModelPresentation().getText(launch);
            this.switchFailed(e, name);
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && !LaunchConfigurationManager.isVisible(configuration)) {
            perspectiveId = null;
        }
        final String id = perspectiveId;
        this.async(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow window = PerspectiveManager.this.getWindowForPerspective(id);
                    if (id != null && window != null && PerspectiveManager.this.shouldSwitchPerspective(window, id, "org.eclipse.debug.ui.switch_to_perspective")) {
                        PerspectiveManager.this.switchToPerspective(window, id);
                    }
                }
                finally {
                    PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                }
            }
        });
    }

    protected void switchToPerspective(IWorkbenchWindow window, String id) {
        try {
            Shell dialog = this.getModalDialogOpen(window.getShell());
            window.getWorkbench().showPerspective(id, window);
            if (dialog != null) {
                dialog.setFocus();
            }
        }
        catch (WorkbenchException e) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.PerspectiveManager_Error_1, MessageFormat.format((String)LaunchConfigurationsMessages.PerspectiveManager_Unable_to_switch_to_perspective___0__2, (Object[])new String[]{id}), e);
        }
    }

    protected void async(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.asyncExec(r);
        }
    }

    protected void sync(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.syncExec(r);
        }
    }

    protected void switchFailed(final Throwable t, final String launchName) {
        this.sync(new Runnable(){

            public void run() {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.PerspectiveManager_Error_1, MessageFormat.format((String)LaunchConfigurationsMessages.PerspectiveManager_Unable_to_switch_perpsectives_as_specified_by_launch___0__4, (Object[])new String[]{launchName}), t);
            }
        });
    }

    private void handleBreakpointHit(final ILaunch launch) {
        this.fPerspectiveSwitchLock.startSwitch();
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        final String targetId = perspectiveId;
        Runnable r = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                IWorkbenchWindow window = null;
                try {
                    block21: {
                        if (targetId != null) {
                            ILaunchConfiguration launchConfiguration;
                            Object ca;
                            Shell shell;
                            window = PerspectiveManager.this.getWindowForPerspective(targetId);
                            if (window == null) {
                                return;
                            }
                            if (PerspectiveManager.this.shouldSwitchPerspective(window, targetId, "org.eclipse.debug.ui.switch_perspective_on_suspend")) {
                                PerspectiveManager.this.switchToPerspective(window, targetId);
                                window = PerspectiveManager.this.getWindowForPerspective(targetId);
                                if (window == null) {
                                    return;
                                }
                            }
                            if ((shell = window.getShell()) != null && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.activate_workbench")) {
                                Shell dialog = PerspectiveManager.this.getModalDialogOpen(shell);
                                if (shell.getMinimized()) {
                                    shell.setMinimized(false);
                                    if (dialog != null) {
                                        dialog.setFocus();
                                    }
                                }
                                if (dialog == null) {
                                    shell.forceActive();
                                }
                            }
                            if ((ca = PerspectiveManager.this.fLaunchToContextActivations.get(launch)) == null && (launchConfiguration = launch.getLaunchConfiguration()) != null) {
                                try {
                                    String type = launchConfiguration.getType().getIdentifier();
                                    ViewContextService service = ViewContextManager.getDefault().getService(window);
                                    if (service == null) break block21;
                                    IWorkbench iWorkbench = PlatformUI.getWorkbench();
                                    Class<?> clazz = class$1;
                                    if (clazz == null) {
                                        Class<?> clazz2;
                                        try {
                                            clazz2 = Class.forName("org.eclipse.ui.contexts.IContextService");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                        clazz = class$1 = clazz2;
                                    }
                                    IContextService contextServce = (IContextService)iWorkbench.getAdapter((Class)clazz);
                                    String[] ids = service.getEnabledPerspectives();
                                    IContextActivation[] activations = new IContextActivation[ids.length];
                                    int i = 0;
                                    while (true) {
                                        IContextActivation activation;
                                        if (i >= ids.length) {
                                            PerspectiveManager.this.fLaunchToContextActivations.put(launch, activations);
                                            break;
                                        }
                                        Context context = contextServce.getContext(String.valueOf(type) + ".internal." + ids[i]);
                                        if (!context.isDefined()) {
                                            context.define(context.getId(), null, null);
                                        }
                                        activations[i] = activation = contextServce.activateContext(context.getId());
                                        ++i;
                                    }
                                }
                                catch (CoreException e) {
                                    DebugUIPlugin.log(e);
                                }
                            }
                        }
                    }
                    if (window == null) return;
                    if (!DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.activate_debug_view")) return;
                    ViewContextService service = ViewContextManager.getDefault().getService(window);
                    service.showViewQuiet("org.eclipse.debug.ui.DebugView");
                    return;
                }
                finally {
                    PerspectiveManager.this.fPerspectiveSwitchLock.endSwitch();
                }
            }
        };
        this.async(r);
    }

    private Shell getModalDialogOpen(Shell shell) {
        Shell[] shells = shell.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell dialog = shells[i];
            if ((dialog.getStyle() & 0x38000) > 0) {
                return dialog;
            }
            ++i;
        }
        return null;
    }

    private IWorkbenchWindow getWindowForPerspective(String perspectiveId) {
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (this.isWindowShowingPerspective(window, perspectiveId)) {
            return window;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            window = windows[i];
            if (this.isWindowShowingPerspective(window, perspectiveId)) {
                return window;
            }
            ++i;
        }
        window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    private boolean isWindowShowingPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        return window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null && perspectiveDescriptor.getId().equals(perspectiveId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldSwitchPerspective(IWorkbenchWindow window, String perspectiveId, String preferenceKey) {
        if (this.isCurrentPerspective(window, perspectiveId)) {
            return false;
        }
        String perspectiveName = this.getPerspectiveLabel(perspectiveId);
        if (perspectiveName == null) {
            return false;
        }
        String perspectiveDesc = this.getPerspectiveDescription(perspectiveId);
        Object[] args = perspectiveDesc != null ? new String[]{perspectiveName, perspectiveDesc} : new String[]{perspectiveName};
        String switchPerspective = DebugUIPlugin.getDefault().getPreferenceStore().getString(preferenceKey);
        if ("always".equals(switchPerspective)) {
            return true;
        }
        if ("never".equals(switchPerspective)) {
            return false;
        }
        Shell shell = window.getShell();
        if (shell == null || this.fPrompting) {
            return false;
        }
        this.fPrompting = true;
        Shell modal = this.getModalDialogOpen(shell);
        if (shell.getMinimized()) {
            shell.setMinimized(false);
            if (modal != null) {
                modal.setFocus();
            }
        }
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.activate_workbench") && modal == null) {
            shell.forceActive();
        }
        String message = "";
        if ("org.eclipse.debug.ui.switch_perspective_on_suspend".equals(preferenceKey)) {
            message = this.getPerspectiveDescription(perspectiveId) != null ? LaunchConfigurationsMessages.PerspectiveManager_suspend_description : LaunchConfigurationsMessages.PerspectiveManager_13;
        } else if ("org.eclipse.debug.ui.switch_to_perspective".equals(preferenceKey)) {
            message = this.getPerspectiveDescription(perspectiveId) != null ? LaunchConfigurationsMessages.PerspectiveManager_launch_description : LaunchConfigurationsMessages.PerspectiveManager_15;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)LaunchConfigurationsMessages.PerspectiveManager_12, (String)MessageFormat.format((String)message, (Object[])args), null, (boolean)false, (IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)preferenceKey);
        boolean answer = dialog.getReturnCode() == 2;
        PerspectiveManager perspectiveManager = this;
        synchronized (perspectiveManager) {
            this.fPrompting = false;
            this.notifyAll();
        }
        if (this.isCurrentPerspective(window, perspectiveId)) {
            answer = false;
        }
        return answer;
    }

    protected boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    protected String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }

    protected String getPerspectiveDescription(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getDescription();
    }

    protected String getPerspectiveId(ILaunch launch) throws CoreException {
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return null;
        }
        Set modes = launch.getLaunchConfiguration().getModes();
        modes.add(launch.getLaunchMode());
        String perspectiveId = this.getLaunchPerspective(config.getType(), modes, this.resolveLaunchDelegate(launch));
        if (perspectiveId != null && perspectiveId.equals("perspective_none")) {
            perspectiveId = null;
        }
        return perspectiveId;
    }

    public String getLaunchPerspective(ILaunchConfigurationType type, Set modes, ILaunchDelegate delegate) {
        String id = null;
        PerspectiveContext context = this.findContext(new PerspectiveContext(type, delegate, modes));
        if ((context == null || context != null && !context.getPersepctiveMap().containsKey(modes)) && ((context = this.findContext(new PerspectiveContext(type, null, modes))) == null || context != null && !context.getPersepctiveMap().containsKey(modes))) {
            return this.getDefaultLaunchPerspective(type, delegate, modes);
        }
        id = context.getPerspective(modes);
        return id;
    }

    public String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        return this.getLaunchPerspective(type, modes, null);
    }

    public void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        this.setLaunchPerspective(type, modes, null, perspective);
    }

    public void setLaunchPerspective(ILaunchConfigurationType type, Set modes, ILaunchDelegate delegate, String perspectiveid) {
        PerspectiveContext item;
        PerspectiveContext context = new PerspectiveContext(type, delegate, modes);
        String id = null;
        if (!"perspective_none".equals(perspectiveid)) {
            id = "perspective_default".equals(perspectiveid) ? this.getDefaultLaunchPerspective(type, delegate, modes) : perspectiveid;
        }
        if ((item = this.findContext(context)) != null) {
            item.setPerspective(modes, id);
        } else {
            context.setPerspective(modes, id);
            item = context;
        }
        this.fPerspectiveContexts.add(item);
    }

    private PerspectiveContext findContext(PerspectiveContext context) {
        PerspectiveContext item = null;
        Object o = null;
        Iterator iter = this.fPerspectiveContexts.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!context.equals(o)) continue;
            item = o;
            return item;
        }
        return item;
    }

    private String generatePerspectiveXML() throws ParserConfigurationException, CoreException {
        Document doc = DebugUIPlugin.getDocument();
        Element root = doc.createElement("launchPerspectives");
        doc.appendChild(root);
        PerspectiveContext context = null;
        Map modesets = null;
        Element element = null;
        Set modes = null;
        String id = null;
        ILaunchDelegate delegate = null;
        Iterator iter = this.fPerspectiveContexts.iterator();
        while (iter.hasNext()) {
            context = (PerspectiveContext)iter.next();
            modesets = context.getPersepctiveMap();
            Iterator iter2 = modesets.keySet().iterator();
            while (iter2.hasNext()) {
                modes = (Set)iter2.next();
                id = context.getPerspective(modes);
                if (id == null) continue;
                element = doc.createElement("launchPerspective");
                element.setAttribute("mode", this.createModesetString(modes));
                delegate = context.getLaunchDelegate();
                if (delegate != null) {
                    element.setAttribute(ATTR_DELEGATE_ID, delegate.getId());
                }
                element.setAttribute("configurationType", context.getLaunchConfigurationType().getIdentifier());
                element.setAttribute("perspective", id);
                root.appendChild(element);
            }
        }
        return DebugPlugin.serializeDocument((Document)doc);
    }

    public String getDefaultLaunchPerspective(ILaunchConfigurationType type, String mode) {
        HashSet<String> modes = new HashSet<String>();
        modes.add(mode);
        return this.getDefaultLaunchPerspective(type, null, modes);
    }

    public String getDefaultLaunchPerspective(ILaunchConfigurationType type, ILaunchDelegate delegate, Set modes) {
        LaunchConfigurationTabGroupExtension extension;
        String id = null;
        if (delegate != null) {
            id = delegate.getPerspectiveId(modes);
        }
        if (id == null && (extension = LaunchConfigurationPresentationManager.getDefault().getExtension(type.getIdentifier(), modes)) != null && (id = extension.getPerspective(modes)) == null && modes.contains("debug")) {
            id = "org.eclipse.debug.ui.DebugPerspective";
        }
        return id;
    }

    private ILaunchDelegate resolveLaunchDelegate(ILaunch launch) throws CoreException {
        Set modes = launch.getLaunchConfiguration().getModes();
        modes.add(launch.getLaunchMode());
        ILaunchConfigurationType type = launch.getLaunchConfiguration().getType();
        ILaunchDelegate[] delegates = LaunchConfigurationManager.filterLaunchDelegates(type, modes);
        ILaunchDelegate delegate = null;
        if (delegates.length == 1) {
            delegate = delegates[0];
        } else if (delegates.length > 1 && (delegate = launch.getLaunchConfiguration().getPreferredDelegate(modes)) == null) {
            delegate = type.getPreferredDelegate(modes);
        }
        return delegate;
    }

    private void initPerspectives() {
        if (this.fPerspectiveContexts == null) {
            this.fPerspectiveContexts = new HashSet();
            String xml = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.PREF_LAUNCH_PERSPECTIVES");
            if (xml != null && xml.length() > 0) {
                try {
                    Element root = DebugPlugin.parseDocument((String)xml);
                    NodeList list = root.getChildNodes();
                    LaunchManager lm = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfigurationType lctype = null;
                    ILaunchDelegate ldelegate = null;
                    Set modes = null;
                    Node node = null;
                    Element element = null;
                    int i = 0;
                    while (i < list.getLength()) {
                        String nodeName;
                        node = list.item(i);
                        if (node.getNodeType() == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase("launchPerspective")) {
                            String type = element.getAttribute("configurationType");
                            String mode = element.getAttribute("mode");
                            String perspective = element.getAttribute("perspective");
                            String delegate = element.getAttribute(ATTR_DELEGATE_ID);
                            lctype = lm.getLaunchConfigurationType(type);
                            ldelegate = lm.getLaunchDelegate(delegate);
                            modes = this.parseModes(mode);
                            if (lctype != null && !modes.isEmpty() && !"".equals(perspective)) {
                                this.setLaunchPerspective(lctype, modes, ldelegate, perspective);
                            }
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
    }

    private Set parseModes(String modes) {
        HashSet<String> modeset = new HashSet<String>();
        String[] ms = modes.split(",");
        int i = 0;
        while (i < ms.length) {
            modeset.add(ms[i].trim());
            ++i;
        }
        return modeset;
    }

    private String createModesetString(Set modes) {
        String str = "";
        if (modes != null) {
            Iterator iter = modes.iterator();
            while (iter.hasNext()) {
                str = String.valueOf(str) + iter.next();
                if (!iter.hasNext()) continue;
                str = String.valueOf(str) + ",";
            }
        }
        return str;
    }

    public void schedulePostSwitch(Job job) {
        this.fPerspectiveSwitchLock.schedulePostSwitch(job);
    }

    public void suspended(ILaunch launch, Object context) {
        this.handleBreakpointHit(launch);
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        try {
            DebugUIPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.debug.ui.PREF_LAUNCH_PERSPECTIVES", this.generatePerspectiveXML());
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(DebugUIPlugin.newErrorStatus("Exception occurred while generating launch perspectives preference XML", e));
        }
    }

    class PerspectiveContext {
        private ILaunchConfigurationType fType = null;
        private ILaunchDelegate fDelegate = null;
        private Map fPerspectives = null;

        public PerspectiveContext(ILaunchConfigurationType type, ILaunchDelegate delegate, Set modes) {
            this.fType = type;
            this.fDelegate = delegate;
            this.fPerspectives = new HashMap();
            this.fPerspectives.put(modes, null);
        }

        public boolean equals(Object object) {
            ILaunchDelegate delegate = null;
            ILaunchConfigurationType type = null;
            if (object instanceof ILaunch) {
                try {
                    ILaunch launch = (ILaunch)object;
                    type = launch.getLaunchConfiguration().getType();
                    delegate = PerspectiveManager.this.resolveLaunchDelegate(launch);
                }
                catch (CoreException coreException) {
                    return false;
                }
            } else if (object instanceof PerspectiveContext) {
                PerspectiveContext context = (PerspectiveContext)object;
                type = context.getLaunchConfigurationType();
                delegate = context.getLaunchDelegate();
            }
            if (this.fType != null && type != null && this.fType.getIdentifier().equals(type.getIdentifier())) {
                if (this.fDelegate == null) {
                    return delegate == null;
                }
                return this.fDelegate.equals(delegate);
            }
            return super.equals(object);
        }

        public ILaunchConfigurationType getLaunchConfigurationType() {
            return this.fType;
        }

        public ILaunchDelegate getLaunchDelegate() {
            return this.fDelegate;
        }

        public Map getPersepctiveMap() {
            return this.fPerspectives;
        }

        public void setPerspective(Set modes, String pid) {
            if (this.fPerspectives == null) {
                this.fPerspectives = new HashMap();
            }
            this.fPerspectives.put(modes, pid);
        }

        public String getPerspective(Set modes) {
            if (this.fPerspectives != null) {
                return (String)this.fPerspectives.get(modes);
            }
            return null;
        }
    }

    public class PerspectiveSwitchLock {
        private int fSwitch = 0;
        private List fJobs = new ArrayList();

        public synchronized void startSwitch() {
            ++this.fSwitch;
        }

        public synchronized void endSwitch() {
            --this.fSwitch;
            if (this.fSwitch == 0) {
                Iterator jobs = this.fJobs.iterator();
                while (jobs.hasNext()) {
                    ((Job)jobs.next()).schedule();
                }
                this.fJobs.clear();
            }
        }

        public synchronized void schedulePostSwitch(Job job) {
            if (this.fSwitch > 0) {
                this.fJobs.add(job);
            } else {
                job.schedule();
            }
        }
    }
}

