/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    int window;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    org.eclipse.swt.graphics.Point adjustMoveCursor() {
        Object pt;
        if (this.bounds == null) {
            return null;
        }
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        if (this.parent != null) {
            pt = this.parent.toDisplay(newX, newY);
            newX = ((org.eclipse.swt.graphics.Point)pt).x;
            newY = ((org.eclipse.swt.graphics.Point)pt).y;
        }
        pt = new CGPoint();
        ((CGPoint)pt).x = newX;
        ((CGPoint)pt).y = newY;
        OS.CGWarpMouseCursorPosition((CGPoint)pt);
        return new org.eclipse.swt.graphics.Point((int)((CGPoint)pt).x, (int)((CGPoint)pt).y);
    }

    org.eclipse.swt.graphics.Point adjustResizeCursor(boolean movePointer) {
        Object pt;
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            pt = this.parent.toDisplay(newX, newY);
            newX = ((org.eclipse.swt.graphics.Point)pt).x;
            newY = ((org.eclipse.swt.graphics.Point)pt).y;
        }
        if (movePointer) {
            pt = new CGPoint();
            ((CGPoint)pt).x = newX;
            ((CGPoint)pt).y = newY;
            OS.CGWarpMouseCursorPosition((CGPoint)pt);
        }
        if (this.clientCursor == null) {
            Cursor newCursor = null;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    newCursor = new Cursor(this.display, 5);
                }
            }
            this.display.setCursor(newCursor.handle);
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = newCursor;
        }
        return new org.eclipse.swt.graphics.Point(newX, newY);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles(int window, Rectangle[] rects, boolean erase) {
        int[] context = new int[1];
        int port = OS.GetWindowPort(window);
        Rect portRect = new Rect();
        OS.GetPortBounds(port, portRect);
        OS.QDBeginCGContext(port, context);
        OS.CGContextScaleCTM(context[0], 1.0f, -1.0f);
        OS.CGContextTranslateCTM(context[0], 0.0f, portRect.top - portRect.bottom);
        CGRect cgRect = new CGRect();
        org.eclipse.swt.graphics.Point parentOrigin = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new org.eclipse.swt.graphics.Point(0, 0);
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            cgRect.x = rect.x + parentOrigin.x;
            cgRect.y = rect.y + parentOrigin.y;
            cgRect.width = rect.width;
            cgRect.height = rect.height;
            if (erase) {
                cgRect.width += 1.0f;
                cgRect.height += 1.0f;
                OS.CGContextClearRect(context[0], cgRect);
            } else {
                cgRect.x += 0.5f;
                cgRect.y += 0.5f;
                OS.CGContextStrokeRect(context[0], cgRect);
            }
            ++i;
        }
        OS.CGContextSynchronize(context[0]);
        OS.QDEndCGContext(port, context);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    int kEventMouse(int eventKind, int nextHandler, int theEvent, int userData) {
        int sizeof = 4;
        Point where = new Point();
        OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, where);
        int newX = where.h;
        int newY = where.v;
        if (newX != this.oldX || newY != this.oldY) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                org.eclipse.swt.graphics.Point cursorPos;
                boolean orientationInit = this.resizeRectangles(newX - this.oldX, newY - this.oldY);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 0;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(this.window, rectsToErase, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                if ((cursorPos = this.adjustResizeCursor(orientationInit)) != null) {
                    newX = cursorPos.x;
                    newY = cursorPos.y;
                }
            } else {
                this.moveRectangles(newX - this.oldX, newY - this.oldY);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 0;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(this.window, rectsToErase, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
            }
            this.oldX = newX;
            this.oldY = newY;
        }
        this.tracking = eventKind != 2;
        return 0;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        return this.kEventMouse(6, nextHandler, theEvent, userData);
    }

    int kEventRawKeyPressed(int nextHandler, int theEvent, int userData) {
        if (!this.sendKeyEvent(1, theEvent)) {
            return 0;
        }
        int[] keyCode = new int[1];
        OS.GetEventParameter(theEvent, 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
        int stepSize = (modifiers[0] & 0x1000) != 0 ? 1 : 9;
        int xChange = 0;
        int yChange = 0;
        switch (keyCode[0]) {
            case 53: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 36: 
            case 76: {
                this.tracking = false;
                break;
            }
            case 123: {
                xChange = -stepSize;
                break;
            }
            case 124: {
                xChange = stepSize;
                break;
            }
            case 126: {
                yChange = -stepSize;
                break;
            }
            case 125: {
                yChange = stepSize;
            }
        }
        if (xChange != 0 || yChange != 0) {
            org.eclipse.swt.graphics.Point cursorPos;
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            int newX = this.oldX + xChange;
            int newY = this.oldY + yChange;
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(xChange, yChange);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 0;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(this.window, rectsToErase, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                cursorPos = this.adjustResizeCursor(true);
            } else {
                this.moveRectangles(xChange, yChange);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 0;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(this.window, rectsToErase, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                cursorPos = this.adjustMoveCursor();
            }
            if (cursorPos != null) {
                this.oldX = cursorPos.x;
                this.oldY = cursorPos.y;
            }
        }
        return 0;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        return this.kEventMouse(5, nextHandler, theEvent, userData);
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        return this.kEventMouse(2, nextHandler, theEvent, userData);
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        org.eclipse.swt.graphics.Point cursorPos;
        int hStyle;
        this.checkWidget();
        this.cancelled = false;
        this.tracking = true;
        this.window = this.display.createOverlayWindow();
        OS.ShowWindow(this.window);
        this.drawRectangles(this.window, this.rectangles, false);
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        if (OS.StillDown()) {
            Point pt = new Point();
            OS.GetGlobalMouse(pt);
            cursorPos = new org.eclipse.swt.graphics.Point(pt.h, pt.v);
        } else {
            cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor(true) : this.adjustMoveCursor();
        }
        if (cursorPos != null) {
            this.oldX = cursorPos.x;
            this.oldY = cursorPos.y;
        }
        int[] outEvent = new int[1];
        while (this.tracking && !this.cancelled) {
            int status = OS.ReceiveNextEvent(0, null, 0.0, true, outEvent);
            if (status != 0) continue;
            int event = outEvent[0];
            int eventClass = OS.GetEventClass(event);
            int eventKind = OS.GetEventKind(event);
            int nextHandler = 0;
            block0 : switch (eventClass) {
                case 1836021107: {
                    switch (eventKind) {
                        case 2: {
                            this.kEventMouseUp(nextHandler, event, 0);
                            break;
                        }
                        case 5: {
                            this.kEventMouseMoved(nextHandler, event, 0);
                            break;
                        }
                        case 6: {
                            this.kEventMouseDragged(nextHandler, event, 0);
                        }
                    }
                    break;
                }
                case 1801812322: {
                    switch (eventKind) {
                        case 1: {
                            this.kEventRawKeyDown(nextHandler, event, 0);
                            break block0;
                        }
                        case 4: {
                            this.kEventRawKeyModifiersChanged(nextHandler, event, 0);
                            break block0;
                        }
                        case 2: {
                            this.kEventRawKeyRepeat(nextHandler, event, 0);
                            break block0;
                        }
                        case 3: {
                            this.kEventRawKeyUp(nextHandler, event, 0);
                        }
                    }
                }
            }
            boolean dispatch = true;
            if (this.tracking && !this.cancelled) {
                if (eventClass == 1836021107) {
                    dispatch = false;
                }
                if (eventClass == 1801812322) {
                    dispatch = false;
                }
            }
            if (dispatch) {
                OS.SendEventToEventTarget(event, OS.GetEventDispatcherTarget());
            }
            OS.ReleaseEvent(event);
            if (this.clientCursor == null || this.resizeCursor != null) continue;
            this.display.setCursor(this.clientCursor.handle);
        }
        if (!this.isDisposed()) {
            this.drawRectangles(this.window, this.rectangles, true);
        }
        OS.DisposeWindow(this.window);
        this.tracking = false;
        this.window = 0;
        return !this.cancelled;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    boolean resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return false;
        }
        boolean orientationInit = false;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x4000;
            orientationInit = true;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x20000;
            orientationInit = true;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x80;
            orientationInit = true;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x400;
            orientationInit = true;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return orientationInit;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return orientationInit;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return orientationInit;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return orientationInit;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
        return orientationInit;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = newCursor;
        if (newCursor != null && this.inEvent) {
            this.display.setCursor(newCursor.handle);
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

