/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuItemRenderer;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HandledMenuItemRenderer
extends MenuItemRenderer {
    @Inject
    Logger logger;

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MHandledMenuItem) || !(parent instanceof Menu)) {
            return null;
        }
        MHandledMenuItem itemModel = (MHandledMenuItem)element;
        if (itemModel.getVisibleWhen() != null) {
            this.processVisible((MMenuItem)itemModel);
        }
        if (!itemModel.isVisible()) {
            return null;
        }
        int addIndex = this.calcVisibleIndex(element);
        int flags = 0;
        if (itemModel.getType() == ItemType.PUSH) {
            flags = 8;
        } else if (itemModel.getType() == ItemType.CHECK) {
            flags = 32;
        } else if (itemModel.getType() == ItemType.RADIO) {
            flags = 16;
        }
        MenuItem newItem = new MenuItem((Menu)parent, flags, addIndex);
        this.setItemText((MMenuItem)itemModel, newItem);
        newItem.setImage(this.getImage((MUILabel)itemModel));
        this.setEnabled((MHandledItem)itemModel, newItem);
        newItem.setEnabled(itemModel.isEnabled());
        newItem.setSelection(itemModel.isSelected());
        return newItem;
    }

    private void setEnabled(final MHandledItem item, final MenuItem newItem) {
        final IEclipseContext lclContext = this.getContext((MUIElement)item);
        lclContext.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                if (newItem.isDisposed()) {
                    return false;
                }
                EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
                ParameterizedCommand cmd = item.getWbCommand();
                if (cmd == null) {
                    cmd = HandledMenuItemRenderer.this.generateParameterizedCommand(item, lclContext);
                }
                if (cmd == null) {
                    return false;
                }
                item.setEnabled(service.canExecute(cmd));
                return true;
            }
        });
    }

    protected void setItemText(MMenuItem model, MenuItem item) {
        String text = model.getLabel();
        if (model instanceof MHandledItem) {
            TriggerSequence sequence;
            MHandledItem handledItem = (MHandledItem)model;
            IEclipseContext context = this.getContext((MUIElement)model);
            EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand(handledItem, context);
            }
            if (cmd != null && (text == null || text.length() == 0)) {
                try {
                    text = cmd.getName();
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
            }
            if ((sequence = bs.getBestSequenceFor(handledItem.getWbCommand())) != null) {
                text = String.valueOf(text) + '\t' + sequence.format();
            }
            item.setText(text == null ? handledItem.getCommand().getElementId() : text);
        } else {
            super.setItemText(model, item);
        }
    }

    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (me instanceof MHandledItem) {
            final MHandledItem item = (MHandledItem)me;
            final IEclipseContext lclContext = this.getContext(me);
            MenuItem mi = (MenuItem)me.getWidget();
            mi.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
                    ParameterizedCommand cmd = item.getWbCommand();
                    if (cmd == null && (cmd = HandledMenuItemRenderer.this.generateParameterizedCommand(item, lclContext)) == null) {
                        return;
                    }
                    lclContext.set(MItem.class.getName(), (Object)item);
                    service.executeHandler(cmd);
                    lclContext.remove(MItem.class.getName());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class.getName());
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getElementId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }
}

