/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.part.ViewPart;

public class CompatibilityView
extends CompatibilityPart {
    private ViewReference reference;

    @Inject
    CompatibilityView(MPart part, ViewReference ref) {
        super(part);
        this.reference = ref;
    }

    public IViewPart getView() {
        return (IViewPart)this.getPart();
    }

    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    protected void createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        MRenderedMenu menu;
        ToolBarManager tbm = (ToolBarManager)((ViewPart)legacyPart).getViewSite().getActionBars().getToolBarManager();
        ToolBar tb = tbm.createControl(parent);
        super.createPartControl(legacyPart, parent);
        tb.dispose();
        MenuManager mm = (MenuManager)((ViewPart)legacyPart).getViewSite().getActionBars().getMenuManager();
        if (mm.getItems().length > 0) {
            menu = null;
            for (MMenu me : this.part.getMenus()) {
                if (!me.getTags().contains("ViewMenu") || !(me instanceof MRenderedMenu)) continue;
                menu = (MRenderedMenu)me;
                break;
            }
            if (menu == null) {
                menu = MenuFactoryImpl.eINSTANCE.createRenderedMenu();
                menu.setElementId(this.part.getElementId());
                menu.getTags().add("ViewMenu");
                menu.getTags().add("menuContribution:menu");
                this.part.getMenus().add(menu);
            }
            menu.setContributionManager((Object)mm);
        } else {
            menu = null;
            for (MMenu me : this.part.getMenus()) {
                if (!me.getTags().contains("ViewMenu")) continue;
                menu = me;
                break;
            }
            if (menu == null) {
                menu = MenuFactoryImpl.eINSTANCE.createMenu();
                menu.setElementId(this.part.getElementId());
                menu.getTags().add("ViewMenu");
                menu.getTags().add("menuContribution:menu");
                this.part.getMenus().add(menu);
            }
        }
        if (tbm.getItems().length > 0) {
            MToolBar toolbar = this.part.getToolbar();
            if (toolbar == null) {
                toolbar = MenuFactoryImpl.eINSTANCE.createRenderedToolBar();
                toolbar.setElementId(this.part.getElementId());
                this.part.setToolbar(toolbar);
            }
            if (toolbar instanceof MRenderedToolBar) {
                ((MRenderedToolBar)toolbar).setContributionManager((Object)tbm);
            }
        }
    }
}

