/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveRegistry
implements IPerspectiveRegistry,
IExtensionChangeHandler {
    @Inject
    private IExtensionRegistry extensionRegistry;
    private Map<String, IPerspectiveDescriptor> descriptors = new HashMap<String, IPerspectiveDescriptor>();

    @PostConstruct
    void postConstruct() {
        IExtensionPoint point = this.extensionRegistry.getExtensionPoint("org.eclipse.ui.perspectives");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute("id");
            String label = element.getAttribute("name");
            this.descriptors.put(id, new PerspectiveDescriptor(id, label, element));
            ++n2;
        }
    }

    public PerspectiveRegistry() {
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, null);
    }

    public IPerspectiveDescriptor clonePerspective(String id, String label, IPerspectiveDescriptor desc) throws IllegalArgumentException {
        E4Util.unsupported("clonePerspective");
        return null;
    }

    public void deletePerspective(IPerspectiveDescriptor persp) {
        E4Util.unsupported("deletePerspective");
    }

    public void deletePerspectives(ArrayList perspToDelete) {
        int i = 0;
        while (i < perspToDelete.size()) {
            this.deletePerspective((IPerspectiveDescriptor)perspToDelete.get(i));
            ++i;
        }
    }

    public IPerspectiveDescriptor findPerspectiveWithId(String perspectiveId) {
        return this.descriptors.get(perspectiveId);
    }

    public IPerspectiveDescriptor findPerspectiveWithLabel(String label) {
        for (IPerspectiveDescriptor descriptor : this.descriptors.values()) {
            if (!descriptor.getLabel().equals(label)) continue;
            return descriptor;
        }
        return null;
    }

    public String getDefaultPerspective() {
        return PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId");
    }

    public IPerspectiveDescriptor[] getPerspectives() {
        return this.descriptors.values().toArray(new IPerspectiveDescriptor[this.descriptors.size()]);
    }

    public void setDefaultPerspective(String id) {
        IPerspectiveDescriptor desc = this.findPerspectiveWithId(id);
        if (desc != null) {
            PrefUtil.getAPIPreferenceStore().setValue("defaultPerspectiveId", id);
        }
    }

    public boolean validateLabel(String label) {
        return (label = label.trim()).length() > 0;
    }

    public void revertPerspective(IPerspectiveDescriptor perspToRevert) {
        E4Util.unsupported("revertPerspective");
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public void removeExtension(IExtension source, Object[] objects) {
    }

    public void addExtension(IExtensionTracker tracker, IExtension addedExtension) {
    }
}

