/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSet {
    public static ContextSet EMPTY = new ContextSet(Collections.EMPTY_LIST);
    private static Comparator<Context> CONTEXT_COMP = null;
    private List<Context> contexts;

    public static void setComparator(Comparator<Context> comp) {
        CONTEXT_COMP = comp;
    }

    public static Comparator<Context> getComparator() {
        return CONTEXT_COMP;
    }

    public ContextSet(Collection<Context> c) {
        this.contexts = new ArrayList<Context>(c);
        Collections.sort(this.contexts, CONTEXT_COMP);
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        return this.contexts.equals(((ContextSet)o).contexts);
    }

    public int hashCode() {
        return this.contexts.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CComp
    implements Comparator<Context> {
        private ContextManager manager;

        public CComp(ContextManager manager) {
            this.manager = manager;
        }

        @Override
        public int compare(Context o1, Context o2) {
            int l2;
            if (o1.equals((Object)o2)) {
                return 0;
            }
            int l1 = this.getLevel(o1);
            if (l1 != (l2 = this.getLevel(o2))) {
                return l1 - l2;
            }
            return o1.getId().compareTo(o2.getId());
        }

        private int getLevel(Context c) {
            int l = 0;
            try {
                String parentId = c.getParentId();
                while (parentId != null) {
                    ++l;
                    Context context = this.manager.getContext(parentId);
                    parentId = context.getParentId();
                }
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
            }
            return l;
        }
    }
}

