/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSEngineHelper {
    IEclipseContext context;
    Control control;
    IThemeEngine engine;
    CSSEngine cssEngine;
    CSSStyleDeclaration style;

    public CSSEngineHelper(IEclipseContext context, Control control) {
        this.context = context;
        this.control = control;
        this.initialize();
    }

    private void initialize() {
        this.engine = (IThemeEngine)this.context.get(IThemeEngine.class);
        if (this.engine != null) {
            CSSEngine cssEngine = this.engine.getCSSEngine();
            Element e = cssEngine.getCSSElementContext((Object)this.control).getElement();
            this.style = cssEngine.getViewCSS().getComputedStyle(e, null);
        }
    }

    public int getMarginBottom(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-bottom"), defaultValue);
    }

    public int getMarginTop(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-top"), defaultValue);
    }

    public int getMarginLeft(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-left"), defaultValue);
    }

    public int getMarginRight(int defaultValue) {
        if (this.style == null) {
            return defaultValue;
        }
        return this.getPxValue(this.style.getPropertyCSSValue("margin-right"), defaultValue);
    }

    private int getPxValue(CSSValue value, int defaultValue) {
        if (value != null && value.getCssValueType() == 1 && ((CSSPrimitiveValue)value).getPrimitiveType() == 5) {
            return (int)((CSSPrimitiveValue)value).getFloatValue((short)5);
        }
        return defaultValue;
    }
}

