/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.CompatibilityMarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerResourceUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.ContentGeneratorDescriptor;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class MarkerContentGenerator {
    private static final String TAG_COLUMN_VISIBILITY = "visible";
    private static final String TAG_FILTERS_SECTION = "filterGroups";
    private static final String TAG_GROUP_ENTRY = "filterGroup";
    private static final String TAG_AND = "andFilters";
    private static final String TAG_LEGACY_FILTER_ENTRY = "filter";
    private final Collection FILTERS_CHANGED = Collections.EMPTY_SET;
    private ContentGeneratorDescriptor generatorDescriptor;
    private MarkerField[] visibleFields;
    private Collection enabledFilters;
    private Collection filters;
    private boolean andFilters = false;
    private IResource[] selectedResources = MarkerSupportInternalUtilities.EMPTY_RESOURCE_ARRAY;
    private Collection currentResources = Collections.EMPTY_SET;
    private CachedMarkerBuilder builder;
    private String viewId;
    private IPropertyChangeListener filterPreferenceListener;

    public MarkerContentGenerator(ContentGeneratorDescriptor generatorDescriptor, CachedMarkerBuilder builder, String viewId) {
        this.generatorDescriptor = generatorDescriptor;
        this.viewId = viewId;
        this.setBuilder(builder);
    }

    void setBuilder(CachedMarkerBuilder builder) {
        this.builder = builder;
        this.initializePreferenceListener();
        this.builder.setGenerator(this);
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    void requestMarkerUpdate() {
        if (this.builder != null) {
            this.builder.scheduleUpdate(0L);
        }
    }

    boolean allTypesSelected(Collection selectedTypes) {
        return this.generatorDescriptor.allTypesSelected(selectedTypes);
    }

    MarkerField[] getAllFields() {
        return this.generatorDescriptor.getAllFields();
    }

    MarkerField[] getVisibleFields() {
        return this.visibleFields;
    }

    void setVisibleFields(Collection visible) {
        MarkerField[] newFields = new MarkerField[visible.size()];
        visible.toArray(newFields);
        this.visibleFields = newFields;
    }

    Object[] getHiddenFields() {
        MarkerField[] all = this.getAllFields();
        MarkerField[] visible = this.getVisibleFields();
        HashSet<MarkerField> hidden = new HashSet<MarkerField>();
        int i = 0;
        while (i < all.length) {
            hidden.add(all[i]);
            ++i;
        }
        i = 0;
        while (i < visible.length) {
            hidden.remove(visible[i]);
            ++i;
        }
        return hidden.toArray();
    }

    void initialise(IMemento memento) {
        this.initialiseVisibleFields(memento);
    }

    void saveSate(IMemento memento, MarkerField[] displayedFields) {
        int i = 0;
        while (i < displayedFields.length) {
            memento.createChild(TAG_COLUMN_VISIBILITY, displayedFields[i].getConfigurationElement().getAttribute("id"));
            ++i;
        }
    }

    void restoreState(IMemento memento) {
        this.initialiseVisibleFields(memento);
    }

    private void initialiseVisibleFields(IMemento memento) {
        if (memento == null || memento.getChildren(TAG_COLUMN_VISIBILITY).length == 0) {
            MarkerField[] initialFields = this.getInitialVisible();
            this.visibleFields = new MarkerField[initialFields.length];
            System.arraycopy(initialFields, 0, this.visibleFields, 0, initialFields.length);
            return;
        }
        IMemento[] visible = memento.getChildren(TAG_COLUMN_VISIBILITY);
        ArrayList newVisible = new ArrayList();
        MarkerField[] all = this.getAllFields();
        Hashtable<String, MarkerField> allTable = new Hashtable<String, MarkerField>();
        int i = 0;
        while (i < all.length) {
            allTable.put(all[i].getConfigurationElement().getAttribute("id"), all[i]);
            ++i;
        }
        i = 0;
        while (i < visible.length) {
            String key = visible[i].getID();
            if (allTable.containsKey(key)) {
                newVisible.add(allTable.get(key));
            }
            ++i;
        }
        this.visibleFields = new MarkerField[newVisible.size()];
        newVisible.toArray(this.visibleFields);
    }

    Collection createFilterConfigurationFields() {
        ArrayList<FilterConfigurationArea> result = new ArrayList<FilterConfigurationArea>();
        int i = 0;
        while (i < this.visibleFields.length) {
            FilterConfigurationArea area = MarkerSupportInternalUtilities.generateFilterArea(this.visibleFields[i]);
            if (area != null) {
                result.add(area);
            }
            ++i;
        }
        return result;
    }

    String getCategoryName() {
        return this.generatorDescriptor.getCategoryName();
    }

    Collection getAllFilters() {
        if (this.filters == null || this.filters == this.FILTERS_CHANGED) {
            this.filters = this.getDeclaredFilters();
            this.loadFiltersPreference();
        }
        return this.filters;
    }

    Collection getEnabledFilters() {
        if (this.enabledFilters == null || this.enabledFilters == this.FILTERS_CHANGED) {
            HashSet<MarkerFieldFilterGroup> enabled = new HashSet<MarkerFieldFilterGroup>();
            Iterator filtersIterator = this.getAllFilters().iterator();
            while (filtersIterator.hasNext()) {
                MarkerFieldFilterGroup next = (MarkerFieldFilterGroup)filtersIterator.next();
                if (!next.isEnabled()) continue;
                enabled.add(next);
            }
            this.enabledFilters = enabled;
        }
        return this.enabledFilters;
    }

    protected void rebuildFilters() {
        this.filters = this.FILTERS_CHANGED;
        this.enabledFilters = this.FILTERS_CHANGED;
        this.requestMarkerUpdate();
    }

    void disableAllFilters() {
        Collection allFilters = this.getEnabledFilters();
        Iterator enabled = allFilters.iterator();
        while (enabled.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)enabled.next();
            group.setEnabled(false);
        }
        allFilters.clear();
        this.writeFiltersPreference();
        this.requestMarkerUpdate();
    }

    void toggleFilter(MarkerFieldFilterGroup group) {
        Collection enabled = this.getEnabledFilters();
        if (enabled.remove(group)) {
            group.setEnabled(false);
        } else {
            group.setEnabled(true);
            enabled.add(group);
        }
        this.writeFiltersPreference();
        this.requestMarkerUpdate();
    }

    void updateFilters(Collection filters, boolean andFilters) {
        this.setAndFilters(andFilters);
        this.filters = filters;
        this.enabledFilters = this.FILTERS_CHANGED;
        this.writeFiltersPreference();
        this.requestMarkerUpdate();
    }

    void setAndFilters(boolean and) {
        this.andFilters = and;
    }

    boolean andFilters() {
        return this.andFilters;
    }

    Collection getDeclaredFilters() {
        ArrayList<MarkerFieldFilterGroup> filters = new ArrayList<MarkerFieldFilterGroup>();
        IConfigurationElement[] filterReferences = this.generatorDescriptor.getFilterReferences();
        int i = 0;
        while (i < filterReferences.length) {
            filters.add(new MarkerFieldFilterGroup(filterReferences[i], this));
            ++i;
        }
        if (this.viewId != null && this.viewId.equals("org.eclipse.ui.views.ProblemView")) {
            Iterator problemFilters = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
            while (problemFilters.hasNext()) {
                filters.add(new CompatibilityMarkerFieldFilterGroup((ProblemFilter)problemFilters.next(), this));
            }
        }
        return filters;
    }

    private String getLegacyFiltersPreferenceName() {
        if (this.viewId != null && this.viewId.equals("org.eclipse.ui.views.BookmarkView")) {
            return "BOOKMARKS_FILTERS";
        }
        if (this.viewId != null && this.viewId.equals("org.eclipse.ui.views.TaskList")) {
            return "TASKS_FILTERS";
        }
        return "PROBLEMS_FILTERS";
    }

    private void loadFilterSettings(IMemento memento) {
        if (memento == null) {
            return;
        }
        Boolean andValue = memento.getBoolean(TAG_AND);
        if (andValue != null) {
            this.setAndFilters(andValue);
        }
        IMemento[] children = memento.getChildren(TAG_GROUP_ENTRY);
        int i = 0;
        while (i < children.length) {
            IMemento child = children[i];
            String id = child.getString("IMemento.internal.id");
            if (id != null && !this.loadGroupWithID(child, id)) {
                this.loadUserFilter(child);
            }
            ++i;
        }
    }

    private void loadFiltersFrom(String mementoString) {
        if (mementoString.equals("")) {
            return;
        }
        try {
            this.loadFilterSettings((IMemento)XMLMemento.createReadRoot((Reader)new StringReader(mementoString)));
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
    }

    private void loadFiltersPreference() {
        this.loadFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(this.getMementoPreferenceName()));
        String legacyFilters = this.getLegacyFiltersPreferenceName();
        String migrationPreference = String.valueOf(legacyFilters) + "_MIGRATE";
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(migrationPreference)) {
            return;
        }
        this.loadLegacyFiltersFrom(IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(legacyFilters));
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(migrationPreference, true);
    }

    private String getMementoPreferenceName() {
        return CachedMarkerBuilder.getMementoPreferenceName(this.viewId);
    }

    private boolean loadGroupWithID(IMemento child, String id) {
        Iterator groups = this.getAllFilters().iterator();
        while (groups.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groups.next();
            if (!id.equals(group.getID())) continue;
            group.loadSettings(child);
            return true;
        }
        return false;
    }

    private void loadLegacyFilter(IMemento child) {
        MarkerFieldFilterGroup newGroup = new MarkerFieldFilterGroup(null, this);
        newGroup.legacyLoadSettings(child);
        this.getAllFilters().add(newGroup);
    }

    private void loadLegacyFiltersFrom(String mementoString) {
        if (mementoString.equals("")) {
            return;
        }
        try {
            XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
            this.restoreLegacyFilters((IMemento)memento);
        }
        catch (WorkbenchException e) {
            StatusManager.getManager().handle(e.getStatus());
            return;
        }
    }

    private void loadUserFilter(IMemento child) {
        MarkerFieldFilterGroup newGroup = new MarkerFieldFilterGroup(null, this);
        newGroup.loadSettings(child);
        this.getAllFilters().add(newGroup);
    }

    private void restoreLegacyFilters(IMemento memento) {
        IMemento[] sections = null;
        if (memento != null) {
            sections = memento.getChildren(TAG_LEGACY_FILTER_ENTRY);
        }
        int i = 0;
        while (i < sections.length) {
            IMemento child = sections[i];
            String id = child.getString("IMemento.internal.id");
            if (id != null) {
                this.loadLegacyFilter(child);
            }
            ++i;
        }
    }

    private void writeFiltersPreference() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_FILTERS_SECTION);
        this.writeFiltersSettings(memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.getDefault().getLog().log(Util.errorStatus(e));
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().putValue(this.getMementoPreferenceName(), writer.toString());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
    }

    private void initializePreferenceListener() {
        if (this.filterPreferenceListener == null) {
            this.filterPreferenceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals(MarkerContentGenerator.this.getMementoPreferenceName())) {
                        MarkerContentGenerator.this.rebuildFilters();
                    }
                }
            };
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.filterPreferenceListener);
        }
    }

    private void writeFiltersSettings(XMLMemento memento) {
        memento.putBoolean(TAG_AND, this.andFilters());
        Iterator groups = this.getAllFilters().iterator();
        while (groups.hasNext()) {
            MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groups.next();
            IMemento child = memento.createChild(TAG_GROUP_ENTRY, group.getID());
            group.saveFilterSettings(child);
        }
    }

    public String getId() {
        return this.generatorDescriptor.getId();
    }

    void setViewID(String viewId) {
        this.viewId = viewId;
    }

    public Object getViewId() {
        return this.viewId;
    }

    MarkerField[] getInitialVisible() {
        return this.generatorDescriptor.getInitialVisible();
    }

    MarkerGroup getMarkerGroup(String groupName) {
        Iterator groups = this.getMarkerGroups().iterator();
        while (groups.hasNext()) {
            MarkerGroup group = (MarkerGroup)groups.next();
            if (!group.getId().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    Collection getMarkerGroups() {
        return this.generatorDescriptor.getMarkerGroups();
    }

    public Collection getMarkerTypes() {
        return this.generatorDescriptor.getMarkerTypes();
    }

    public String[] getTypes() {
        Collection types = this.getMarkerTypes();
        String[] ids = new String[types.size()];
        Iterator iterator = types.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ids[i++] = ((MarkerType)iterator.next()).getId();
        }
        return ids;
    }

    String getName() {
        return this.generatorDescriptor.getName();
    }

    MarkerType getType(String typeId) {
        return this.generatorDescriptor.getType(typeId);
    }

    /*
     * Unable to fully structure code
     */
    boolean select(MarkerEntry entry) {
        try {
            block8: {
                enabledFilters = this.getEnabledFilters();
                resources = this.getSelectedResources();
                andFilters = this.andFilters();
                if (enabledFilters.size() <= 0) break block8;
                filtersIterator = enabledFilters.iterator();
                if (!andFilters) ** GOTO lbl16
                while (filtersIterator.hasNext()) {
                    group = (MarkerFieldFilterGroup)filtersIterator.next();
                    if (group.selectByScope(entry, resources) && group.selectByFilters(entry)) continue;
                    return false;
                }
                return true;
lbl-1000:
                // 1 sources

                {
                    group = (MarkerFieldFilterGroup)filtersIterator.next();
                    if (!group.selectByScope(entry, resources) || !group.selectByFilters(entry)) continue;
                    return true;
lbl16:
                    // 2 sources

                    ** while (filtersIterator.hasNext())
                }
lbl17:
                // 1 sources

                return false;
            }
            return true;
        }
        finally {
            entry.clearCache();
        }
    }

    void internalUpdateSelectedElements(Object[] elements) {
        ArrayList<Object> resourceCollection = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IResource) {
                resourceCollection.add(elements[i]);
            } else {
                MarkerResourceUtil.addResources(resourceCollection, (ResourceMapping)elements[i]);
            }
            ++i;
        }
        IResource[] newSelection = new IResource[resourceCollection.size()];
        resourceCollection.toArray(newSelection);
        this.selectedResources = newSelection;
    }

    void updateSelectedResource(Object[] newElements) {
        if (this.updateNeededForSelection(newElements)) {
            this.internalUpdateSelectedElements(newElements);
            this.requestMarkerUpdate();
        }
    }

    boolean updateNeededForSelection(Object[] newElements) {
        Iterator filters = this.getEnabledFilters().iterator();
        while (filters.hasNext()) {
            MarkerFieldFilterGroup filter = (MarkerFieldFilterGroup)filters.next();
            int scope = filter.getScope();
            if (scope == 0 || scope == 4 || newElements == null || newElements.length < 1) continue;
            if (this.selectedResources.length == 0) {
                return true;
            }
            if (Arrays.equals(this.selectedResources, newElements)) continue;
            if (scope == 3) {
                Collection oldProjects = MarkerResourceUtil.getProjectsAsCollection(this.selectedResources);
                Collection newProjects = MarkerResourceUtil.getProjectsAsCollection(newElements);
                if (oldProjects.size() == newProjects.size() && newProjects.containsAll(oldProjects)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    IResource[] getSelectedResources() {
        IResource[] selected = this.selectedResources;
        IResource[] resources = new IResource[selected.length];
        System.arraycopy(selected, 0, resources, 0, selected.length);
        return resources;
    }

    Collection getResourcesForBuild() {
        this.currentResources = MarkerResourceUtil.computeResources(this.getSelectedResources(), this.getEnabledFilters(), this.andFilters());
        return this.currentResources;
    }

    Collection generateMarkerEntries(IProgressMonitor monitor) {
        boolean includeSubTypes;
        LinkedList result = new LinkedList();
        String[] typeIds = this.getTypes();
        boolean cancelled = this.gatherMarkers(typeIds, includeSubTypes = this.builder.includeMarkerSubTypes(), result, monitor);
        if (cancelled) {
            result.clear();
        }
        return result;
    }

    boolean generateMarkerEntries(Collection result, IProgressMonitor monitor) {
        String[] typeIds = this.getTypes();
        boolean includeSubTypes = this.builder.includeMarkerSubTypes();
        return this.gatherMarkers(typeIds, includeSubTypes, result, monitor);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean gatherMarkers(String[] typeIds, boolean includeSubTypes, Collection result, IProgressMonitor monitor) {
        try {
            Collection resources = this.getResourcesForBuild();
            if (includeSubTypes) {
                String[] superTypes = MarkerResourceUtil.getMutuallyExclusiveSupersIds(typeIds);
                if (monitor.isCanceled()) {
                    return false;
                }
                int i = 0;
                while (i < superTypes.length) {
                    boolean success = this.internalGatherMarkers(resources, superTypes[i], includeSubTypes, result, monitor);
                    if (!success || monitor.isCanceled()) {
                        return false;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < typeIds.length) {
                    boolean success = this.internalGatherMarkers(resources, typeIds[i], includeSubTypes, result, monitor);
                    if (!success || monitor.isCanceled()) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            MarkerSupportInternalUtilities.showViewError(e);
            return false;
        }
        return true;
    }

    private boolean internalGatherMarkers(Collection resources, String typeId, boolean includeSubTypes, Collection result, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            IMarker[] markers = null;
            try {
                IResource resource = (IResource)iterator.next();
                if (!resource.isAccessible()) continue;
                markers = resource.findMarkers(typeId, includeSubTypes, 2);
            }
            catch (CoreException e) {
                MarkerSupportInternalUtilities.logViewError((Exception)((Object)e));
            }
            if (markers == null) continue;
            if (monitor.isCanceled()) {
                return false;
            }
            int i = 0;
            while (i < markers.length) {
                MarkerEntry entry = new MarkerEntry(markers[i]);
                if (this.select(entry)) {
                    result.add(entry);
                }
                if (i % 500 == 0 && monitor.isCanceled()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    void dispose() {
    }
}

