/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.launching.OSGiLaunchConfigurationInitializer;

public class OSGiFrameworkManager
implements IRegistryChangeListener {
    public static final String POINT_ID = "org.eclipse.pde.ui.osgiFrameworks";
    public static final String DEFAULT_FRAMEWORK = "org.eclipse.pde.ui.EquinoxFramework";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_DELEGATE = "launcherDelegate";
    public static final String ATT_INITIALIZER = "initializer";
    public static final String ELEMENT_FRAMEWORK = "framework";
    private Map fFrameworks;

    public IConfigurationElement[] getFrameworks() {
        if (this.fFrameworks == null) {
            this.loadElements();
        }
        return this.fFrameworks.values().toArray(new IConfigurationElement[this.fFrameworks.size()]);
    }

    public IConfigurationElement[] getSortedFrameworks() {
        IConfigurationElement[] elements = this.getFrameworks();
        return this.orderElements(elements);
    }

    private void loadElements() {
        this.fFrameworks = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(POINT_ID);
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute(ATT_ID);
            if (id != null && elements[i].getAttribute(ATT_NAME) != null && elements[i].getAttribute(ATT_DELEGATE) != null) {
                this.fFrameworks.put(id, elements[i]);
            }
            ++i;
        }
    }

    private IConfigurationElement[] orderElements(IConfigurationElement[] elems) {
        Arrays.sort(elems, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((IConfigurationElement)o1).getAttribute(OSGiFrameworkManager.ATT_NAME);
                String name2 = ((IConfigurationElement)o2).getAttribute(OSGiFrameworkManager.ATT_NAME);
                if (name1 != null) {
                    return name1.compareToIgnoreCase(name2);
                }
                return 1;
            }
        });
        return elems;
    }

    public void registryChanged(IRegistryChangeEvent event) {
    }

    public String getDefaultFramework() {
        PDEPreferencesManager store = PDELaunchingPlugin.getDefault().getPreferenceManager();
        return store.getString("Preference.default.osgi.framework");
    }

    public OSGiLaunchConfigurationInitializer getDefaultInitializer() {
        return this.getInitializer(this.getDefaultFramework());
    }

    public OSGiLaunchConfigurationInitializer getInitializer(String frameworkID) {
        if (this.fFrameworks == null) {
            this.loadElements();
        }
        if (this.fFrameworks.containsKey(frameworkID)) {
            try {
                Object result;
                IConfigurationElement element = (IConfigurationElement)this.fFrameworks.get(frameworkID);
                if (element.getAttribute(ATT_INITIALIZER) != null && (result = element.createExecutableExtension(ATT_INITIALIZER)) instanceof OSGiLaunchConfigurationInitializer) {
                    return (OSGiLaunchConfigurationInitializer)result;
                }
            }
            catch (CoreException coreException) {}
        }
        return new OSGiLaunchConfigurationInitializer();
    }

    public LaunchConfigurationDelegate getFrameworkLauncher(String frameworkID) {
        if (this.fFrameworks == null) {
            this.loadElements();
        }
        if (this.fFrameworks.containsKey(frameworkID)) {
            try {
                IConfigurationElement element = (IConfigurationElement)this.fFrameworks.get(frameworkID);
                Object result = element.createExecutableExtension(ATT_DELEGATE);
                if (result instanceof LaunchConfigurationDelegate) {
                    return (LaunchConfigurationDelegate)result;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String getFrameworkName(String frameworkID) {
        if (this.fFrameworks == null) {
            this.loadElements();
        }
        if (this.fFrameworks.containsKey(frameworkID)) {
            IConfigurationElement element = (IConfigurationElement)this.fFrameworks.get(frameworkID);
            return element.getAttribute(ATT_NAME);
        }
        return null;
    }

    public IConfigurationElement getFramework(String frameworkId) {
        if (this.fFrameworks == null) {
            this.loadElements();
        }
        return (IConfigurationElement)this.fFrameworks.get(frameworkId);
    }
}

