/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class CategoryFilterActionGroup
extends ActionGroup {
    private static int COUNTER = 0;
    private static final String FILTER_CATEGORY_ACTION_ID = "FilterCategoryActionId";
    private final String CATEGORY_MENU_GROUP_NAME = "CategoryMenuGroup" + COUNTER++;
    private static final int MAX_NUMBER_OF_CATEGORIES_IN_MENU = 5;
    private final StructuredViewer fViewer;
    private final String fViewerId;
    private final CategoryFilter fFilter;
    private final HashSet fFilteredCategories;
    private IJavaElement[] fInputElement;
    private final CategoryFilterMenuAction fMenuAction;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private final LinkedHashMap fLRUList;
    private boolean fFilterUncategorizedMembers;

    public CategoryFilterActionGroup(StructuredViewer viewer, String viewerId, IJavaElement[] input) {
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        Assert.isLegal((viewerId != null ? 1 : 0) != 0);
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.fLRUList = new LinkedHashMap(10, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 5;
            }
        };
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInputElement = input;
        this.fFilter = new CategoryFilter();
        this.fFilteredCategories = new HashSet();
        this.loadSettings();
        this.fMenuAction = new CategoryFilterMenuAction();
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    public void setInput(IJavaElement[] input) {
        Assert.isLegal((input != null ? 1 : 0) != 0);
        this.fInputElement = input;
    }

    private void loadSettings() {
        int i;
        String[] categories;
        this.fFilteredCategories.clear();
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        String string = store.getString(this.getPreferenceKey());
        if (string != null && string.length() > 0) {
            categories = string.split(";");
            i = 0;
            while (i < categories.length) {
                this.fFilteredCategories.add(categories[i]);
                ++i;
            }
        }
        if ((string = store.getString(String.valueOf(this.getPreferenceKey()) + ".LRU")) != null && string.length() > 0) {
            categories = string.split(";");
            i = categories.length - 1;
            while (i >= 0) {
                this.fLRUList.put(categories[i], categories[i]);
                --i;
            }
        }
        this.fFilterUncategorizedMembers = store.getBoolean(String.valueOf(this.getPreferenceKey()) + ".FilterUncategorized");
    }

    private void storeSettings() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        if (this.fFilteredCategories.size() == 0) {
            store.setValue(this.getPreferenceKey(), "");
        } else {
            StringBuffer buf = new StringBuffer();
            Iterator<Object> iter = this.fFilteredCategories.iterator();
            String element = (String)iter.next();
            buf.append(element);
            while (iter.hasNext()) {
                element = (String)iter.next();
                buf.append(';');
                buf.append(element);
            }
            store.setValue(this.getPreferenceKey(), buf.toString());
            buf = new StringBuffer();
            iter = this.fLRUList.values().iterator();
            element = (String)iter.next();
            buf.append(element);
            while (iter.hasNext()) {
                element = (String)iter.next();
                buf.append(';');
                buf.append(element);
            }
            store.setValue(String.valueOf(this.getPreferenceKey()) + ".LRU", buf.toString());
            store.setValue(String.valueOf(this.getPreferenceKey()) + ".FilterUncategorized", this.fFilterUncategorizedMembers);
        }
    }

    public void contributeToViewMenu(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator(this.CATEGORY_MENU_GROUP_NAME));
        menuManager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)this.fMenuAction);
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (!manager.isVisible()) {
                    return;
                }
                CategoryFilterActionGroup.this.updateMenu(manager);
            }
        };
        menuManager.addMenuListener(this.fMenuListener);
        this.fMenuManager = menuManager;
    }

    public void dispose() {
        super.dispose();
        if (this.fMenuManager != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
            this.fMenuManager = null;
            this.fMenuListener = null;
        }
    }

    private void updateMenu(IMenuManager manager) {
        IContributionItem[] items = manager.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IContributionItem removed;
                IContributionItem item = items[i];
                if (item != null && item.getId() != null && item.getId().equals(FILTER_CATEGORY_ACTION_ID) && (removed = manager.remove(item)) != null) {
                    item.dispose();
                }
                ++i;
            }
        }
        ArrayList menuEntries = new ArrayList();
        boolean hasUncategorizedMembers = this.getMenuCategories(menuEntries);
        Collections.sort(menuEntries, Collator.getInstance());
        if (menuEntries.size() > 0 && hasUncategorizedMembers) {
            manager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new FilterUncategorizedMembersAction());
        }
        int count = 0;
        Iterator iter = menuEntries.iterator();
        while (iter.hasNext()) {
            String category = (String)iter.next();
            manager.appendToGroup(this.CATEGORY_MENU_GROUP_NAME, (IAction)new CategoryFilterAction(category, count + 1));
            ++count;
        }
    }

    private boolean getMenuCategories(List result) {
        final HashSet categories = new HashSet();
        final HashSet foundLRUCategories = new HashSet();
        final boolean[] hasUncategorizedMember = new boolean[1];
        int i = 0;
        while (!(i >= this.fInputElement.length || hasUncategorizedMember[0] && foundLRUCategories.size() >= 5)) {
            this.collectCategories(this.fInputElement[i], new IResultCollector(){

                public boolean accept(String[] cats) {
                    if (cats.length > 0) {
                        int j = 0;
                        while (j < cats.length) {
                            String category = cats[j];
                            categories.add(category);
                            if (CategoryFilterActionGroup.this.fLRUList.containsKey(category)) {
                                foundLRUCategories.add(category);
                            }
                            ++j;
                        }
                    } else {
                        hasUncategorizedMember[0] = true;
                    }
                    return hasUncategorizedMember[0] && foundLRUCategories.size() >= 5;
                }
            });
            ++i;
        }
        int count = 0;
        Iterator iter = foundLRUCategories.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            result.add(element);
            ++count;
        }
        if (count < 5) {
            ArrayList sortedCategories = new ArrayList(categories);
            Collections.sort(sortedCategories, Collator.getInstance());
            Iterator iter2 = sortedCategories.iterator();
            while (iter2.hasNext() && count < 5) {
                String element = (String)iter2.next();
                if (foundLRUCategories.contains(element)) continue;
                result.add(element);
                ++count;
            }
        }
        return hasUncategorizedMember[0];
    }

    private boolean collectCategories(IJavaElement element, IResultCollector collector) {
        try {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                collector.accept(member.getCategories());
                return this.processChildren(member.getChildren(), collector);
            }
            if (element instanceof ICompilationUnit) {
                return this.processChildren(((ICompilationUnit)element).getChildren(), collector);
            }
            if (element instanceof IClassFile) {
                return this.processChildren(((IClassFile)element).getChildren(), collector);
            }
            if (element instanceof IJavaModel) {
                return this.processChildren(((IJavaModel)element).getChildren(), collector);
            }
            if (element instanceof IJavaProject) {
                return this.processChildren(((IJavaProject)element).getChildren(), collector);
            }
            if (element instanceof IPackageFragment) {
                return this.processChildren(((IPackageFragment)element).getChildren(), collector);
            }
            if (element instanceof IPackageFragmentRoot) {
                return this.processChildren(((IPackageFragmentRoot)element).getChildren(), collector);
            }
            return false;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return true;
        }
    }

    private boolean processChildren(IJavaElement[] children, IResultCollector collector) {
        int i = 0;
        while (i < children.length) {
            if (this.collectCategories(children[i], collector)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fireSelectionChange() {
        this.fViewer.getControl().setRedraw(false);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                CategoryFilterActionGroup.this.fViewer.refresh();
            }
        });
        this.fViewer.getControl().setRedraw(true);
    }

    private String getPreferenceKey() {
        return "CategoryFilterActionGroup." + this.fViewerId;
    }

    private void showCategorySelectionDialog(IJavaElement[] input) {
        final HashSet categories = new HashSet();
        int i = 0;
        while (i < input.length) {
            this.collectCategories(input[i], new IResultCollector(){

                public boolean accept(String[] cats) {
                    int j = 0;
                    while (j < cats.length) {
                        categories.add(cats[j]);
                        ++j;
                    }
                    return false;
                }
            });
            ++i;
        }
        CategoryFilterSelectionDialog dialog = new CategoryFilterSelectionDialog(this.fViewer.getControl().getShell(), new ArrayList(categories), new ArrayList(this.fFilteredCategories));
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            Iterator iter = categories.iterator();
            while (iter.hasNext()) {
                String category = (String)iter.next();
                if (this.contains(selected, category)) {
                    if (!this.fFilteredCategories.remove(category)) continue;
                    this.fLRUList.put(category, category);
                    continue;
                }
                if (!this.fFilteredCategories.add(category)) continue;
                this.fLRUList.put(category, category);
            }
            this.storeSettings();
            this.fireSelectionChange();
        }
    }

    private boolean contains(Object[] selected, String category) {
        int i = 0;
        while (i < selected.length) {
            if (selected[i].equals(category)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class CategoryFilter
    extends ViewerFilter {
        private CategoryFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IMember)) return true;
            IMember member = (IMember)element;
            try {
                String[] categories = member.getCategories();
                if (categories.length == 0) {
                    if (!CategoryFilterActionGroup.this.fFilterUncategorizedMembers) return true;
                    return false;
                }
                int i = 0;
                while (true) {
                    if (i >= categories.length) {
                        return false;
                    }
                    if (!CategoryFilterActionGroup.this.fFilteredCategories.contains(categories[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return true;
        }
    }

    private class CategoryFilterAction
    extends Action {
        private final String fCategory;

        public CategoryFilterAction(String category, int count) {
            this.fCategory = category;
            StringBuffer buf = new StringBuffer();
            buf.append('&').append(count).append(' ').append(this.fCategory);
            this.setText(buf.toString());
            this.setChecked(!CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory));
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            super.run();
            if (CategoryFilterActionGroup.this.fFilteredCategories.contains(this.fCategory)) {
                CategoryFilterActionGroup.this.fFilteredCategories.remove(this.fCategory);
            } else {
                CategoryFilterActionGroup.this.fFilteredCategories.add(this.fCategory);
            }
            CategoryFilterActionGroup.this.fLRUList.put(this.fCategory, this.fCategory);
            CategoryFilterActionGroup.this.storeSettings();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }

    private class CategoryFilterMenuAction
    extends Action {
        public CategoryFilterMenuAction() {
            this.setDescription(ActionMessages.CategoryFilterActionGroup_ShowCategoriesActionDescription);
            this.setToolTipText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesToolTip);
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowCategoriesLabel);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "category_menu.gif");
        }

        public void run() {
            CategoryFilterActionGroup.this.showCategorySelectionDialog(CategoryFilterActionGroup.this.fInputElement);
        }
    }

    private class CategoryFilterSelectionDialog
    extends SelectionStatusDialog
    implements IListAdapter {
        private static final int SELECT_ALL = 0;
        private static final int DESELECT_ALL = 1;
        private final CheckedListDialogField fCategoryList;

        public CategoryFilterSelectionDialog(Shell parent, List categories, List selectedCategories) {
            super(parent);
            this.setTitle(ActionMessages.CategoryFilterActionGroup_JavaCategoryFilter_title);
            String[] buttons = new String[]{ActionMessages.CategoryFilterActionGroup_SelectAllCategories, ActionMessages.CategoryFilterActionGroup_DeselectAllCategories};
            this.fCategoryList = new CheckedListDialogField(this, buttons, new ILabelProvider(this){
                final /* synthetic */ CategoryFilterSelectionDialog this$1;
                {
                    this.this$1 = categoryFilterSelectionDialog;
                }

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return (String)element;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.fCategoryList.addElements(categories);
            this.fCategoryList.setViewerComparator(new ViewerComparator());
            this.fCategoryList.setLabelText(ActionMessages.CategoryFilterActionGroup_SelectCategoriesDescription);
            this.fCategoryList.checkAll(true);
            Iterator iter = selectedCategories.iterator();
            while (iter.hasNext()) {
                String selected = (String)iter.next();
                this.fCategoryList.setChecked(selected, false);
            }
            if (categories.size() == 0) {
                this.fCategoryList.setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fCategoryList}, true, 5, 5);
            LayoutUtil.setHorizontalGrabbing(this.fCategoryList.getListControl(null));
            Dialog.applyDialogFont((Control)composite);
            this.setHelpAvailable(false);
            return composite;
        }

        protected void computeResult() {
            this.setResult(this.fCategoryList.getCheckedElements());
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 0) {
                this.fCategoryList.checkAll(true);
                this.fCategoryList.refresh();
            } else if (index == 1) {
                this.fCategoryList.checkAll(false);
                this.fCategoryList.refresh();
            }
        }

        public void doubleClicked(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            if (selectedElements.size() == 1) {
                Object selected;
                this.fCategoryList.setChecked(selected, !this.fCategoryList.isChecked(selected = selectedElements.get(0)));
            }
        }

        public void selectionChanged(ListDialogField field) {
        }
    }

    private class FilterUncategorizedMembersAction
    extends Action {
        public FilterUncategorizedMembersAction() {
            this.setText(ActionMessages.CategoryFilterActionGroup_ShowUncategorizedMembers);
            this.setChecked(!CategoryFilterActionGroup.this.fFilterUncategorizedMembers);
            this.setId(CategoryFilterActionGroup.FILTER_CATEGORY_ACTION_ID);
        }

        public void run() {
            CategoryFilterActionGroup.this.fFilterUncategorizedMembers = !CategoryFilterActionGroup.this.fFilterUncategorizedMembers;
            CategoryFilterActionGroup.this.storeSettings();
            CategoryFilterActionGroup.this.fireSelectionChange();
        }
    }

    private static interface IResultCollector {
        public boolean accept(String[] var1);
    }
}

