/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.CompositeDelta;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.EMFDeltaEntrySet;
import org.eclipse.e4.ui.internal.workbench.EMFDeltaMapSet;
import org.eclipse.e4.ui.internal.workbench.EMFModelDeltaDelayedSet;
import org.eclipse.e4.ui.internal.workbench.EMFModelDeltaSet;
import org.eclipse.e4.ui.internal.workbench.EMFModelDeltaThreeWayDelayedSet;
import org.eclipse.e4.ui.internal.workbench.EMFModelDeltaUnset;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindingTableContainer;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptorContainer;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContributions;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContributions;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContributions;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLModelReconciler
extends ModelReconciler {
    private static final String XMIID_ATTNAME = "xmiId";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ORIGINALREFERENCE_ELEMENT_NAME = "originalReference";
    private static final String NAMESPACE_ATTNAME = "e4namespace";
    private static final String CHANGES_ATTNAME = "changes";
    private static final String TYPE_ATTNAME = "type";
    private static final String UNSET_ATTNAME = "unset";
    private static final String UNSET_ATTVALUE_TRUE = "true";
    private static final String ENTRY_ATTVALUE_KEY = "key";
    private static final String ENTRY_ATTVALUE_VALUE = "value";
    private ChangeRecorder changeRecorder;
    private ChangeDescription changeDescription;
    private EObject rootObject;

    @Override
    public void recordChanges(Object object) {
        Assert.isNotNull((Object)object);
        this.rootObject = (EObject)object;
        this.changeRecorder = new ChangeRecorder(this.rootObject){

            protected boolean shouldRecord(EStructuralFeature feature, EObject eObject) {
                return !feature.isTransient() && super.shouldRecord(feature, eObject);
            }

            protected boolean shouldRecord(EStructuralFeature feature, EReference containment, Notification notification, EObject eObject) {
                return !feature.isTransient() && super.shouldRecord(feature, containment, notification, eObject);
            }
        };
        this.changeDescription = null;
    }

    static List<Object> getReferences(Object object) {
        TreeIterator it = ((EObject)object).eAllContents();
        LinkedList<Object> references = new LinkedList<Object>();
        while (it.hasNext()) {
            Object reference = it.next();
            references.add(reference);
        }
        return references;
    }

    @Override
    public Collection<ModelDelta> constructDeltas(Object object, Object serializedState) {
        this.rootObject = (EObject)object;
        List<Object> references = XMLModelReconciler.getReferences(this.rootObject);
        Document document = (Document)serializedState;
        LinkedList<ModelDelta> deltas = new LinkedList<ModelDelta>();
        NodeList rootNodeList = (NodeList)((Object)document.getDocumentElement());
        int i = 0;
        while (i < rootNodeList.getLength()) {
            Node node = rootNodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                this.constructDeltas(deltas, references, this.rootObject, element, element.getAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME));
            }
            ++i;
        }
        return deltas;
    }

    private static EStructuralFeature getStructuralFeature(EObject object, String featureName) {
        if (featureName.equals(APPLICATIONELEMENT_ELEMENTID_ATTNAME)) {
            return ApplicationPackageImpl.eINSTANCE.getApplicationElement_ElementId();
        }
        if (featureName.equals(APPLICATIONELEMENT_TAGS_ATTNAME)) {
            return ApplicationPackageImpl.eINSTANCE.getApplicationElement_Tags();
        }
        if (featureName.equals(APPLICATION_COMMANDS_ATTNAME)) {
            return ApplicationPackageImpl.eINSTANCE.getApplication_Commands();
        }
        if (featureName.equals(UILABEL_LABEL_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUILabel_Label();
        }
        if (featureName.equals(UILABEL_TOOLTIP_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUILabel_Tooltip();
        }
        if (featureName.equals(UILABEL_ICONURI_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUILabel_IconURI();
        }
        if (featureName.equals(UIELEMENT_TOBERENDERED_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUIElement_ToBeRendered();
        }
        if (featureName.equals(UIELEMENT_VISIBLE_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUIElement_Visible();
        }
        if (featureName.equals(ELEMENTCONTAINER_CHILDREN_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getElementContainer_Children();
        }
        if (featureName.equals(UIELEMENT_VISIBLEWHEN_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUIElement_VisibleWhen();
        }
        if (featureName.equals(UIELEMENT_PARENT_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUIElement_Parent();
        }
        if (featureName.equals(UIELEMENT_CONTAINERDATA_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getUIElement_ContainerData();
        }
        if (featureName.equals(ELEMENTCONTAINER_SELECTEDELEMENT_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getElementContainer_SelectedElement();
        }
        if (featureName.equals(COMMAND_COMMANDNAME_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getCommand_CommandName();
        }
        if (featureName.equals(COMMAND_DESCRIPTION_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getCommand_Description();
        }
        if (featureName.equals(KEYSEQUENCE_KEYSEQUENCE_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getKeySequence_KeySequence();
        }
        if (featureName.equals(BINDINGCONTAINER_BINDINGTABLES_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getBindingTableContainer_BindingTables();
        }
        if (featureName.equals(BINDINGCONTAINER_ROOTCONTEXT_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getBindingTableContainer_RootContext();
        }
        if (featureName.equals(BINDINGTABLES_BINDINGS_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getBindingTable_Bindings();
        }
        if (featureName.equals(BINDINGTABLES_BINDINGCONTEXTID_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getBindingTable_BindingContextId();
        }
        if (featureName.equals(HANDLER_COMMAND_ATTNAME) || featureName.equals(KEYBINDING_COMMAND_ATTNAME) || featureName.equals(HANDLEDITEM_COMMAND_ATTNAME)) {
            if (object instanceof MKeyBinding) {
                return CommandsPackageImpl.eINSTANCE.getKeyBinding_Command();
            }
            if (object instanceof MHandler) {
                return CommandsPackageImpl.eINSTANCE.getHandler_Command();
            }
            return MenuPackageImpl.eINSTANCE.getHandledItem_Command();
        }
        if (featureName.equals(COMMAND_PARAMETERS_ATTNAME) || featureName.equals(HANDLEDITEM_PARAMETERS_ATTNAME)) {
            if (object instanceof MHandledItem) {
                return MenuPackageImpl.eINSTANCE.getHandledItem_Parameters();
            }
            return CommandsPackageImpl.eINSTANCE.getCommand_Parameters();
        }
        if (featureName.equals(ITEM_ENABLED_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getItem_Enabled();
        }
        if (featureName.equals(ITEM_SELECTED_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getItem_Selected();
        }
        if (featureName.equals(ITEM_TYPE_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getItem_Type();
        }
        if (featureName.equals(PART_MENUS_ATTNAME) || featureName.equals(PARTDESCRIPTOR_MENUS_ATTNAME)) {
            if (object instanceof MPartDescriptor) {
                return BasicPackageImpl.eINSTANCE.getPartDescriptor_Menus();
            }
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getPart_Menus();
        }
        if (featureName.equals(PART_TOOLBAR_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getPart_Toolbar();
        }
        if (featureName.equals(GENERICTILE_HORIZONTAL_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getGenericTile_Horizontal();
        }
        if (featureName.equals(GENERICTRIMCONTAINER_SIDE_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getGenericTrimContainer_Side();
        }
        if (featureName.equals(HANDLERCONTAINER_HANDLERS_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getHandlerContainer_Handlers();
        }
        if (featureName.equals(CONTRIBUTION_PERSISTEDSTATE_ATTNAME)) {
            return ApplicationPackageImpl.eINSTANCE.getContribution_PersistedState();
        }
        if (featureName.equals(CONTRIBUTION_URI_ATTNAME)) {
            return ApplicationPackageImpl.eINSTANCE.getContribution_ContributionURI();
        }
        if (featureName.equals(WINDOW_SHAREDELEMENTS_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getWindow_SharedElements();
        }
        if (featureName.equals(WINDOW_MAINMENU_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getWindow_MainMenu();
        }
        if (featureName.equals(WINDOW_X_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getWindow_X();
        }
        if (featureName.equals(WINDOW_Y_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getWindow_Y();
        }
        if (featureName.equals(WINDOW_WIDTH_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getWindow_Width();
        }
        if (featureName.equals(WINDOW_HEIGHT_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getWindow_Height();
        }
        if (featureName.equals(PARTDESCRIPTOR_ALLOWMULTIPLE_ATTNAME)) {
            return BasicPackageImpl.eINSTANCE.getPartDescriptor_AllowMultiple();
        }
        if (featureName.equals(PARTDESCRIPTOR_CATEGORY_ATTNAME)) {
            return BasicPackageImpl.eINSTANCE.getPartDescriptor_Category();
        }
        if (featureName.equals(PART_CLOSEABLE_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getPart_Closeable();
        }
        if (featureName.equals(INPUT_INPUTURI_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getInput_InputURI();
        }
        if (featureName.equals(CONTEXT_PROPERTIES_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getContext_Properties();
        }
        if (featureName.equals(TRIMMEDWINDOW_TRIMBARS_ATTNAME)) {
            return org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE.getTrimmedWindow_TrimBars();
        }
        if (featureName.equals(PLACEHOLDER_REF_NAME)) {
            return AdvancedPackageImpl.eINSTANCE.getPlaceholder_Ref();
        }
        if (featureName.equals(MENUCONTRIBUTIONS_MENUCONTRIBUTIONS_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getMenuContributions_MenuContributions();
        }
        if (featureName.equals(MENUCONTRIBUTION_POSITIONINPARENT_ATTNAME) || featureName.equals(TOOLBARCONTRIBUTION_POSITIONINPARENT_ATTNAME) || featureName.equals(TRIMCONTRIBUTION_POSITIONINPARENT_ATTNAME)) {
            if (object instanceof MToolBarContribution) {
                return MenuPackageImpl.eINSTANCE.getToolBarContribution_PositionInParent();
            }
            if (object instanceof MTrimContribution) {
                return MenuPackageImpl.eINSTANCE.getTrimContribution_PositionInParent();
            }
            return MenuPackageImpl.eINSTANCE.getMenuContribution_PositionInParent();
        }
        if (featureName.equals(MENUCONTRIBUTION_PARENTID_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getMenuContribution_ParentID();
        }
        if (featureName.equals(TOOLBARCONTRIBUTION_PARENTID_ATTNAME) || featureName.equals(TRIMCONTRIBUTION_PARENTID_ATTNAME)) {
            if (object instanceof MTrimContribution) {
                return MenuPackageImpl.eINSTANCE.getTrimContribution_ParentId();
            }
            return MenuPackageImpl.eINSTANCE.getToolBarContribution_ParentId();
        }
        if (featureName.equals(MENUITEM_MNEMONICS_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getMenuItem_Mnemonics();
        }
        if (featureName.equals(PARAMETER_NAME_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getParameter_Name();
        }
        if (featureName.equals(PARAMETER_VALUE_ATTNAME)) {
            return CommandsPackageImpl.eINSTANCE.getParameter_Value();
        }
        if (featureName.equals(COREEXPRESSION_COREEXPRESSIONID_ATTNAME)) {
            return UiPackageImpl.eINSTANCE.getCoreExpression_CoreExpressionId();
        }
        if (featureName.equals(TOOLBARCONTRIBUTIONS_TOOLBARCONTRIBUTIONS_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getToolBarContributions_ToolBarContributions();
        }
        if (featureName.equals(TRIMCONTRIBUTIONS_TRIMCONTRIBUTIONS_ATTNAME)) {
            return MenuPackageImpl.eINSTANCE.getTrimContributions_TrimContributions();
        }
        if (featureName.equals(PERSPECTIVE_WINDOWS_ATTNAME)) {
            return AdvancedPackageImpl.eINSTANCE.getPerspective_Windows();
        }
        Activator.log(2, "Unknown feature found, reconciliation may fail: " + object.eClass().getName() + '#' + featureName);
        for (EStructuralFeature sf : object.eClass().getEAllStructuralFeatures()) {
            if (!sf.getName().equals(featureName)) continue;
            return sf;
        }
        return null;
    }

    private Object getValue(EStructuralFeature feature, String featureValue) {
        Class instanceClass = feature.getEType().getInstanceClass();
        if (instanceClass == String.class) {
            return featureValue;
        }
        if (instanceClass == Integer.TYPE) {
            return Integer.valueOf(featureValue);
        }
        if (instanceClass == Boolean.TYPE) {
            return Boolean.valueOf(featureValue);
        }
        if (feature == UiPackageImpl.eINSTANCE.getGenericTrimContainer_Side()) {
            return SideValue.getByName((String)featureValue);
        }
        if (feature == MenuPackageImpl.eINSTANCE.getItem_Type()) {
            return ItemType.getByName((String)featureValue);
        }
        return null;
    }

    static Object findReference(List<Object> references, String id) {
        for (Object reference : references) {
            if (!(reference instanceof MApplicationElement) || !XMLModelReconciler.getLocalId(reference).equals(id)) continue;
            return reference;
        }
        return null;
    }

    private boolean constructDeltas(Collection<ModelDelta> deltas, List<Object> references, EObject object, Element element, String id) {
        if ((object instanceof MApplicationElement || object instanceof MKeyBinding) && XMLModelReconciler.getLocalId(object).equals(id)) {
            this.constructDeltas(deltas, references, object, element);
            return true;
        }
        if (object instanceof MElementContainer) {
            for (Object child : ((MElementContainer)object).getChildren()) {
                if (!this.constructDeltas(deltas, references, (EObject)child, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MPerspective) {
            for (MWindow window : ((MPerspective)object).getWindows()) {
                if (!this.constructDeltas(deltas, references, (EObject)window, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MBindingTableContainer) {
            for (MBindingTable bindingTable : ((MBindingTableContainer)object).getBindingTables()) {
                if (!this.constructDeltas(deltas, references, (EObject)bindingTable, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MBindingTable) {
            for (MKeyBinding keyBinding : ((MBindingTable)object).getBindings()) {
                if (!this.constructDeltas(deltas, references, (EObject)keyBinding, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MHandlerContainer) {
            for (MHandler handler : ((MHandlerContainer)object).getHandlers()) {
                if (!this.constructDeltas(deltas, references, (EObject)handler, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MApplication) {
            for (MCommand command : ((MApplication)object).getCommands()) {
                if (!this.constructDeltas(deltas, references, (EObject)command, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MPartDescriptorContainer) {
            for (MPartDescriptor descriptor : ((MPartDescriptorContainer)object).getDescriptors()) {
                if (!this.constructDeltas(deltas, references, (EObject)descriptor, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MPart) {
            MPart part = (MPart)object;
            for (MMenu menu : part.getMenus()) {
                if (!this.constructDeltas(deltas, references, (EObject)menu, element, id)) continue;
                return true;
            }
            MToolBar toolBar = part.getToolbar();
            if (toolBar != null && this.constructDeltas(deltas, references, (EObject)toolBar, element, id)) {
                return true;
            }
        }
        if (object instanceof MMenuContributions) {
            for (MMenuContribution contribution : ((MMenuContributions)object).getMenuContributions()) {
                if (!this.constructDeltas(deltas, references, (EObject)contribution, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MToolBarContributions) {
            for (MMenuContribution contribution : ((MToolBarContributions)object).getToolBarContributions()) {
                if (!this.constructDeltas(deltas, references, (EObject)contribution, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MTrimContributions) {
            for (MMenuContribution contribution : ((MTrimContributions)object).getTrimContributions()) {
                if (!this.constructDeltas(deltas, references, (EObject)contribution, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MWindow) {
            MWindow window;
            window = (MWindow)object;
            if (this.constructDeltas(deltas, references, (EObject)window.getMainMenu(), element, id)) {
                return true;
            }
            if (object instanceof MTrimmedWindow) {
                MTrimmedWindow trimmedWindow = (MTrimmedWindow)object;
                for (MTrimBar trimBar : trimmedWindow.getTrimBars()) {
                    if (!this.constructDeltas(deltas, references, (EObject)trimBar, element, id)) continue;
                    return true;
                }
            }
        }
        if (object instanceof MHandledItem) {
            for (MParameter parameter : ((MHandledItem)object).getParameters()) {
                if (!this.constructDeltas(deltas, references, (EObject)parameter, element, id)) continue;
                return true;
            }
        }
        return false;
    }

    private void constructDeltas(Collection<ModelDelta> deltas, List<Object> references, EObject object, Element element) {
        String elementName = element.getNodeName();
        if (elementName.equals(CONTEXT_PROPERTIES_ATTNAME)) {
            this.constructEntryDelta(deltas, (EStructuralFeature)UiPackageImpl.eINSTANCE.getContext_Properties(), object, element);
        } else if (elementName.equals(CONTRIBUTION_PERSISTEDSTATE_ATTNAME)) {
            this.constructEntryDelta(deltas, (EStructuralFeature)ApplicationPackageImpl.eINSTANCE.getContribution_PersistedState(), object, element);
        } else {
            this.constructObjectDeltas(deltas, references, object, element);
        }
    }

    private void constructEntryDelta(Collection<ModelDelta> deltas, EStructuralFeature feature, EObject object, Element element) {
        if (element.getAttribute(UNSET_ATTNAME).equals(UNSET_ATTVALUE_TRUE)) {
            EMFDeltaEntrySet delta = new EMFDeltaEntrySet(object, feature, element.getAttribute(ENTRY_ATTVALUE_KEY), null);
            deltas.add(delta);
        } else {
            EMFDeltaEntrySet delta = new EMFDeltaEntrySet(object, feature, element.getAttribute(ENTRY_ATTVALUE_KEY), element.getAttribute(ENTRY_ATTVALUE_VALUE));
            deltas.add(delta);
        }
    }

    private void constructObjectDeltas(Collection<ModelDelta> deltas, List<Object> references, EObject object, Element element) {
        NodeList nodeList = (NodeList)((Object)element);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element innerElement;
            String featureName;
            EStructuralFeature feature;
            Node node = nodeList.item(i);
            if (node instanceof Element && (feature = XMLModelReconciler.getStructuralFeature(object, featureName = (innerElement = (Element)node).getNodeName())) != null) {
                ModelDelta delta;
                if (XMLModelReconciler.isChainedReference(featureName)) {
                    delta = this.createMultiReferenceDelta(deltas, references, object, feature, innerElement);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isUnset(innerElement)) {
                    delta = new EMFModelDeltaUnset(object, feature);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isDirectReference(featureName)) {
                    delta = this.createDirectReferenceDelta(deltas, references, object, feature, innerElement);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isIndirectReference(featureName)) {
                    delta = this.createIndirectReferenceDelta(references, object, feature, innerElement);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isUnorderedChainedAttribute(featureName)) {
                    delta = this.createUnorderedChainedAttributeDelta(object, feature, innerElement, featureName);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isStringToStringMap(featureName)) {
                    delta = this.createMapDelta(object, innerElement, feature);
                    deltas.add(delta);
                } else {
                    delta = this.createAttributeDelta(object, feature, innerElement, featureName);
                    deltas.add(delta);
                }
            }
            ++i;
        }
    }

    private ModelDelta createDirectReferenceDelta(Collection<ModelDelta> deltas, List<Object> references, EObject eObject, EStructuralFeature feature, Element node) {
        NodeList referencedIds = (NodeList)((Object)node);
        Element reference = XMLModelReconciler.getFirstElement(referencedIds);
        String referenceId = reference.getAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME);
        Object match = XMLModelReconciler.findReference(references, referenceId);
        if (match == null) {
            match = this.createObject(deltas, reference, references);
        }
        return new EMFModelDeltaSet((Object)eObject, feature, match);
    }

    private static Element getFirstElement(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node item = list.item(i);
            if (item instanceof Element) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    private ModelDelta createIndirectReferenceDelta(List<Object> references, EObject eObject, EStructuralFeature feature, Element node) {
        NodeList referencedIds = (NodeList)((Object)node);
        Element reference = XMLModelReconciler.getFirstElement(referencedIds);
        String referenceId = reference.getAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME);
        Object match = XMLModelReconciler.findReference(references, referenceId);
        if (match == null) {
            return this.createDelayedDelta(eObject, feature, reference);
        }
        return new EMFModelDeltaSet((Object)eObject, feature, match);
    }

    private ModelDelta createMapDelta(EObject object, Element innerElement, EStructuralFeature feature) {
        HashMap<String, String> deltaMap = new HashMap<String, String>();
        NodeList attributes = (NodeList)((Object)innerElement);
        int j = 0;
        while (j < attributes.getLength()) {
            Node entry = attributes.item(j);
            if (entry instanceof Element) {
                Element keyValue = (Element)entry;
                String key = keyValue.getAttribute(ENTRY_ATTVALUE_KEY);
                String value = keyValue.getAttribute(ENTRY_ATTVALUE_VALUE);
                deltaMap.put(key, value);
            }
            ++j;
        }
        return new EMFDeltaMapSet(object, feature, deltaMap);
    }

    private ModelDelta createDelayedDelta(EObject object, EStructuralFeature feature, Element element) {
        String referenceId = element.getAttribute(XMIID_ATTNAME);
        return new EMFModelDeltaDelayedSet(object, feature, this.rootObject, referenceId);
    }

    public static List<?> threeWayMerge(List<?> originalReferences, List<?> userReferences, List<?> currentReferences) {
        int userSize = userReferences.size();
        int originalSize = originalReferences.size();
        if (userSize == 0) {
            ArrayList collectedReferences = new ArrayList(currentReferences);
            collectedReferences.removeAll(originalReferences);
            return collectedReferences;
        }
        if (originalSize == 0) {
            ArrayList collectedReferences = new ArrayList(userReferences);
            collectedReferences.addAll(currentReferences);
            return collectedReferences;
        }
        if (currentReferences.isEmpty()) {
            return userReferences;
        }
        if (currentReferences.size() == originalSize && currentReferences.containsAll(originalReferences)) {
            return userReferences;
        }
        if (originalReferences.containsAll(userReferences) && !userReferences.containsAll(originalReferences)) {
            ArrayList collectedReferences2 = new ArrayList(originalReferences);
            collectedReferences2.removeAll(userReferences);
            ArrayList collectedReferences = new ArrayList(currentReferences);
            collectedReferences.removeAll(collectedReferences2);
            return collectedReferences;
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int i = 0;
        while (i < userReferences.size()) {
            Object user = userReferences.get(i);
            Position p = XMLModelReconciler.getPosition(originalReferences, userReferences, currentReferences, user, i);
            if (p != null) {
                positions.add(p);
            }
            ++i;
        }
        ArrayList collectedRefs = new ArrayList(currentReferences);
        for (Position position : positions) {
            Object before;
            Object after = position.getAfter();
            if (after != null) {
                int index = currentReferences.indexOf(after);
                collectedRefs.add(index + 1, position.getObject());
            }
            if ((before = position.getBefore()) == null) continue;
            int index = currentReferences.indexOf(before);
            collectedRefs.add(index, position.getObject());
        }
        return collectedRefs;
    }

    private static Position getPosition(List<?> originalReferences, List<?> userReferences, List<?> currentReferences, Object object, int originalIndex) {
        int index = originalReferences.indexOf(object);
        if (index == -1) {
            Object after = null;
            int i = originalIndex - 1;
            while (i > -1) {
                Object afterCandidate = userReferences.get(i);
                int afterIndex = currentReferences.indexOf(afterCandidate);
                if (afterIndex != -1) {
                    after = afterCandidate;
                    break;
                }
                --i;
            }
            Object before = null;
            int i2 = originalIndex + 1;
            while (i2 < userReferences.size()) {
                Object beforeCandidate = userReferences.get(i2);
                int beforeIndex = currentReferences.indexOf(beforeCandidate);
                if (beforeIndex != -1) {
                    before = beforeCandidate;
                    break;
                }
                ++i2;
            }
            return new Position(object, after, before);
        }
        return null;
    }

    private ModelDelta createMultiReferenceDelta(Collection<ModelDelta> deltas, List<Object> references, EObject eObject, EStructuralFeature feature, Element node) {
        NodeList referencedIds = (NodeList)((Object)node);
        ArrayList<Object> originalReferences = new ArrayList<Object>();
        ArrayList<Object> userReferences = new ArrayList<Object>();
        List currentReferences = (List)eObject.eGet(feature);
        int i = 0;
        while (i < referencedIds.getLength()) {
            Node item = referencedIds.item(i);
            if (item instanceof Element) {
                Element reference = (Element)item;
                if (XMLModelReconciler.isUnset(reference)) {
                    userReferences.add(this.createObject(deltas, reference, references));
                } else {
                    String referenceId = reference.getAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME);
                    Object match = XMLModelReconciler.findReference(references, referenceId);
                    if (match != null) {
                        if (reference.getNodeName().equals(REFERENCE_ELEMENT_NAME)) {
                            userReferences.add(match);
                        } else {
                            originalReferences.add(match);
                        }
                    }
                }
            }
            ++i;
        }
        return new EMFModelDeltaThreeWayDelayedSet(eObject, feature, originalReferences, userReferences, currentReferences);
    }

    private static EObject createObject(String namespace, String type) {
        EFactory factory = EPackage.Registry.INSTANCE.getEFactory(namespace);
        for (EClassifier classifier : factory.getEPackage().getEClassifiers()) {
            EClass cls;
            if (!(classifier instanceof EClass) || !(cls = (EClass)classifier).getInstanceClassName().equals(type)) continue;
            return factory.create(cls);
        }
        return null;
    }

    private Object getReference(Collection<ModelDelta> deltas, Element element, List<Object> references) {
        String id = element.getAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME);
        if (!id.equals("")) {
            return XMLModelReconciler.findReference(references, id);
        }
        return this.createObject(deltas, element, references);
    }

    private Object createObject(Collection<ModelDelta> deltas, Element element, List<Object> references) {
        String typeName = element.getAttribute(TYPE_ATTNAME);
        String namespace = element.getAttribute(NAMESPACE_ATTNAME);
        EObject object = XMLModelReconciler.createObject(namespace, typeName);
        CompositeDelta compositeDelta = new CompositeDelta(object);
        E4XMIResource resource = (E4XMIResource)this.rootObject.eResource();
        resource.setInternalId(object, element.getAttribute(XMIID_ATTNAME));
        NodeList elementAttributes = (NodeList)((Object)element);
        int i = 0;
        while (i < elementAttributes.getLength()) {
            String attributeName;
            EStructuralFeature attributeFeature;
            Element item;
            Node node = elementAttributes.item(i);
            if (node instanceof Element && !XMLModelReconciler.isUnset(item = (Element)node) && (attributeFeature = XMLModelReconciler.getStructuralFeature(object, attributeName = item.getNodeName())) != null) {
                EMFModelDeltaSet delta;
                Object objectReference;
                String id;
                if (XMLModelReconciler.isDirectReference(attributeName)) {
                    id = item.getAttribute(attributeName);
                    objectReference = XMLModelReconciler.findReference(references, id);
                    if (objectReference == null) {
                        objectReference = this.createObject(deltas, XMLModelReconciler.getFirstElement((NodeList)((Object)item)), references);
                    }
                    delta = new EMFModelDeltaSet((Object)object, attributeFeature, objectReference);
                    compositeDelta.add(delta);
                } else if (XMLModelReconciler.isIndirectReference(attributeName)) {
                    id = item.getAttribute(attributeName);
                    objectReference = XMLModelReconciler.findReference(references, id);
                    if (objectReference == null) {
                        NodeList list = (NodeList)((Object)item);
                        Element refElement = XMLModelReconciler.getFirstElement(list);
                        if (refElement != null) {
                            ModelDelta delta2 = this.createDelayedDelta(object, attributeFeature, refElement);
                            deltas.add(delta2);
                        }
                    } else {
                        delta = new EMFModelDeltaSet((Object)object, attributeFeature, objectReference);
                        compositeDelta.add(delta);
                    }
                } else if (XMLModelReconciler.isChainedReference(attributeName)) {
                    ArrayList<Object> objectReferences = new ArrayList<Object>();
                    NodeList objectReferenceNodes = (NodeList)((Object)item);
                    int j = 0;
                    while (j < objectReferenceNodes.getLength()) {
                        Object objectReference2;
                        Node refNode = objectReferenceNodes.item(j);
                        if (refNode instanceof Element && (objectReference2 = this.getReference(deltas, (Element)refNode, references)) != null) {
                            objectReferences.add(objectReference2);
                        }
                        ++j;
                    }
                    delta = new EMFModelDeltaSet((Object)object, attributeFeature, objectReferences);
                    compositeDelta.add(delta);
                } else if (XMLModelReconciler.isUnorderedChainedAttribute(attributeName)) {
                    ModelDelta delta3 = this.createUnorderedChainedAttributeDelta(object, attributeFeature, item, attributeName);
                    deltas.add(delta3);
                } else if (XMLModelReconciler.isStringToStringMap(attributeName)) {
                    EStructuralFeature feature = XMLModelReconciler.getStructuralFeature(object, attributeName);
                    EMap map = (EMap)object.eGet(feature);
                    NodeList attributes = (NodeList)((Object)item);
                    int j = 0;
                    while (j < attributes.getLength()) {
                        Node entry = attributes.item(j);
                        if (entry instanceof Element) {
                            Element keyValue = (Element)entry;
                            map.put((Object)keyValue.getAttribute(ENTRY_ATTVALUE_KEY), (Object)keyValue.getAttribute(ENTRY_ATTVALUE_VALUE));
                        }
                        ++j;
                    }
                } else {
                    object.eSet(attributeFeature, this.getValue(attributeFeature, item.getAttribute(attributeName)));
                }
            }
            ++i;
        }
        return compositeDelta;
    }

    private ModelDelta createUnorderedChainedAttributeDelta(EObject object, EStructuralFeature feature, Element node, String featureName) {
        HashSet<Object> values = new HashSet<Object>();
        NodeList attributes = (NodeList)((Object)node);
        int j = 0;
        while (j < attributes.getLength()) {
            Node item = attributes.item(j);
            if (item instanceof Element) {
                Element attribute = (Element)item;
                Object value = this.getValue(feature, attribute.getAttribute(featureName));
                values.add(value);
            }
            ++j;
        }
        List currentValues = (List)object.eGet(feature);
        values.addAll(currentValues);
        return new EMFModelDeltaSet((Object)object, feature, new ArrayList(values));
    }

    private ModelDelta createAttributeDelta(EObject eObject, EStructuralFeature feature, Element node, String featureName) {
        Object value = this.getValue(feature, node.getAttribute(featureName));
        return new EMFModelDeltaSet((Object)eObject, feature, value);
    }

    private Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ChangeDescription calculateDeltas() {
        if (this.changeDescription == null) {
            this.changeDescription = this.changeRecorder.endRecording();
        }
        return this.changeDescription;
    }

    @Override
    public Object serialize() {
        this.calculateDeltas();
        Document document = this.createDocument();
        Element root = document.createElement(CHANGES_ATTNAME);
        document.appendChild(root);
        EMap objectChanges = this.changeDescription.getObjectChanges();
        for (Map.Entry entry : objectChanges.entrySet()) {
            EObject object;
            Element persistedElement = this.persist(document, entry, object = (EObject)entry.getKey());
            if (persistedElement == null) continue;
            root.appendChild(persistedElement);
        }
        return document;
    }

    private Element persist(Document document, Map.Entry<EObject, EList<FeatureChange>> entry, EObject object) {
        if (object instanceof Map.Entry) {
            return this.persistEntry(document, object);
        }
        return this.persistObject(document, entry, object);
    }

    private Element persistObject(Document document, Map.Entry<EObject, EList<FeatureChange>> entry, EObject object) {
        if (this.getOriginalId(object) == null) {
            return null;
        }
        Element modelChange = null;
        List featureChanges = (List)entry.getValue();
        for (FeatureChange featureChange : featureChanges) {
            String featureName;
            if (featureChange.getFeature().isTransient() || !XMLModelReconciler.shouldPersist(featureName = featureChange.getFeatureName())) continue;
            if (modelChange == null) {
                modelChange = this.createElement(document, object);
            }
            Element deltaElement = this.createDeltaElement(document, object, featureChange, featureName);
            modelChange.appendChild(deltaElement);
        }
        return modelChange;
    }

    private String getEntryElementName(EObject object, Map.Entry<?, ?> entry) {
        if (object instanceof MContext) {
            for (Map.Entry property : ((MContext)object).getProperties().entrySet()) {
                if (property != entry) continue;
                return CONTEXT_PROPERTIES_ATTNAME;
            }
        }
        if (object instanceof MContribution) {
            for (Map.Entry state : ((MContribution)object).getPersistedState().entrySet()) {
                if (state != entry) continue;
                return CONTRIBUTION_PERSISTEDSTATE_ATTNAME;
            }
        }
        return null;
    }

    private Element persistEntry(Document document, EObject object) {
        EObject container = object.eContainer();
        if (this.getOriginalId(container) == null) {
            return null;
        }
        Map.Entry entry = (Map.Entry)object;
        String elementName = this.getEntryElementName(container, entry);
        if (elementName == null) {
            return null;
        }
        Element element = this.createElement(document, elementName, container);
        element.setAttribute(ENTRY_ATTVALUE_KEY, (String)entry.getKey());
        String value = (String)entry.getValue();
        if (value == null) {
            element.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        } else {
            element.setAttribute(ENTRY_ATTVALUE_VALUE, (String)entry.getValue());
        }
        return element;
    }

    private Element createElement(Document document, EObject object) {
        Class<?> rootInterface = object.getClass().getInterfaces()[0];
        return this.createElement(document, rootInterface.getCanonicalName(), object);
    }

    private Element createElement(Document document, String elementName, EObject object) {
        Element modelChange = document.createElement(elementName);
        modelChange.setAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME, this.getOriginalId(object));
        return modelChange;
    }

    private static String getResourceId(EObject object, EObject container) {
        Resource resource = object.eResource();
        if (resource instanceof XMLResource) {
            return ((XMLResource)resource).getID(object);
        }
        resource = container.eResource();
        if (resource instanceof XMLResource) {
            return ((XMLResource)resource).getID(object);
        }
        throw new IllegalStateException(object + " could not be identified");
    }

    private static String getLocalId(Object object) {
        EObject reference = (EObject)object;
        return XMLModelReconciler.getResourceId(reference, reference.eContainer());
    }

    private EObject getOriginalContainer(EObject reference) {
        boolean toolBarContributionsChanged;
        List commands;
        EObject key;
        EMap objectChanges;
        if (this.changeDescription == null) {
            return reference.eContainer();
        }
        if (reference instanceof MCommandParameter) {
            EMap objectChanges2 = this.changeDescription.getObjectChanges();
            boolean parametersChanged = false;
            block0: for (Map.Entry entry : objectChanges2.entrySet()) {
                EObject key2 = (EObject)entry.getKey();
                if (!(key2 instanceof MCommand)) continue;
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(COMMAND_PARAMETERS_ATTNAME)) continue;
                    List parameters = (List)change.getValue();
                    for (Object parameter : parameters) {
                        if (parameter != reference) continue;
                        return key2;
                    }
                    parametersChanged = true;
                    break block0;
                }
            }
            return parametersChanged ? null : reference.eContainer();
        }
        if (reference instanceof MParameter) {
            EMap objectChanges3 = this.changeDescription.getObjectChanges();
            boolean parametersChanged = false;
            block3: for (Map.Entry entry : objectChanges3.entrySet()) {
                EObject key3 = (EObject)entry.getKey();
                if (!(key3 instanceof MHandledItem)) continue;
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(HANDLEDITEM_PARAMETERS_ATTNAME)) continue;
                    List parameters = (List)change.getValue();
                    for (Object parameter : parameters) {
                        if (parameter != reference) continue;
                        return key3;
                    }
                    parametersChanged = true;
                    break block3;
                }
            }
            return parametersChanged ? null : reference.eContainer();
        }
        if (reference instanceof MCommand) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean commandsChanged = false;
            block6: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(APPLICATION_COMMANDS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    commandsChanged = true;
                    break block6;
                }
            }
            if (!commandsChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MMenuContribution) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean menuContributionsChanged = false;
            block9: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(MENUCONTRIBUTIONS_MENUCONTRIBUTIONS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    menuContributionsChanged = true;
                    break block9;
                }
            }
            return menuContributionsChanged ? null : reference.eContainer();
        }
        if (reference instanceof MToolBarContribution) {
            objectChanges = this.changeDescription.getObjectChanges();
            toolBarContributionsChanged = false;
            block12: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(TOOLBARCONTRIBUTIONS_TOOLBARCONTRIBUTIONS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    toolBarContributionsChanged = true;
                    break block12;
                }
            }
            return toolBarContributionsChanged ? null : reference.eContainer();
        }
        if (reference instanceof MTrimContribution) {
            objectChanges = this.changeDescription.getObjectChanges();
            toolBarContributionsChanged = false;
            block15: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(TRIMCONTRIBUTIONS_TRIMCONTRIBUTIONS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    toolBarContributionsChanged = true;
                    break block15;
                }
            }
            return toolBarContributionsChanged ? null : reference.eContainer();
        }
        if (reference instanceof MBindingTable) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean bindingTablesChanged = false;
            block18: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(BINDINGCONTAINER_BINDINGTABLES_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    bindingTablesChanged = true;
                    break block18;
                }
            }
            if (!bindingTablesChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MHandler) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean handlersChanged = false;
            block21: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (!(key instanceof MHandlerContainer)) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(HANDLERCONTAINER_HANDLERS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    handlersChanged = true;
                    continue block21;
                }
            }
            if (!handlersChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MKeyBinding) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean bindingsChanged = false;
            block24: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (!(key instanceof MBindingTable)) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(BINDINGTABLES_BINDINGS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    bindingsChanged = true;
                    continue block24;
                }
            }
            if (!bindingsChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MPartDescriptor) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean descriptorsChanged = false;
            block27: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(PARTDESCRIPTORCONTAINER_DESCRIPTORS_ATTNAME)) continue;
                    List descriptors = (List)change.getValue();
                    for (Object descriptor : descriptors) {
                        if (descriptor != reference) continue;
                        return key;
                    }
                    descriptorsChanged = true;
                    break block27;
                }
            }
            return descriptorsChanged ? null : reference.eContainer();
        }
        if (reference instanceof MTrimBar) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean trimBarsChanged = false;
            block30: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (!(key instanceof MTrimmedWindow)) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(TRIMMEDWINDOW_TRIMBARS_ATTNAME)) continue;
                    List trimBars = (List)change.getValue();
                    for (Object trimBar : trimBars) {
                        if (trimBar != reference) continue;
                        return key;
                    }
                    trimBarsChanged = true;
                    break block30;
                }
            }
            if (trimBarsChanged) {
                return null;
            }
            for (EObject rootChild : this.rootObject.eContents()) {
                if (!(rootChild instanceof MTrimmedWindow) || !((MTrimmedWindow)rootChild).getTrimBars().contains(reference)) continue;
                return rootChild;
            }
            return null;
        }
        if (reference instanceof MUIElement) {
            EList value;
            objectChanges = this.changeDescription.getObjectChanges();
            for (Map.Entry entry : objectChanges.entrySet()) {
                EObject key4 = (EObject)entry.getKey();
                if (key4 != reference) continue;
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(UIELEMENT_PARENT_ATTNAME)) continue;
                    return (EObject)change.getValue();
                }
            }
            if (reference instanceof MMenu) {
                boolean appendedMenu = false;
                block36: for (Map.Entry entry : objectChanges.entrySet()) {
                    key = (EObject)entry.getKey();
                    if (!(key instanceof MPart)) continue;
                    for (Object change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(PART_MENUS_ATTNAME)) continue;
                        List originalMenus = (List)change.getValue();
                        if (originalMenus.contains(reference)) {
                            return key;
                        }
                        if (!((MPart)key).getMenus().contains(reference)) continue block36;
                        appendedMenu = true;
                        continue block36;
                    }
                }
                boolean menuSet = false;
                boolean menuChanged = false;
                block38: for (Map.Entry entry : objectChanges.entrySet()) {
                    EObject key5 = (EObject)entry.getKey();
                    if (!(key5 instanceof MWindow)) continue;
                    for (FeatureChange change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(WINDOW_MAINMENU_ATTNAME)) continue;
                        Object oldMenu = change.getValue();
                        if (oldMenu == reference) {
                            return key5;
                        }
                        if (oldMenu == null && ((MWindow)key5).getMainMenu() == reference) {
                            menuSet = true;
                        }
                        menuChanged = true;
                        continue block38;
                    }
                }
                if (menuChanged && menuSet) {
                    return null;
                }
                if (appendedMenu && !menuSet && !menuChanged) {
                    return null;
                }
                EObject container = reference.eContainer();
                if (!(container instanceof MMenu)) {
                    return container;
                }
            }
            if (reference instanceof MToolBar) {
                for (Map.Entry entry : objectChanges.entrySet()) {
                    EObject key6 = (EObject)entry.getKey();
                    if (!(key6 instanceof MPart)) continue;
                    for (FeatureChange change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(PART_TOOLBAR_ATTNAME) || change.getValue() != reference) continue;
                        return key6;
                    }
                }
            }
            boolean newElement = false;
            block42: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key == reference.eContainer()) {
                    for (Object change : (EList)entry.getValue()) {
                        if (change.getFeatureName().equals(ELEMENTCONTAINER_CHILDREN_ATTNAME)) {
                            value = (EList)change.getValue();
                            if (value.contains((Object)reference)) {
                                return key;
                            }
                            newElement = true;
                            break block42;
                        }
                        if (change.getFeatureName().equals(PART_TOOLBAR_ATTNAME)) {
                            if (reference.equals(change.getValue())) {
                                return key;
                            }
                            newElement = true;
                            break block42;
                        }
                        if (change.getFeatureName().equals(WINDOW_SHAREDELEMENTS_ATTNAME)) {
                            value = (EList)change.getValue();
                            if (value.contains((Object)reference)) {
                                return key;
                            }
                            newElement = true;
                            break block42;
                        }
                        if (!change.getFeatureName().equals(PERSPECTIVE_WINDOWS_ATTNAME)) continue;
                        value = (EList)change.getValue();
                        if (value.contains((Object)reference)) {
                            return key;
                        }
                        newElement = true;
                        break block42;
                    }
                    break;
                }
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(WINDOW_SHAREDELEMENTS_ATTNAME) || !(value = (EList)change.getValue()).contains((Object)reference)) continue;
                    return key;
                }
            }
            if (reference instanceof MWindow) {
                block45: for (Map.Entry entry : objectChanges.entrySet()) {
                    key = (EObject)entry.getKey();
                    if (!(key instanceof MPerspective)) continue;
                    for (Object change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(PERSPECTIVE_WINDOWS_ATTNAME)) continue;
                        value = (EList)change.getValue();
                        if (!value.contains((Object)reference)) continue block45;
                        return key;
                    }
                }
            }
            if (!newElement) {
                return reference instanceof MApplication ? this.changeDescription : reference.eContainer();
            }
        }
        return null;
    }

    private String getOriginalId(Object object) {
        EObject reference = (EObject)object;
        EObject originalContainer = this.getOriginalContainer(reference);
        if (originalContainer == null) {
            return null;
        }
        if (originalContainer != this.changeDescription) {
            EObject container = originalContainer;
            while (container != this.rootObject) {
                if ((container = this.getOriginalContainer(container)) != null) continue;
                return null;
            }
        }
        return XMLModelReconciler.getResourceId(reference, originalContainer);
    }

    private Element createDeltaElement(Document document, EObject object, FeatureChange featureChange, String featureName) {
        EStructuralFeature feature = featureChange.getFeature();
        if (object.eIsSet(feature)) {
            return this.createSetDeltaElement(document, object, featureChange, featureName, feature);
        }
        return this.createUnsetDeltaElement(document, featureChange, featureName);
    }

    private Element createSetDeltaElement(Document document, EObject object, FeatureChange featureChange, String featureName, EStructuralFeature feature) {
        Element featureElement = document.createElement(featureName);
        Object value = object.eGet(feature);
        if (XMLModelReconciler.isSingleReference(featureName)) {
            Element referenceElement = this.createReferenceElement(document, (EObject)value, featureName);
            featureElement.appendChild(referenceElement);
        } else if (XMLModelReconciler.isChainedReference(featureName)) {
            this.appendReferenceElements(document, featureElement, (List)value);
            this.appendOriginalReferenceElements(document, featureElement, (List)featureChange.getValue());
        } else if (XMLModelReconciler.isUnorderedChainedAttribute(featureName)) {
            List attributes = (List)value;
            for (Object attribute : attributes) {
                Element attributeElement = document.createElement(featureName);
                attributeElement.setAttribute(featureName, String.valueOf(attribute));
                featureElement.appendChild(attributeElement);
            }
        } else if (XMLModelReconciler.isStringToStringMap(featureName)) {
            EMap map = (EMap)object.eGet(feature);
            for (Map.Entry entry : map.entrySet()) {
                Element entryElement = document.createElement(featureName);
                entryElement.setAttribute(ENTRY_ATTVALUE_KEY, (String)entry.getKey());
                entryElement.setAttribute(ENTRY_ATTVALUE_VALUE, (String)entry.getValue());
                featureElement.appendChild(entryElement);
            }
        } else {
            featureElement.setAttribute(featureName, String.valueOf(value));
        }
        return featureElement;
    }

    private Element createUnsetDeltaElement(Document document, FeatureChange featureChange, String featureName) {
        Element featureElement = document.createElement(featureName);
        if (XMLModelReconciler.isChainedReference(featureName)) {
            this.appendOriginalReferenceElements(document, featureElement, (List)featureChange.getValue());
        } else {
            featureElement.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        }
        return featureElement;
    }

    private Element createOriginalReferenceElement(Document document, Object reference) {
        Element referenceElement = document.createElement(ORIGINALREFERENCE_ELEMENT_NAME);
        referenceElement.setAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME, this.getOriginalId(reference));
        return referenceElement;
    }

    private void appendOriginalReferenceElements(Document document, Element element, List<?> references) {
        for (Object reference : references) {
            Element referenceElement = this.createOriginalReferenceElement(document, reference);
            element.appendChild(referenceElement);
        }
    }

    private Element createReferenceElement(Document document, EObject eObject, String featureName) {
        String id = this.getOriginalId(eObject);
        if (id == null) {
            if (featureName == null || XMLModelReconciler.isDirectReference(featureName)) {
                return this.createNewReferenceElement(document, eObject);
            }
            return this.createUniqueReferenceElement(document, eObject);
        }
        Element referenceElement = document.createElement(REFERENCE_ELEMENT_NAME);
        referenceElement.setAttribute(APPLICATIONELEMENT_ELEMENTID_ATTNAME, id);
        return referenceElement;
    }

    private void appendReferenceElements(Document document, Element element, List<?> references) {
        for (Object reference : references) {
            Element ef = this.createReferenceElement(document, (EObject)reference, null);
            element.appendChild(ef);
        }
    }

    private Element createNewReferenceElement(Document document, EObject eObject) {
        Element referenceElement = this.createUniqueReferenceElement(document, eObject);
        referenceElement.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        referenceElement.setAttribute(TYPE_ATTNAME, eObject.getClass().getInterfaces()[0].getCanonicalName());
        for (EStructuralFeature collectedFeature : XMLModelReconciler.collectFeatures(eObject)) {
            String featureName = collectedFeature.getName();
            if (collectedFeature.isTransient() || !XMLModelReconciler.shouldPersist(featureName)) continue;
            Element referenceAttributeElement = this.createAttributeElement(document, eObject, collectedFeature, featureName);
            referenceElement.appendChild(referenceAttributeElement);
        }
        return referenceElement;
    }

    private Element createUniqueReferenceElement(Document document, EObject eObject) {
        EClass cls = eObject.eClass();
        EPackage pkg = (EPackage)cls.eContainer();
        Element referenceElement = document.createElement(REFERENCE_ELEMENT_NAME);
        E4XMIResource resource = (E4XMIResource)this.rootObject.eResource();
        String internalId = resource.getInternalId(eObject);
        referenceElement.setAttribute(XMIID_ATTNAME, internalId);
        referenceElement.setAttribute(NAMESPACE_ATTNAME, pkg.getNsURI());
        return referenceElement;
    }

    private Element createAttributeElement(Document document, EObject object, EStructuralFeature feature, String featureName) {
        Element referenceAttributeElement = document.createElement(featureName);
        if (object.eIsSet(feature)) {
            if (XMLModelReconciler.isSingleReference(featureName)) {
                Object value = object.eGet(feature);
                String id = this.getOriginalId(value);
                if (id == null) {
                    Element referenceElement = this.createReferenceElement(document, (EObject)value, featureName);
                    referenceAttributeElement.appendChild(referenceElement);
                } else {
                    referenceAttributeElement.setAttribute(featureName, id);
                }
            } else if (XMLModelReconciler.isChainedReference(featureName)) {
                List references = (List)object.eGet(feature);
                this.appendReferenceElements(document, referenceAttributeElement, references);
            } else if (XMLModelReconciler.isUnorderedChainedAttribute(featureName)) {
                List attributes = (List)object.eGet(feature);
                for (Object attribute : attributes) {
                    Element attributeElement = document.createElement(featureName);
                    attributeElement.setAttribute(featureName, String.valueOf(attribute));
                    referenceAttributeElement.appendChild(attributeElement);
                }
            } else if (XMLModelReconciler.isStringToStringMap(featureName)) {
                EMap map = (EMap)object.eGet(feature);
                for (Map.Entry entry : map.entrySet()) {
                    Element entryElement = document.createElement(featureName);
                    entryElement.setAttribute(ENTRY_ATTVALUE_KEY, (String)entry.getKey());
                    entryElement.setAttribute(ENTRY_ATTVALUE_VALUE, (String)entry.getValue());
                    referenceAttributeElement.appendChild(entryElement);
                }
            } else {
                referenceAttributeElement.setAttribute(featureName, String.valueOf(object.eGet(feature)));
            }
        } else {
            referenceAttributeElement.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        }
        return referenceAttributeElement;
    }

    private static boolean isStringToStringMap(String featureName) {
        return featureName.equals(CONTRIBUTION_PERSISTEDSTATE_ATTNAME) || featureName.equals(CONTEXT_PROPERTIES_ATTNAME);
    }

    private static boolean isDirectReference(String featureName) {
        return featureName.equals(WINDOW_MAINMENU_ATTNAME) || featureName.equals(PART_TOOLBAR_ATTNAME) || featureName.equals(UIELEMENT_VISIBLEWHEN_ATTNAME);
    }

    private static boolean isIndirectReference(String featureName) {
        return featureName.equals(ELEMENTCONTAINER_SELECTEDELEMENT_ATTNAME) || featureName.equals(HANDLER_COMMAND_ATTNAME) || featureName.equals(KEYBINDING_COMMAND_ATTNAME) || featureName.equals(PLACEHOLDER_REF_NAME);
    }

    private static boolean isSingleReference(String featureName) {
        return XMLModelReconciler.isDirectReference(featureName) || XMLModelReconciler.isIndirectReference(featureName);
    }

    private static boolean isChainedReference(String featureName) {
        return featureName.equals(ELEMENTCONTAINER_CHILDREN_ATTNAME) || featureName.equals(BINDINGTABLES_BINDINGS_ATTNAME) || featureName.equals(PART_MENUS_ATTNAME) || featureName.equals(APPLICATION_COMMANDS_ATTNAME) || featureName.equals(HANDLERCONTAINER_HANDLERS_ATTNAME) || featureName.equals(BINDINGCONTAINER_BINDINGTABLES_ATTNAME) || featureName.equals(TRIMMEDWINDOW_TRIMBARS_ATTNAME) || featureName.equals(WINDOW_SHAREDELEMENTS_ATTNAME) || featureName.equals(MENUCONTRIBUTIONS_MENUCONTRIBUTIONS_ATTNAME) || featureName.equals(COMMAND_PARAMETERS_ATTNAME) || featureName.equals(HANDLEDITEM_PARAMETERS_ATTNAME) || featureName.equals(TOOLBARCONTRIBUTIONS_TOOLBARCONTRIBUTIONS_ATTNAME) || featureName.equals(TRIMCONTRIBUTIONS_TRIMCONTRIBUTIONS_ATTNAME) || featureName.equals(PERSPECTIVE_WINDOWS_ATTNAME);
    }

    private static boolean isUnorderedChainedAttribute(String featureName) {
        return featureName.equals(APPLICATIONELEMENT_TAGS_ATTNAME);
    }

    private static boolean shouldPersist(String featureName) {
        return !featureName.equals(UIELEMENT_PARENT_ATTNAME) && !featureName.equals(PARTDESCRIPTORCONTAINER_DESCRIPTORS_ATTNAME);
    }

    private static Collection<EStructuralFeature> collectFeatures(Collection<EStructuralFeature> features, EClass eClass) {
        features.addAll((Collection<EStructuralFeature>)eClass.getEStructuralFeatures());
        for (EClass superType : eClass.getESuperTypes()) {
            XMLModelReconciler.collectFeatures(features, superType);
        }
        return features;
    }

    private static Collection<EStructuralFeature> collectFeatures(EObject object) {
        return XMLModelReconciler.collectFeatures(new HashSet<EStructuralFeature>(), object.eClass());
    }

    private static boolean isUnset(Element element) {
        return UNSET_ATTVALUE_TRUE.equals(element.getAttribute(UNSET_ATTNAME));
    }

    static class Position {
        private final Object object;
        private final Object after;
        private final Object before;

        Position(Object object, Object after, Object before) {
            this.object = object;
            this.after = after;
            this.before = before;
        }

        public Object getObject() {
            return this.object;
        }

        public Object getBefore() {
            return this.before;
        }

        public Object getAfter() {
            return this.after;
        }
    }
}

