/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.osgi;

import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ContextsActivator
implements BundleActivator {
    private static ContextsActivator defaultInstance;
    private BundleContext bundleContext;
    private ServiceTracker debugTracker = null;

    public ContextsActivator() {
        defaultInstance = this;
    }

    public static ContextsActivator getDefault() {
        return defaultInstance;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        this.bundleContext = null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public static boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        DebugOptions options;
        BundleContext myBundleContext = ContextsActivator.getDefault().bundleContext;
        if (myBundleContext == null) {
            return defaultValue;
        }
        if (ContextsActivator.getDefault().debugTracker == null) {
            ContextsActivator.getDefault().debugTracker = new ServiceTracker(ContextsActivator.getDefault().bundleContext, DebugOptions.class.getName(), null);
            ContextsActivator.getDefault().debugTracker.open();
        }
        if ((options = (DebugOptions)ContextsActivator.getDefault().debugTracker.getService()) != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }
}

