/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.reflect.Field;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;

public class FieldRequestor
extends Requestor {
    private final Field field;

    public FieldRequestor(Field field, IInjector injector, PrimaryObjectSupplier primarySupplier, Object requestingObject, boolean track) {
        super(field, injector, primarySupplier, requestingObject, track);
        this.field = field;
    }

    public Object execute() throws InjectionException {
        this.setField(this.field, this.actualArgs[0]);
        return null;
    }

    public IObjectDescriptor[] getDependentObjects() {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor(this.field.getGenericType(), this.field.getAnnotations());
        return new IObjectDescriptor[]{objectDescriptor};
    }

    private boolean setField(Field field, Object value) throws InjectionException {
        Object userObject = this.getRequestingObject();
        if (userObject == null) {
            return false;
        }
        boolean wasAccessible = true;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                field.set(userObject, value);
            }
            catch (IllegalArgumentException e) {
                throw new InjectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new InjectionException(e);
            }
        }
        finally {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        Object object = this.getRequestingObject();
        if (object != null) {
            tmp.append(object.getClass().getSimpleName());
        }
        tmp.append('.');
        tmp.append(this.field.getName());
        return tmp.toString();
    }
}

