/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateScheduler;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatesPopup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class AutomaticUpdatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enabledCheck;
    private Button onStartupRadio;
    private Button onScheduleRadio;
    private Combo dayCombo;
    private Label atLabel;
    private Combo hourCombo;
    private Button searchOnlyRadio;
    private Button searchAndDownloadRadio;
    private Button remindOnceRadio;
    private Button remindScheduleRadio;
    private Combo remindElapseCombo;
    private Group updateScheduleGroup;
    private Group downloadGroup;
    private Group remindGroup;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.equinox.p2.ui.sdk.scheduler.automatic_updates_preference_page_context");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.enabledCheck = new Button(container, 32);
        this.enabledCheck.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_findUpdates);
        this.createSpacer(container, 1);
        this.updateScheduleGroup = new Group(container, 0);
        this.updateScheduleGroup.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_UpdateSchedule);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.updateScheduleGroup.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.updateScheduleGroup.setLayoutData((Object)gd);
        this.onStartupRadio = new Button((Composite)this.updateScheduleGroup, 16);
        IProduct product = Platform.getProduct();
        String productName = product != null && product.getName() != null ? product.getName() : AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_GenericProductName;
        this.onStartupRadio.setText(NLS.bind((String)AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_findOnStart, (Object)productName));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.onStartupRadio.setLayoutData((Object)gd);
        this.onStartupRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.onScheduleRadio = new Button((Composite)this.updateScheduleGroup, 16);
        this.onScheduleRadio.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_findOnSchedule);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.onScheduleRadio.setLayoutData((Object)gd);
        this.onScheduleRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.dayCombo = new Combo((Composite)this.updateScheduleGroup, 8);
        this.dayCombo.setItems(AutomaticUpdateScheduler.DAYS);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalIndent = 30;
        this.dayCombo.setLayoutData((Object)gd);
        this.atLabel = new Label((Composite)this.updateScheduleGroup, 0);
        this.atLabel.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_at);
        this.hourCombo = new Combo((Composite)this.updateScheduleGroup, 8);
        this.hourCombo.setItems(AutomaticUpdateScheduler.HOURS);
        gd = new GridData();
        this.hourCombo.setLayoutData((Object)gd);
        this.createSpacer(container, 1);
        this.downloadGroup = new Group(container, 0);
        this.downloadGroup.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_downloadOptions);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.downloadGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.downloadGroup.setLayoutData((Object)gd);
        this.searchOnlyRadio = new Button((Composite)this.downloadGroup, 16);
        this.searchOnlyRadio.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_searchAndNotify);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchOnlyRadio.setLayoutData((Object)gd);
        this.searchOnlyRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.searchAndDownloadRadio = new Button((Composite)this.downloadGroup, 16);
        this.searchAndDownloadRadio.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_downloadAndNotify);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchAndDownloadRadio.setLayoutData((Object)gd);
        this.searchAndDownloadRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.createSpacer(container, 1);
        this.remindGroup = new Group(container, 0);
        this.remindGroup.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_RemindGroup);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.remindGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.remindGroup.setLayoutData((Object)gd);
        this.remindOnceRadio = new Button((Composite)this.remindGroup, 16);
        this.remindOnceRadio.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_RemindOnce);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.remindOnceRadio.setLayoutData((Object)gd);
        this.remindOnceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.remindScheduleRadio = new Button((Composite)this.remindGroup, 16);
        this.remindScheduleRadio.setText(AutomaticUpdateMessages.AutomaticUpdatesPreferencePage_RemindSchedule);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.remindScheduleRadio.setLayoutData((Object)gd);
        this.remindScheduleRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        this.remindElapseCombo = new Combo((Composite)this.remindGroup, 8);
        this.remindElapseCombo.setItems(AutomaticUpdatesPopup.ELAPSED);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalIndent = 30;
        this.remindElapseCombo.setLayoutData((Object)gd);
        this.initialize();
        this.enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        });
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void initialize() {
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        this.enabledCheck.setSelection(pref.getBoolean("enabled"));
        this.setSchedule(pref.getString("schedule"));
        this.dayCombo.setText(AutomaticUpdateScheduler.DAYS[this.getDay(pref, false)]);
        this.hourCombo.setText(AutomaticUpdateScheduler.HOURS[this.getHour(pref, false)]);
        this.remindScheduleRadio.setSelection(pref.getBoolean("remindOnSchedule"));
        this.remindOnceRadio.setSelection(!pref.getBoolean("remindOnSchedule"));
        this.remindElapseCombo.setText(pref.getString("remindElapsedTime"));
        this.searchOnlyRadio.setSelection(!pref.getBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getBoolean("download"));
        this.pageChanged();
    }

    private void setSchedule(String value) {
        if (value.equals("on-startup")) {
            this.onStartupRadio.setSelection(true);
        } else {
            this.onScheduleRadio.setSelection(true);
        }
    }

    void pageChanged() {
        boolean master = this.enabledCheck.getSelection();
        this.updateScheduleGroup.setEnabled(master);
        this.onStartupRadio.setEnabled(master);
        this.onScheduleRadio.setEnabled(master);
        this.dayCombo.setEnabled(master && this.onScheduleRadio.getSelection());
        this.atLabel.setEnabled(master && this.onScheduleRadio.getSelection());
        this.hourCombo.setEnabled(master && this.onScheduleRadio.getSelection());
        this.downloadGroup.setEnabled(master);
        this.searchOnlyRadio.setEnabled(master);
        this.searchAndDownloadRadio.setEnabled(master);
        this.remindGroup.setEnabled(master);
        this.remindScheduleRadio.setEnabled(master);
        this.remindOnceRadio.setEnabled(master);
        this.remindElapseCombo.setEnabled(master && this.remindScheduleRadio.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        this.enabledCheck.setSelection(pref.getDefaultBoolean("enabled"));
        this.setSchedule(pref.getDefaultString("schedule"));
        this.onScheduleRadio.setSelection(pref.getDefaultBoolean("schedule"));
        this.dayCombo.setText(AutomaticUpdateScheduler.DAYS[this.getDay(pref, true)]);
        this.hourCombo.setText(AutomaticUpdateScheduler.HOURS[this.getHour(pref, true)]);
        this.remindOnceRadio.setSelection(!pref.getDefaultBoolean("remindOnSchedule"));
        this.remindScheduleRadio.setSelection(pref.getDefaultBoolean("remindOnSchedule"));
        this.remindElapseCombo.setText(pref.getDefaultString("remindElapsedTime"));
        this.searchOnlyRadio.setSelection(!pref.getDefaultBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getDefaultBoolean("download"));
        this.pageChanged();
    }

    public boolean performOk() {
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        pref.setValue("enabled", this.enabledCheck.getSelection());
        if (this.onStartupRadio.getSelection()) {
            pref.setValue("schedule", "on-startup");
        } else {
            pref.setValue("schedule", "on-schedule");
        }
        if (this.remindScheduleRadio.getSelection()) {
            pref.setValue("remindOnSchedule", true);
            pref.setValue("remindElapsedTime", this.remindElapseCombo.getText());
        } else {
            pref.setValue("remindOnSchedule", false);
        }
        pref.setValue("day", this.dayCombo.getText());
        pref.setValue("hour", this.hourCombo.getText());
        pref.setValue("download", this.searchAndDownloadRadio.getSelection());
        AutomaticUpdatePlugin.getDefault().savePreferences();
        AutomaticUpdatePlugin.getDefault().getScheduler().rescheduleUpdate();
        return true;
    }

    private int getDay(IPreferenceStore pref, boolean useDefault) {
        String day = useDefault ? pref.getDefaultString("day") : pref.getString("day");
        int i = 0;
        while (i < AutomaticUpdateScheduler.DAYS.length) {
            if (AutomaticUpdateScheduler.DAYS[i].equals(day)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int getHour(IPreferenceStore pref, boolean useDefault) {
        String hour = useDefault ? pref.getDefaultString("hour") : pref.getString("hour");
        int i = 0;
        while (i < AutomaticUpdateScheduler.HOURS.length) {
            if (AutomaticUpdateScheduler.HOURS[i].equals(hour)) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

