/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.search.HTMLConvertor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseMetadata;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UseReportConverter
extends HTMLConvertor {
    static Comparator compare = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            if (o1 instanceof Type && o2 instanceof Type) {
                return this.compare(((Type)o1).desc, ((Type)o2).desc);
            }
            if (o1 instanceof IReferenceTypeDescriptor && o2 instanceof IReferenceTypeDescriptor) {
                return ((IReferenceTypeDescriptor)o1).getQualifiedName().compareTo(((IReferenceTypeDescriptor)o2).getQualifiedName());
            }
            if (o1 instanceof IMethodDescriptor && o2 instanceof IMethodDescriptor) {
                try {
                    return Signatures.getQualifiedMethodSignature((IMethodDescriptor)o1).compareTo(Signatures.getQualifiedMethodSignature((IMethodDescriptor)o2));
                }
                catch (CoreException coreException) {
                    return -1;
                }
            }
            if (o1 instanceof IFieldDescriptor && o2 instanceof IFieldDescriptor) {
                try {
                    return Signatures.getQualifiedFieldSignature((IFieldDescriptor)o1).compareTo(Signatures.getQualifiedFieldSignature((IFieldDescriptor)o2));
                }
                catch (CoreException coreException) {
                    return -1;
                }
            }
            if (o1 instanceof IComponentDescriptor && o2 instanceof IComponentDescriptor) {
                return ((IComponentDescriptor)o1).getId().compareTo(((IComponentDescriptor)o2).getId());
            }
            return -1;
        }
    };
    public static final int FRAGMENT_PERMISSIBLE = 5;
    public static final String DEFAULT_XSLT = "/references.xsl";
    public static final String NORMAL_REFS_COLOUR = "#FFFFFF";
    public static final String INTERNAL_REFS_COLOUR = "#F2C3C3";
    public static final String ILLEGAL_REFS_COLOUR = "#E0E0E0";
    public static final String REFERENCES_TABLE_HEADER_COLOUR = "#E0C040";
    static final String REF_STYLE;
    static final String REF_SCRIPT;
    protected static boolean DEBUG;
    private File htmlRoot = null;
    private File reportsRoot = null;
    private String xmlLocation = null;
    private String htmlLocation = null;
    private File htmlIndex = null;
    SAXParser parser = null;
    private boolean hasmissing = false;
    private UseMetadata metadata = null;
    Pattern[] topatterns = null;
    Pattern[] frompatterns = null;
    static /* synthetic */ Class class$0;

    static {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<style type=\"text/css\">\n");
        buffer.append("\t.main {\t\tfont-family:Arial, Helvetica, sans-serif;\n\t}\n");
        buffer.append("\t.main h3 {\n\t\tfont-family:Arial, Helvetica, sans-serif;\n\t\t\background-color:#FFFFFF;\n\t\tfont-size:14px;\n\t\tmargin:0.1em;\n\t}\n");
        buffer.append("\t.main h4 {\n\t\tbackground-color:#CCCCCC;\n\t\tmargin:0.15em;\n\t}\n");
        buffer.append("\ta.typeslnk {\n\t\tfont-family:Arial, Helvetica, sans-serif;\n\t\ttext-decoration:none;\n\t\tmargin-left:0.25em;\n\t}\n");
        buffer.append("\ta.typeslnk:hover {\n\t\ttext-decoration:underline;\n\t}\n");
        buffer.append("\ta.kindslnk {\n\t\tfont-family:Arial, Helvetica, sans-serif;\n\t\ttext-decoration:none;\n\t\tmargin-left:0.25em;\n\t}\n");
        buffer.append("\t.types {\n\t\tdisplay:none;\n\t\tmargin-bottom:0.25em;\n\t\tmargin-top:0.25em;\n\t\tmargin-right:0.25em;\n\t\tmargin-left:0.75em;\n\t}\n");
        buffer.append("</style>\n");
        REF_STYLE = buffer.toString();
        buffer = new StringBuffer();
        buffer.append("<script type=\"text/javascript\">\n\tfunction expand(location) {\n\t\tif(document.getElementById) {\n\t\t\tvar childhtml = location.firstChild;\n\t\t\tif(!childhtml.innerHTML) {\n\t\t\t\tchildhtml = childhtml.nextSibling;\n\t\t\t}\n\t\t\tchildhtml.innerHTML = childhtml.innerHTML == '[+] ' ? '[-] ' : '[+] ';\n\t\t\tvar parent = location.parentNode;\n\t\t\tchildhtml = parent.nextSibling.style ? parent.nextSibling : parent.nextSibling.nextSibling;\n\t\t\tchildhtml.style.display = childhtml.style.display == 'block' ? 'none' : 'block';\n\t\t}\n\t}\n</script>\n");
        buffer.append("<noscript>\n\t<style type=\"text/css\">\n\t\t.types {display:block;}\n\t\t.kinds{display:block;}\n\t</style>\n</noscript>\n");
        REF_SCRIPT = buffer.toString();
        DEBUG = Util.DEBUG;
    }

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public UseReportConverter(String htmlroot, String xmlroot, String[] topatterns, String[] frompatterns) {
        int i;
        ArrayList<Pattern> pats;
        this.xmlLocation = xmlroot;
        this.htmlLocation = htmlroot;
        if (topatterns != null) {
            pats = new ArrayList<Pattern>(topatterns.length);
            i = 0;
            while (i < topatterns.length) {
                block10: {
                    try {
                        pats.add(Pattern.compile(topatterns[i]));
                    }
                    catch (PatternSyntaxException pse) {
                        if (!DEBUG) break block10;
                        System.out.println(NLS.bind((String)SearchMessages.UseReportConverter_filter_pattern_not_valid, (Object)topatterns[i]));
                        System.out.println(pse.getMessage());
                    }
                }
                ++i;
            }
            if (!pats.isEmpty()) {
                this.topatterns = pats.toArray(new Pattern[pats.size()]);
            }
        }
        if (frompatterns != null) {
            pats = new ArrayList(frompatterns.length);
            i = 0;
            while (i < frompatterns.length) {
                block11: {
                    try {
                        pats.add(Pattern.compile(frompatterns[i]));
                    }
                    catch (PatternSyntaxException pse) {
                        if (!DEBUG) break block11;
                        System.out.println(NLS.bind((String)SearchMessages.UseReportConverter_filter_pattern_not_valid, (Object)frompatterns[i]));
                        System.out.println(pse.getMessage());
                    }
                }
                ++i;
            }
            if (!pats.isEmpty()) {
                this.frompatterns = pats.toArray(new Pattern[pats.size()]);
            }
        }
    }

    public void convert(String xslt, IProgressMonitor monitor) throws Exception {
        if (this.htmlLocation == null) {
            return;
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.UseReportConverter_preparing_report_metadata, (int)11);
        try {
            localmonitor.setTaskName(SearchMessages.UseReportConverter_preparing_html_root);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            this.htmlRoot = new File(this.htmlLocation);
            if (!this.htmlRoot.exists()) {
                if (!this.htmlRoot.mkdirs()) {
                    throw new Exception(NLS.bind((String)SearchMessages.could_not_create_file, (Object)this.htmlLocation));
                }
            } else {
                this.htmlRoot.mkdirs();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_preparing_xml_root);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            if (this.xmlLocation == null) {
                throw new Exception(SearchMessages.missing_xml_files_location);
            }
            this.reportsRoot = new File(this.xmlLocation);
            if (!this.reportsRoot.exists() || !this.reportsRoot.isDirectory()) {
                throw new Exception(NLS.bind((String)SearchMessages.invalid_directory_name, (Object)this.xmlLocation));
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_preparing_xslt_file);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            File xsltFile = null;
            if (!(xslt == null || (xsltFile = new File(xslt)).exists() && xsltFile.isFile())) {
                throw new Exception(SearchMessages.UseReportConverter_xslt_file_not_valid);
            }
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_writing_not_searched);
            this.writeMissingBundlesPage(this.htmlRoot);
            this.writeNotSearchedPage(this.htmlRoot);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            if (DEBUG) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                System.out.println("Parsing use scan...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_parsing_use_scan);
            UseScanParser parser = new UseScanParser();
            Visitor convertor = new Visitor();
            parser.parse(this.xmlLocation, (IProgressMonitor)localmonitor.newChild(5), convertor);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            if (DEBUG) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                System.out.println("Sorting reports and writing index...");
                start = System.currentTimeMillis();
            }
            localmonitor.setTaskName(SearchMessages.UseReportConverter_writing_root_index);
            Collections.sort(convertor.reports, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Report)o1).name.compareTo(((Report)o2).name);
                }
            });
            this.writeIndexPage(convertor.reports, this.htmlRoot);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            if (DEBUG) {
                System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
            }
            this.writeMetaPage(this.htmlRoot);
        }
        finally {
            if (localmonitor != null) {
                localmonitor.done();
            }
        }
    }

    SAXParser getParser() throws Exception {
        if (this.parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                this.parser = factory.newSAXParser();
            }
            catch (ParserConfigurationException pce) {
                throw new Exception(SearchMessages.UseReportConverter_pce_error_getting_parser, pce);
            }
            catch (SAXException se) {
                throw new Exception(SearchMessages.UseReportConverter_se_error_parser_handle, se);
            }
            if (this.parser == null) {
                throw new Exception(SearchMessages.could_not_create_sax_parser);
            }
        }
        return this.parser;
    }

    protected String composeName(String id, String version) {
        StringBuffer buffer = new StringBuffer(3 + id.length() + version.length());
        buffer.append(id).append(" (").append(version).append(")");
        return buffer.toString();
    }

    public File getReportIndex() {
        return this.htmlIndex;
    }

    protected void applyXSLT(File xsltFile, File xmlfile, File htmloutput) throws TransformerException, Exception {
        StreamSource xslt = null;
        if (xsltFile != null) {
            xslt = new StreamSource(xsltFile);
        } else {
            InputStream defaultXsltInputStream;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.search.UseReportConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((defaultXsltInputStream = clazz.getResourceAsStream(DEFAULT_XSLT)) != null) {
                xslt = new StreamSource(new BufferedInputStream(defaultXsltInputStream));
            }
        }
        if (xslt == null) {
            throw new Exception(SearchMessages.UseReportConverter_no_xstl_specified);
        }
        this.applyXSLT(xslt, xmlfile, htmloutput);
    }

    protected void applyXSLT(Source xslt, File xmlfile, File htmlfile) throws TransformerException {
        StreamSource xml = new StreamSource(xmlfile);
        StreamResult html = new StreamResult(htmlfile);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer former = factory.newTransformer(xslt);
        former.transform(xml, html);
    }

    protected void tranformXml(File[] xmlfiles, File xsltFile) {
        File html = null;
        int i = 0;
        while (i < xmlfiles.length) {
            try {
                File htmlroot = new File(this.htmlLocation, this.getHTMLFileLocation(this.reportsRoot, xmlfiles[i]));
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                html = new File(this.getNameFromXMLFilename(xmlfiles[i]));
                this.applyXSLT(xsltFile, xmlfiles[i], html);
            }
            catch (TransformerException transformerException) {
            }
            catch (Exception e) {
                ApiPlugin.log(e);
            }
            ++i;
        }
    }

    protected String getHTMLFileLocation(File reportroot, File xmlfile) {
        Path report;
        Path xml = new Path(xmlfile.getPath());
        int segments = xml.matchingFirstSegments((IPath)(report = new Path(reportroot.getPath())));
        if (segments > 0) {
            if (xml.getDevice() != null) {
                xml = xml.setDevice(null);
            }
            IPath html = xml.removeFirstSegments(segments);
            return html.removeLastSegments(1).toOSString();
        }
        return null;
    }

    protected String getNameFromXMLFilename(File xmlFile) {
        String fileName = xmlFile.getAbsolutePath();
        int index = fileName.lastIndexOf(46);
        StringBuffer buffer = new StringBuffer();
        buffer.append(fileName.substring(this.reportsRoot.getAbsolutePath().length(), index)).append(".html");
        File htmlFile = new File(this.htmlLocation, String.valueOf(buffer));
        return htmlFile.getAbsolutePath();
    }

    protected String[] getMissingBundles(File missingfile) throws Exception {
        MissingHandler handler = new MissingHandler();
        this.getParser().parse(missingfile, (DefaultHandler)handler);
        return handler.missing.toArray(new String[handler.missing.size()]);
    }

    protected String getMissingBundlesHeader() {
        return SearchMessages.UseReportConverter_reported_missing_bundles;
    }

    void writeMetaPage(File htmlroot) throws Exception {
        File meta = null;
        PrintWriter writer = null;
        try {
            File file = new File(this.reportsRoot, "meta.xml");
            if (!file.exists()) {
                return;
            }
            try {
                String filename = "meta";
                meta = new File(htmlroot, String.valueOf(filename) + ".html");
                if (!meta.exists()) {
                    meta.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append("<title>").append(SearchMessages.UseReportConverter_use_scan_info).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(SearchMessages.UseReportConverter_use_scan_info).append("</h3>\n");
                this.writeMetadataSummary(buffer);
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(meta), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)meta.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void writeMissingBundlesPage(File htmlroot) throws Exception {
        File missing = null;
        PrintWriter writer = null;
        try {
            try {
                File file;
                String filename = "missing";
                missing = new File(htmlroot, String.valueOf(filename) + ".html");
                if (!missing.exists()) {
                    missing.createNewFile();
                }
                if (!(file = new File(this.reportsRoot, "not_searched.xml")).exists()) {
                    file = new File(this.reportsRoot + File.separator + "xml", "not_searched.xml");
                }
                TreeSet<String> sorted = new TreeSet<String>(Util.componentsorter);
                if (file.exists()) {
                    String[] missingBundles = this.getMissingBundles(file);
                    this.hasmissing = missingBundles.length > 0;
                    int i = 0;
                    while (i < missingBundles.length) {
                        sorted.add(missingBundles[i]);
                        ++i;
                    }
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append("<title>").append(SearchMessages.UseReportConverter_missing_required).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(SearchMessages.UseReportConverter_missing_required).append("</h3>\n");
                if (sorted.isEmpty()) {
                    buffer.append(SearchMessages.UseReportConverter_no_required_missing).append("<br>");
                } else {
                    buffer.append("<p>").append(this.getMissingBundlesHeader()).append("</p>\n");
                    buffer.append("<table border=\"1\" width=\"50%\">\n");
                    buffer.append("<tr>\n").append("<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"36%\">").append("<b>").append(SearchMessages.UseReportConverter_required_bundles).append("</b>").append("</td>\n").append("</tr>\n");
                }
                String value = null;
                Iterator iter = sorted.iterator();
                while (iter.hasNext()) {
                    value = (String)iter.next();
                    buffer.append("<tr>\n").append("<td>").append(value).append("</td>\n").append("</tr>\n");
                }
                buffer.append("</table>\n");
                buffer.append("<br>").append("<a href=\"not_searched.html\">").append(SearchMessages.UseReportConverter_back_to_not_searched).append("</a>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(missing), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)missing.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    void writeNotSearchedPage(File htmlroot) throws Exception {
        File originhtml = null;
        try {
            Class<?> clazz;
            File xml;
            String filename = "not_searched";
            originhtml = new File(htmlroot, String.valueOf(filename) + ".html");
            if (!originhtml.exists()) {
                originhtml.createNewFile();
            }
            if (!(xml = new File(this.reportsRoot, String.valueOf(filename) + ".xml")).exists()) {
                xml = new File(this.reportsRoot + File.separator + "xml", String.valueOf(filename) + ".xml");
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.search.UseReportConverter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream defaultXsltInputStream = clazz.getResourceAsStream(this.getNotSearchedXSLPath());
            StreamSource xslt = null;
            if (defaultXsltInputStream != null) {
                xslt = new StreamSource(new BufferedInputStream(defaultXsltInputStream));
            }
            if (xslt == null) {
                throw new Exception(SearchMessages.UseReportConverter_no_xstl_specified);
            }
            if (xml.exists()) {
                this.applyXSLT(xslt, xml, originhtml);
            }
        }
        catch (IOException iOException) {
            throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
        }
        catch (TransformerException te) {
            throw new Exception(SearchMessages.UseReportConverter_te_applying_xslt_skipped, te);
        }
        catch (CoreException coreException) {
            throw new Exception(NLS.bind((String)SearchMessages.UseReportConverter_coreexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
        }
    }

    String getNotSearchedXSLPath() {
        return "/notsearched.xsl";
    }

    protected void writeReferencedMemberPage(Report report, List referees) throws Exception {
        PrintWriter writer = null;
        File originhtml = null;
        try {
            try {
                File htmlroot = new File(this.htmlLocation, report.name);
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                if (!(originhtml = new File(htmlroot, "index.html")).exists()) {
                    originhtml.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append(REF_STYLE);
                buffer.append(REF_SCRIPT);
                buffer.append("<title>").append(this.getReferencedTypeTitle(report.name)).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getReferencedTypeHeader(report.name)).append("</h3>\n");
                buffer.append("<p>").append(NLS.bind((String)SearchMessages.UseReportConverter_list_of_all_refing_bundles, (Object[])new String[]{"<a href=\"#bundles\">", "</a>"})).append("</p>\n");
                String additional = this.getAdditionalReferencedTypeInformation();
                if (additional != null) {
                    buffer.append(additional);
                }
                buffer.append(this.getReferencesTableHeader(SearchMessages.UseReportConverter_referenced_type, false));
                CountGroup counts = null;
                String link = null;
                Map.Entry entry = null;
                File typefile = null;
                TreeMap map = null;
                Type type = null;
                Iterator iter = report.children.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    map = (TreeMap)entry.getValue();
                    type = (Type)entry.getKey();
                    counts = type.counts;
                    String fqname = Signatures.getQualifiedTypeSignature((IReferenceTypeDescriptor)type.desc);
                    typefile = new File(htmlroot, String.valueOf(fqname) + ".html");
                    if (!typefile.exists()) {
                        typefile.createNewFile();
                    }
                    link = this.extractLinkFrom(htmlroot, typefile.getAbsolutePath());
                    buffer.append(this.getReferenceTableEntry(counts, link, fqname, false));
                    this.writeTypePage(map, type, typefile, fqname);
                }
                buffer.append("</table>\n");
                buffer.append("<br>");
                buffer.append("<h4>").append(SearchMessages.UseReportConverter_referencing_bundles).append("</h4>\n");
                buffer.append("<p>").append(NLS.bind((String)SearchMessages.UseReportConverter_following_bundles_have_refs, (Object)report.name)).append("</p>\n");
                buffer.append("<a name=\"bundles\">").append("</a>\n");
                buffer.append("<table border=\"1\" width=\"80%\">\n");
                buffer.append("<tr>\n");
                buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"50%\">").append("<b>").append(SearchMessages.UseReportConverter_bundle).append("</b>").append("</td>\n");
                buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"20%\" align=\"center\">").append("<b>").append(SearchMessages.UseReportConverter_version).append("</b>").append("</td>\n");
                buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"10%\" align=\"center\">").append("<b>").append(SearchMessages.UseReportConverter_reference_count).append("</b>").append("</td>\n");
                buffer.append("</tr>\n");
                Collections.sort(referees, compare);
                IComponentDescriptor comp = null;
                int i = 0;
                while (i < referees.size()) {
                    type = (Type)referees.get(i);
                    comp = (IComponentDescriptor)type.desc;
                    buffer.append("<tr bgcolor=\"").append(this.getRowColour(counts)).append("\">\n");
                    buffer.append("\t").append("<td>").append("<b>").append(comp.getId()).append("</b>").append("</td>\n");
                    buffer.append("\t").append("<td>").append(comp.getVersion()).append("</td>\n");
                    buffer.append("\t<td align=\"center\">").append(type.counts.getTotalRefCount()).append("</td>\n");
                    buffer.append("</tr>\n");
                    ++i;
                }
                buffer.append("</table>\n");
                buffer.append("<p>").append("<a href=\"../index.html\">").append(SearchMessages.UseReportConverter_back_to_bundle_index).append("</a>\n").append("</p>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(originhtml), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    String getRowColour(CountGroup counts) {
        if (counts.getTotalInternalRefCount() > 0) {
            return INTERNAL_REFS_COLOUR;
        }
        if (counts.getTotalIllegalRefCount() > 0) {
            return ILLEGAL_REFS_COLOUR;
        }
        return NORMAL_REFS_COLOUR;
    }

    protected String getAdditionalReferencedTypeInformation() {
        return null;
    }

    protected String getReferencedTypeTitle(String bundle) {
        return NLS.bind((String)SearchMessages.UseReportConverter_types_used_in, (Object)bundle);
    }

    protected String getReferencedTypeHeader(String bundle) {
        return NLS.bind((String)SearchMessages.UseReportConverter_types_used_in, (Object)bundle);
    }

    void writeTypePage(TreeMap map, Type type, File typefile, String typename) throws Exception {
        PrintWriter writer = null;
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append(REF_STYLE);
                buffer.append(REF_SCRIPT);
                buffer.append("<title>").append(this.getTypeTitle(typename)).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getTypeHeader(typename)).append("</h3>\n");
                buffer.append(this.getTypeCountSummary(typename, type.counts, map.size()));
                buffer.append("<h4>").append(this.getTypeDetailsHeader()).append("</h4>\n");
                buffer.append("<p>").append(this.getTypeDetails()).append("</p>\n");
                buffer.append("<div align=\"left\" class=\"main\">");
                buffer.append("<table border=\"1\" width=\"80%\">\n");
                buffer.append("<tr>\n");
                buffer.append("<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\">").append("<b>").append(SearchMessages.UseReportConverter_member).append("</b></td>\n");
                buffer.append("</tr>\n");
                Map.Entry entry = null;
                IElementDescriptor desc = null;
                Member mem = null;
                Iterator iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    desc = (IElementDescriptor)entry.getKey();
                    mem = (Member)entry.getValue();
                    buffer.append("<tr>\n");
                    buffer.append("<td align=\"left\">\n");
                    buffer.append("<b>");
                    buffer.append("<a href=\"javascript:void(0)\" class=\"typeslnk\" onclick=\"expand(this)\" title=\"");
                    buffer.append(this.getDisplayName(desc, true, true)).append("\">\n");
                    buffer.append("<span>[+] </span>").append(this.getDisplayName(desc, true, false)).append("\n");
                    buffer.append("</a>\n").append("</b>");
                    buffer.append("<div colspan=\"6\" class=\"types\">\n");
                    buffer.append(this.getReferencesTable(mem)).append("\n");
                    buffer.append("</div>\n");
                    buffer.append("</tr>\n");
                }
                buffer.append("</table>\n");
                buffer.append("</div>\n");
                buffer.append("<p>").append("<a href=\"index.html\">").append(SearchMessages.UseReportConverter_back_to_bundle_index).append("</a>\n").append("</p>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(typefile), "UTF-8"));
                writer.print(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)typefile.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected String getTypeDetailsHeader() {
        return SearchMessages.UseReportConverter_reference_details;
    }

    protected String getTypeDetails() {
        return SearchMessages.UseReportConverter_click_an_entry_to_see_details;
    }

    protected String getTypeTitle(String typename) {
        return NLS.bind((String)SearchMessages.UseReportConverter_usage_details, (Object)Signature.getSimpleName((String)typename));
    }

    protected String getTypeHeader(String typename) {
        return NLS.bind((String)SearchMessages.UseReportConverter_usage_details, (Object)Signature.getSimpleName((String)typename));
    }

    String getReferencesTable(Member member) {
        StringBuffer buffer = new StringBuffer();
        Map.Entry entry = null;
        buffer.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"6\">\n");
        ArrayList refs = null;
        Reference ref = null;
        Iterator iter = member.children.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            buffer.append("<tr align=\"left\"> \n");
            buffer.append("<td colspan=\"3\" bgcolor=\"#CCCCCC\">").append("<b>").append(entry.getKey()).append("</b>").append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\">");
            buffer.append("<td align=\"left\" width=\"84%\">").append("<b>").append(SearchMessages.UseReportConverter_reference_location).append("</b>").append("</td>\n");
            buffer.append("<td align=\"center\" width=\"8%\">").append("<b>").append(SearchMessages.UseReportConverter_line_number).append("</b>").append("</td>\n");
            buffer.append("<td align=\"center\" width=\"8%\">").append("<b>").append(SearchMessages.UseReportConverter_reference_kind).append("</b>").append("</td>\n");
            buffer.append("</tr>\n");
            refs = (ArrayList)entry.getValue();
            Collections.sort(refs, compare);
            Iterator iter2 = refs.iterator();
            while (iter2.hasNext()) {
                ref = (Reference)iter2.next();
                try {
                    String name = this.getDisplayName(ref.desc, false, true);
                    buffer.append("<tr>\n");
                    buffer.append("<td>").append(name).append("</td>\n");
                    buffer.append("<td align=\"center\">").append(ref.line).append("</td>\n");
                    buffer.append("<td align=\"center\">").append("<span class=\"typeslnk\"");
                    if (ref.message != null) {
                        buffer.append(" title=\"").append(ref.message).append("\"");
                    }
                    buffer.append(">").append(VisibilityModifiers.getVisibilityName(ref.vis)).append("</span>");
                    buffer.append("</td>\n").append("</tr>\n");
                }
                catch (CoreException ce) {
                    ApiPlugin.log(ce);
                }
            }
        }
        buffer.append("</table>\n");
        return buffer.toString();
    }

    String getDisplayName(IElementDescriptor desc, boolean qualifiedparams, boolean qualified) throws CoreException {
        String displayname = null;
        switch (desc.getElementType()) {
            case 2: {
                IReferenceTypeDescriptor rtype = (IReferenceTypeDescriptor)desc;
                displayname = Signatures.getTypeSignature(rtype.getSignature(), rtype.getGenericSignature(), qualified);
                break;
            }
            case 6: {
                IMethodDescriptor method = (IMethodDescriptor)desc;
                if (qualified) {
                    displayname = Signatures.getQualifiedMethodSignature(method, qualifiedparams, qualifiedparams);
                    break;
                }
                displayname = Signatures.getMethodSignature(method, qualifiedparams);
                break;
            }
            case 5: {
                IFieldDescriptor field = (IFieldDescriptor)desc;
                displayname = qualified ? Signatures.getQualifiedFieldSignature(field) : field.getName();
            }
        }
        return displayname;
    }

    String extractLinkFrom(File root, String fileName) {
        StringBuffer buffer = new StringBuffer();
        String substring = fileName.substring(root.getAbsolutePath().length()).replace('\\', '/');
        buffer.append('.');
        if (substring.charAt(0) != '/') {
            buffer.append('/');
        }
        buffer.append(substring);
        return String.valueOf(buffer);
    }

    protected String getIndexTitle() {
        return SearchMessages.UseReportConverter_bundle_usage_information;
    }

    protected String getIndexHeader() {
        return SearchMessages.UseReportConverter_bundle_usage_information;
    }

    void writeIndexPage(List sortedreports, File reportsRoot) throws Exception {
        PrintWriter writer = null;
        try {
            try {
                this.htmlIndex = new File(this.htmlLocation, "index.html");
                if (!this.htmlIndex.exists()) {
                    this.htmlIndex.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append("<html>\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                this.writeMetadataHeaders(buffer);
                buffer.append("<title>").append(this.getIndexTitle()).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getIndexHeader()).append("</h3>\n");
                try {
                    this.getMetadata();
                    this.writeMetadataSummary(buffer);
                }
                catch (Exception exception) {}
                buffer.append("<h4>").append(SearchMessages.UseReportConvertor_additional_infos_section).append("</h4>\n");
                if (this.hasmissing) {
                    buffer.append("<p>");
                    buffer.append(NLS.bind((String)SearchMessages.UseReportConverter_missing_bundles_prevented_scan, (Object[])new String[]{" <a href=\"./missing.html\">", "</a>"}));
                    buffer.append("</p>\n");
                }
                buffer.append("<p>");
                buffer.append(NLS.bind((String)SearchMessages.UseReportConverter_bundles_that_were_not_searched, (Object[])new String[]{"<a href=\"./not_searched.html\">", "</a></p>\n"}));
                String additional = this.getAdditionalIndexInfo(sortedreports.size() > 0);
                if (additional != null) {
                    buffer.append(additional);
                }
                if (sortedreports.size() > 0) {
                    buffer.append("<p>").append(SearchMessages.UseReportConverter_inlined_description).append("</p>\n");
                    buffer.append(this.getColourLegend());
                    buffer.append(this.getReferencesTableHeader(SearchMessages.UseReportConverter_bundle, true));
                    if (sortedreports.size() > 0) {
                        Report report = null;
                        File refereehtml = null;
                        String link = null;
                        Iterator iter = sortedreports.iterator();
                        while (iter.hasNext()) {
                            report = (Report)iter.next();
                            if (report == null) continue;
                            refereehtml = new File(this.reportsRoot, String.valueOf(report.name) + File.separator + "index.html");
                            link = this.extractLinkFrom(this.reportsRoot, refereehtml.getAbsolutePath());
                            buffer.append(this.getReferenceTableEntry(report.counts, link, report.name, true));
                        }
                        buffer.append("</table>\n");
                    }
                } else {
                    buffer.append(this.getNoReportsInformation());
                }
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                buffer.append("</body>\n").append("</html>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlIndex), "UTF-8"));
                writer.print(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)this.htmlIndex.getAbsolutePath()));
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected String getColourLegend() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>");
        buffer.append("<table width=\"20%\" border=\"1\">");
        buffer.append("<tr>\n");
        buffer.append("<td width=\"25px\" bgcolor=\"").append(INTERNAL_REFS_COLOUR).append("\">\n").append("&nbsp;").append("</td>\n");
        buffer.append("<td width=\"82%\">").append(SearchMessages.UseReportConverter_marks_internal_references).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("<tr>\n");
        buffer.append("<td width=\"25px\" bgcolor=\"").append(ILLEGAL_REFS_COLOUR).append("\">\n").append("&nbsp;").append("</td>\n");
        buffer.append("<td width=\"82%\">").append(SearchMessages.UseReportConverter_marks_illegal_use_references).append("</td>\n");
        buffer.append("</tr>\n");
        buffer.append("</table>\n");
        buffer.append("</p>\n");
        return buffer.toString();
    }

    protected String getNoReportsInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p>").append("<br>").append(SearchMessages.UseReportConverter_no_reported_usage).append("</p>\n");
        return buffer.toString();
    }

    void writeMetadataHeaders(StringBuffer buffer) throws Exception {
        this.writeMetaTag(buffer, "description", SearchMessages.UseReportConverter_root_index_description);
    }

    void writeMetadataSummary(StringBuffer buffer) throws Exception {
        buffer.append("<h4>").append(SearchMessages.UseReportConverter_scan_details).append("</h4>\n");
        if (this.metadata != null) {
            int i;
            buffer.append("<table border=\"0px\" title=\"").append(SearchMessages.UseReportConverter_scan_details).append("\"width=\"50%\">");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_scan_date).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getRunAtDate()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_description).append("</td>\n");
            String desc = this.metadata.getDescription();
            buffer.append(UseReportConverter.openTD(36)).append(desc != null ? desc : SearchMessages.UseReportConverter_none).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_includes_API_refs).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.includesAPI()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_includes_internal_refs).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.includesInternal()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_includes_illegal_use).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.includesIllegalUse()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_baseline_loc).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getBaselineLocation()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_scope_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getScopePattern()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_reference_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getReferencePattern()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_report_location).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36)).append(this.metadata.getReportLocation()).append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_api_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            String[] patterns = this.metadata.getApiPatterns();
            if (patterns != null) {
                buffer.append(this.metadata.getApiPatterns());
                i = 0;
                while (i < patterns.length) {
                    buffer.append(patterns[i]).append("<br>");
                    ++i;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_internal_patterns).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            patterns = this.metadata.getInternalPatterns();
            if (patterns != null) {
                i = 0;
                while (i < patterns.length) {
                    buffer.append(patterns[i]).append("<br>");
                    ++i;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_archive_patterns).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            patterns = this.metadata.getArchivePatterns();
            if (patterns != null) {
                i = 0;
                while (i < patterns.length) {
                    buffer.append(patterns[i]).append("<br>");
                    ++i;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_filter_pattern).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            if (this.frompatterns != null) {
                i = 0;
                while (i < this.frompatterns.length) {
                    buffer.append(this.frompatterns[i].pattern()).append("<br>");
                    ++i;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("<tr>\n");
            buffer.append(UseReportConverter.openTD(14)).append(SearchMessages.UseReportConverter_to_filter_patterns).append("</td>\n");
            buffer.append(UseReportConverter.openTD(36));
            if (this.topatterns != null) {
                i = 0;
                while (i < this.topatterns.length) {
                    buffer.append(this.topatterns[i].pattern()).append("<br>");
                    ++i;
                }
            } else {
                buffer.append(SearchMessages.UseReportConverter_none);
            }
            buffer.append("</td>\n");
            buffer.append("</tr>\n");
            buffer.append("</table>\n");
        } else {
            buffer.append("<p>").append(SearchMessages.UseReportConverter_no_additional_scan_info).append("</p>\n");
        }
    }

    UseMetadata getMetadata() throws Exception {
        if (this.metadata == null) {
            File xml = null;
            try {
                xml = new File(this.reportsRoot, "meta.xml");
                if (!xml.exists()) {
                    xml = new File(this.reportsRoot + File.separator + "xml", "meta.xml");
                }
                if (xml.exists()) {
                    String xmlstr = Util.getFileContentAsString(xml);
                    Element doc = Util.parseDocument(xmlstr.trim());
                    this.metadata = new UseMetadata();
                    Element element = null;
                    String value = null;
                    String name = null;
                    NodeList nodes = doc.getElementsByTagName("*");
                    int i = 0;
                    while (i < nodes.getLength()) {
                        element = (Element)nodes.item(i);
                        value = element.getAttribute("value");
                        name = element.getNodeName();
                        if ("flags".equals(name)) {
                            try {
                                this.metadata.setSearchflags(Integer.parseInt(value));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if ("runatdate".equals(name)) {
                            this.metadata.setRunAtDate(value);
                        } else if ("description".equals(name)) {
                            this.metadata.setDescription(value);
                        } else if ("baselinelocation".equals(name)) {
                            this.metadata.setBaselineLocation(value);
                        } else if ("reportlocation".equals(name)) {
                            this.metadata.setReportLocation(value);
                        } else if ("scopepattern".equals(name)) {
                            this.metadata.setScopePattern(value);
                        } else if ("referencepattern".equals(name)) {
                            this.metadata.setReferencePattern(value);
                        } else if ("apipatterns".equals(name)) {
                            this.metadata.setApiPatterns(this.readPatterns(element));
                        } else if ("internalpatterns".equals(name)) {
                            this.metadata.setInternalPatterns(this.readPatterns(element));
                        } else if ("archivepatterns".equals(name)) {
                            this.metadata.setArchivePatterns(this.readPatterns(element));
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {
                throw new Exception(NLS.bind((String)SearchMessages.UseReportConverter_core_exep_reading_metadata, (Object)xml.getAbsolutePath()));
            }
        }
        return this.metadata;
    }

    private String[] readPatterns(Element element) {
        String[] pats = null;
        NodeList patterns = element.getElementsByTagName("pattern");
        int length = patterns.getLength();
        if (length > 0) {
            pats = new String[length];
            int j = 0;
            while (j < length) {
                pats[j] = ((Element)patterns.item(j)).getAttribute("value");
                ++j;
            }
        }
        return pats;
    }

    void writeMetaTag(StringBuffer buffer, String name, String content) {
        buffer.append("<meta name=\"").append(name).append("\" content=\"").append(content).append("\">");
    }

    String getReferencesTableHeader(String columnname, boolean includeversion) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<h4>").append(SearchMessages.UseReportConverter_references).append("</h4>\n");
        buffer.append("<table border=\"1\" width=\"80%\">\n");
        buffer.append("<tr>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" width=\"30%\">").append("<b>").append(columnname).append("</b>").append("</td>\n");
        if (includeversion) {
            buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"20%\" title=\"");
            buffer.append(SearchMessages.UseReportConverter_version_column_description).append("\"\">");
            buffer.append("<b>").append(SearchMessages.UseReportConverter_version).append("</b>").append("</td>\n");
        }
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_api_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_api_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_internal_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_internal_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_permissible_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_internal_permissible_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_fragment_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_fragment_permissible_references).append("</b>").append("</td>\n");
        buffer.append("\t<td bgcolor=\"").append(REFERENCES_TABLE_HEADER_COLOUR).append("\" align=\"center\" width=\"8%\" title=\"");
        buffer.append(SearchMessages.UseReportConverter_illegal_ref_description).append("\">");
        buffer.append("<b>").append(SearchMessages.UseReportConverter_illegal).append("</b>").append("</td>\n");
        return buffer.toString();
    }

    String getReferenceTableEntry(CountGroup counts, String link, String linktext, boolean includeversion) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr bgcolor=\"").append(this.getRowColour(counts)).append("\">\n");
        buffer.append("\t<td><b><a href=\"").append(link).append("\">").append(this.getBundleOnlyName(linktext)).append("</a>").append("</b>").append("</td>\n");
        if (includeversion) {
            buffer.append("\t<td align=\"left\">").append(this.getVersion(linktext)).append("</td>\n");
        }
        buffer.append("\t<td align=\"center\">").append(counts.getTotalApiRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalInternalRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalPermissableRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalFragmentPermissibleRefCount()).append("</td>\n");
        buffer.append("\t<td align=\"center\">").append(counts.getTotalIllegalRefCount()).append("</td>\n");
        buffer.append("</tr>\n");
        return buffer.toString();
    }

    String getBundleOnlyName(String text) {
        int idx = text.indexOf(40);
        if (idx > -1) {
            return text.substring(0, idx - 1);
        }
        return text;
    }

    String getVersion(String text) {
        int idx = text.indexOf(40);
        if (idx > -1) {
            int idx2 = text.indexOf(41, idx);
            String version = text.substring(idx + 1, idx2);
            try {
                Version ver = new Version(version);
                return ver.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return "-";
    }

    protected String getAdditionalIndexInfo(boolean hasreports) {
        return null;
    }

    protected String getTypeCountSummary(String typename, CountGroup counts, int membercount) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<h4>").append(SearchMessages.UseReportConverter_summary).append("</h4>\n");
        buffer.append("<p>").append(NLS.bind((String)SearchMessages.UseReportConverter___has_total_refs, (Object[])new String[]{typename, Integer.toString(counts.getTotalRefCount()), Integer.toString(membercount)})).append("</p>\n");
        return buffer.toString();
    }

    static final class CountGroup {
        int total_api_field_count = 0;
        int total_private_field_count = 0;
        int total_permissable_field_count = 0;
        int total_fragment_permissible_field_count = 0;
        int total_illegal_field_count = 0;
        int total_api_method_count = 0;
        int total_private_method_count = 0;
        int total_permissable_method_count = 0;
        int total_fragment_permissible_method_count = 0;
        int total_illegal_method_count = 0;
        int total_api_type_count = 0;
        int total_private_type_count = 0;
        int total_permissable_type_count = 0;
        int total_fragment_permissible_type_count = 0;
        int total_illegal_type_count = 0;

        CountGroup() {
        }

        public int getTotalRefCount() {
            return this.total_api_field_count + this.total_api_method_count + this.total_api_type_count + this.total_private_field_count + this.total_private_method_count + this.total_private_type_count + this.total_permissable_field_count + this.total_permissable_method_count + this.total_permissable_type_count + this.total_fragment_permissible_field_count + this.total_fragment_permissible_method_count + this.total_fragment_permissible_type_count + this.total_illegal_field_count + this.total_illegal_method_count + this.total_illegal_type_count;
        }

        public int getTotalApiRefCount() {
            return this.total_api_field_count + this.total_api_method_count + this.total_api_type_count;
        }

        public int getTotalInternalRefCount() {
            return this.total_private_field_count + this.total_private_method_count + this.total_private_type_count;
        }

        public int getTotalPermissableRefCount() {
            return this.total_permissable_field_count + this.total_permissable_method_count + this.total_permissable_type_count;
        }

        public int getTotalFragmentPermissibleRefCount() {
            return this.total_fragment_permissible_field_count + this.total_fragment_permissible_method_count + this.total_fragment_permissible_type_count;
        }

        public int getTotalIllegalRefCount() {
            return this.total_illegal_field_count + this.total_illegal_method_count + this.total_illegal_type_count;
        }
    }

    static class Member {
        IElementDescriptor descriptor = null;
        TreeMap children = new TreeMap(compare);
        CountGroup counts = new CountGroup();

        public Member(IElementDescriptor desc) {
            this.descriptor = desc;
        }
    }

    static final class MissingHandler
    extends DefaultHandler {
        List missing = new ArrayList();
        static String pattern = "Require-Bundle:";

        MissingHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("component".equals(qName)) {
                String value = attributes.getValue("details");
                StringTokenizer tokenizer = new StringTokenizer(value, "<>");
                int index = -1;
                while (tokenizer.hasMoreTokens()) {
                    value = tokenizer.nextToken();
                    index = value.indexOf(pattern);
                    if (index <= -1) continue;
                    this.missing.add(value.replaceAll(pattern, ""));
                }
            }
        }
    }

    static class Reference {
        IElementDescriptor desc = null;
        int line = -1;
        int vis = -1;
        String message = null;

        public Reference(IElementDescriptor desc, int line, int vis, String message) {
            this.desc = desc;
            this.line = line;
            this.vis = vis;
            this.message = message;
        }
    }

    static class Report {
        String name = null;
        TreeMap children = new TreeMap(compare);
        CountGroup counts = new CountGroup();

        Report() {
        }
    }

    static class Type {
        IElementDescriptor desc = null;
        CountGroup counts = new CountGroup();

        public Type(IElementDescriptor desc) {
            this.desc = desc;
        }
    }

    class Visitor
    extends UseScanVisitor {
        ArrayList reports = new ArrayList();
        Report currentreport = null;
        Type currenttype = null;
        Type currentreferee = null;
        Member currentmember = null;
        HashMap keys = new HashMap();
        ArrayList referees = new ArrayList();

        Visitor() {
        }

        private boolean acceptReference(IMemberDescriptor desc, Pattern[] patterns) {
            if (patterns != null) {
                int i = 0;
                while (i < patterns.length) {
                    if (patterns[i].matcher(desc.getPackage().getName()).find()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        IReferenceTypeDescriptor getEnclosingDescriptor(IMemberDescriptor member) {
            switch (member.getElementType()) {
                case 2: {
                    return (IReferenceTypeDescriptor)member;
                }
                case 5: 
                case 6: {
                    return member.getEnclosingType();
                }
            }
            return null;
        }

        public boolean visitComponent(IComponentDescriptor target) {
            this.currentreport = new Report();
            this.currentreport.name = UseReportConverter.this.composeName(target.getId(), target.getVersion());
            this.reports.add(this.currentreport);
            return true;
        }

        public void endVisit(IComponentDescriptor target) {
            try {
                try {
                    long start = 0L;
                    if (DEBUG) {
                        System.out.println("Writing report for bundle: " + target.getId());
                        start = System.currentTimeMillis();
                    }
                    if (this.currentreport.counts.getTotalRefCount() > 0) {
                        UseReportConverter.this.writeReferencedMemberPage(this.currentreport, this.referees);
                    } else {
                        this.reports.remove(this.currentreport);
                    }
                    if (DEBUG) {
                        System.out.println("done in: " + (System.currentTimeMillis() - start) + " ms");
                    }
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    this.currentreport.children.clear();
                    this.keys.clear();
                    this.referees.clear();
                }
            }
            finally {
                this.currentreport.children.clear();
                this.keys.clear();
                this.referees.clear();
            }
        }

        public boolean visitReferencingComponent(IComponentDescriptor component) {
            this.currentreferee = new Type(component);
            return true;
        }

        public void endVisitReferencingComponent(IComponentDescriptor component) {
            if (this.currentreferee.counts.getTotalRefCount() > 0) {
                this.referees.add(this.currentreferee);
            }
        }

        public boolean visitMember(IMemberDescriptor referencedMember) {
            TreeMap<IMemberDescriptor, Member> map;
            IReferenceTypeDescriptor desc = this.getEnclosingDescriptor(referencedMember);
            if (desc == null) {
                return false;
            }
            this.currenttype = (Type)this.keys.get(desc);
            if (this.currenttype == null) {
                this.currenttype = new Type(desc);
                this.keys.put(desc, this.currenttype);
            }
            if ((map = (TreeMap<IMemberDescriptor, Member>)this.currentreport.children.get(this.currenttype)) == null) {
                map = new TreeMap<IMemberDescriptor, Member>(compare);
                this.currentreport.children.put(this.currenttype, map);
            }
            this.currentmember = (Member)map.get(referencedMember);
            if (this.currentmember == null) {
                this.currentmember = new Member(referencedMember);
                map.put(referencedMember, this.currentmember);
            }
            return true;
        }

        public void endVisitMember(IMemberDescriptor referencedMember) {
            IReferenceTypeDescriptor desc;
            if (this.currentmember.children.size() == 0) {
                TreeMap map = (TreeMap)this.currentreport.children.get(this.currenttype);
                map.remove(referencedMember);
            }
            if (this.currenttype.counts.getTotalRefCount() == 0 && (desc = this.getEnclosingDescriptor(referencedMember)) != null) {
                this.keys.remove(desc);
                this.currentreport.children.remove(this.currenttype);
            }
        }

        String formatMessages(String[] messages) {
            if (messages != null) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < messages.length) {
                    buffer.append(messages[i]);
                    if (i < messages.length - 1) {
                        buffer.append("\n");
                    }
                    ++i;
                }
                return buffer.toString();
            }
            return null;
        }

        public void visitReference(IReferenceDescriptor reference) {
            IMemberDescriptor fromMember = reference.getMember();
            if (!this.acceptReference(reference.getReferencedMember(), UseReportConverter.this.topatterns) || !this.acceptReference(fromMember, UseReportConverter.this.frompatterns)) {
                return;
            }
            int lineNumber = reference.getLineNumber();
            int refKind = reference.getReferenceKind();
            int visibility = reference.getVisibility();
            String refname = org.eclipse.pde.api.tools.internal.builder.Reference.getReferenceText(refKind);
            ArrayList<Reference> refs = (ArrayList<Reference>)this.currentmember.children.get(refname);
            if (refs == null) {
                refs = new ArrayList<Reference>();
                this.currentmember.children.put(refname, refs);
            }
            refs.add(new Reference(fromMember, lineNumber, visibility, this.formatMessages(reference.getProblemMessages())));
            block0 : switch (fromMember.getElementType()) {
                case 2: {
                    switch (visibility) {
                        case 1: {
                            ++this.currentmember.counts.total_api_type_count;
                            ++this.currenttype.counts.total_api_type_count;
                            ++this.currentreferee.counts.total_api_type_count;
                            ++this.currentreport.counts.total_api_type_count;
                            break;
                        }
                        case 2: {
                            ++this.currentmember.counts.total_private_type_count;
                            ++this.currenttype.counts.total_private_type_count;
                            ++this.currentreferee.counts.total_private_type_count;
                            ++this.currentreport.counts.total_private_type_count;
                            break;
                        }
                        case 8: {
                            ++this.currentmember.counts.total_permissable_type_count;
                            ++this.currenttype.counts.total_permissable_type_count;
                            ++this.currentreferee.counts.total_permissable_type_count;
                            ++this.currentreport.counts.total_permissable_type_count;
                            break;
                        }
                        case 5: {
                            ++this.currentmember.counts.total_fragment_permissible_type_count;
                            ++this.currenttype.counts.total_fragment_permissible_type_count;
                            ++this.currentreferee.counts.total_fragment_permissible_type_count;
                            ++this.currentreport.counts.total_fragment_permissible_type_count;
                            break;
                        }
                        case 22: {
                            ++this.currentmember.counts.total_illegal_type_count;
                            ++this.currenttype.counts.total_illegal_type_count;
                            ++this.currentreferee.counts.total_illegal_type_count;
                            ++this.currentreport.counts.total_illegal_type_count;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (visibility) {
                        case 1: {
                            ++this.currentmember.counts.total_api_method_count;
                            ++this.currenttype.counts.total_api_method_count;
                            ++this.currentreferee.counts.total_api_method_count;
                            ++this.currentreport.counts.total_api_method_count;
                            break;
                        }
                        case 2: {
                            ++this.currentmember.counts.total_private_method_count;
                            ++this.currenttype.counts.total_private_method_count;
                            ++this.currentreferee.counts.total_private_method_count;
                            ++this.currentreport.counts.total_private_method_count;
                            break;
                        }
                        case 8: {
                            ++this.currentmember.counts.total_permissable_method_count;
                            ++this.currenttype.counts.total_permissable_method_count;
                            ++this.currentreferee.counts.total_permissable_method_count;
                            ++this.currentreport.counts.total_permissable_method_count;
                            break;
                        }
                        case 5: {
                            ++this.currentmember.counts.total_fragment_permissible_method_count;
                            ++this.currenttype.counts.total_fragment_permissible_method_count;
                            ++this.currentreferee.counts.total_fragment_permissible_method_count;
                            ++this.currentreport.counts.total_fragment_permissible_method_count;
                            break;
                        }
                        case 22: {
                            ++this.currentmember.counts.total_illegal_method_count;
                            ++this.currenttype.counts.total_illegal_method_count;
                            ++this.currentreferee.counts.total_illegal_method_count;
                            ++this.currentreport.counts.total_illegal_method_count;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (visibility) {
                        case 1: {
                            ++this.currentmember.counts.total_api_field_count;
                            ++this.currenttype.counts.total_api_field_count;
                            ++this.currentreferee.counts.total_api_field_count;
                            ++this.currentreport.counts.total_api_field_count;
                            break block0;
                        }
                        case 2: {
                            ++this.currentmember.counts.total_private_field_count;
                            ++this.currenttype.counts.total_private_field_count;
                            ++this.currentreferee.counts.total_private_field_count;
                            ++this.currentreport.counts.total_private_field_count;
                            break block0;
                        }
                        case 8: {
                            ++this.currentmember.counts.total_permissable_field_count;
                            ++this.currenttype.counts.total_permissable_field_count;
                            ++this.currentreferee.counts.total_permissable_field_count;
                            ++this.currentreport.counts.total_permissable_field_count;
                            break block0;
                        }
                        case 5: {
                            ++this.currentmember.counts.total_fragment_permissible_field_count;
                            ++this.currenttype.counts.total_fragment_permissible_field_count;
                            ++this.currentreferee.counts.total_fragment_permissible_field_count;
                            ++this.currentreport.counts.total_fragment_permissible_field_count;
                            break block0;
                        }
                        case 22: {
                            ++this.currentmember.counts.total_illegal_field_count;
                            ++this.currenttype.counts.total_illegal_field_count;
                            ++this.currentreferee.counts.total_illegal_field_count;
                            ++this.currentreport.counts.total_illegal_field_count;
                        }
                    }
                }
            }
        }
    }
}

