/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.commands.QueryControl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class QueryByObjectSelection
extends QueryControl {
    private Label fObjectSelectionLabel;
    private Label fLabel;
    private SelectionTracker fSelectionTracker;
    private Object fObjectSelection;

    public QueryByObjectSelection(CommandComposerPart csp, Composite comp) {
        super(csp, comp);
    }

    protected void createGroupContents(Group parent) {
        ISelectionService selectionService;
        Composite comp = this.fToolkit.createComposite((Composite)parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fLabel = this.fToolkit.createLabel(comp, "selection: ");
        this.fObjectSelectionLabel = this.fToolkit.createLabel(comp, "<no selection>", 2048);
        this.fObjectSelectionLabel.setLayoutData((Object)new GridData(768));
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (selectionService = activeWindow.getSelectionService()) != null) {
            this.fSelectionTracker = new SelectionTracker(selectionService);
        }
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (QueryByObjectSelection.this.fSelectionTracker != null) {
                    QueryByObjectSelection.this.fSelectionTracker.dispose();
                }
            }
        });
    }

    protected String getName() {
        return "Query Commands by selected object";
    }

    private boolean hasTypedParameterMatch(Command command, Object object) throws CommandException {
        IParameter[] params = command.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                IParameter param = params[i];
                ParameterType parameterType = command.getParameterType(param.getId());
                if (parameterType != null && parameterType.isCompatible(object)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Command[] getCommands() {
        Object objectSelection = this.fObjectSelection;
        if (objectSelection == null) {
            return null;
        }
        ArrayList<Command> hitList = new ArrayList<Command>();
        Command[] commands = this.getCommandService().getDefinedCommands();
        int i = 0;
        while (i < commands.length) {
            Command command = commands[i];
            try {
                if (this.hasTypedParameterMatch(command, objectSelection)) {
                    hitList.add(command);
                }
            }
            catch (CommandException commandException) {}
            ++i;
        }
        return hitList.toArray(new Command[hitList.size()]);
    }

    protected void enable(boolean enable) {
        this.fGroup.setEnabled(enable);
        this.fLabel.setEnabled(enable);
        this.fObjectSelectionLabel.setEnabled(enable);
    }

    private class SelectionTracker
    implements ISelectionListener {
        private final ISelectionService _selectionService;

        public SelectionTracker(ISelectionService selectionService) {
            this._selectionService = selectionService;
            this._selectionService.addSelectionListener((ISelectionListener)this);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object selected;
            if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
                QueryByObjectSelection.this.fObjectSelection = selected;
                String typeName = selected.getClass().getName();
                QueryByObjectSelection.this.fObjectSelectionLabel.setToolTipText(typeName);
                int dotPosition = typeName.lastIndexOf(46);
                if (dotPosition != -1) {
                    typeName = typeName.substring(dotPosition + 1);
                }
                QueryByObjectSelection.this.fObjectSelectionLabel.setText(typeName);
            }
        }

        public void dispose() {
            this._selectionService.removeSelectionListener((ISelectionListener)this);
        }
    }
}

