/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private IEditorPart fEditor;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof IClassFileEditorInput) {
                IClassFileEditorInput cfeInput = (IClassFileEditorInput)input;
                return cfeInput.getClassFile();
            }
            WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    protected IJavaElement[] getJavaElementsAt(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion.getLength() == 0) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            try {
                return resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        };
    }

    protected ITypeRoot getEditorInputJavaElement() {
        IEditorPart editor = this.getEditor();
        if (editor != null) {
            return JavaUI.getEditorInputTypeRoot(editor.getEditorInput());
        }
        return null;
    }
}

