/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.WorkbenchImages;
import org.osgi.service.event.EventHandler;

public class TrimStack {
    private static Image restoreImage;
    private static int SHOW_SHELL;
    private static int HOVER_SHELL;
    private ToolBar trimStackTB;
    MPartStack theStack;
    private Shell showShell;
    private Shell hoverShell;
    private boolean inhibitHover = false;
    private Listener mouseDownListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Control) {
                Control control = (Control)event.widget;
                if (control == null) {
                    return;
                }
                if (control.getShell() != TrimStack.this.showShell.getParent()) {
                    return;
                }
                if (control == TrimStack.this.trimStackTB) {
                    return;
                }
                TrimStack.this.showStack(false);
            }
        }
    };
    private Listener escapeListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.character == '\u001b') {
                TrimStack.this.showStack(false);
            }
        }
    };
    @Inject
    EModelService modelService;
    @Inject
    EPartService partService;
    @Inject
    MWindow window;
    @Inject
    MToolControl toolControl;
    @Inject
    protected IEventBroker eventBroker;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (changedElement != TrimStack.this.theStack) {
                return;
            }
            if (TrimStack.this.showShell != null && TrimStack.this.showShell.isVisible()) {
                TrimStack.this.updateSelection((MStackElement)TrimStack.this.theStack.getSelectedElement());
            }
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.theStack == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            MElementContainer parentElement = changedElement.getParent();
            if (TrimStack.this.theStack == null || TrimStack.this.trimStackTB == null || parentElement != TrimStack.this.theStack) {
                return;
            }
            if (!changedElement.isToBeRendered()) {
                return;
            }
            TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TrimStack.this.updateTrimStackItems();
                }
            });
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            if (TrimStack.this.theStack == null || TrimStack.this.trimStackTB == null) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj != TrimStack.this.theStack) {
                return;
            }
            TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TrimStack.this.updateTrimStackItems();
                }
            });
        }
    };
    private EventHandler widgetHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            if (changedObj != TrimStack.this.theStack) {
                return;
            }
            if (TrimStack.this.theStack.getWidget() != null) {
                TrimStack.this.trimStackTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TrimStack.this.updateTrimStackItems();
                    }
                });
            }
        }
    };
    private MTrimBar bar;

    static {
        SHOW_SHELL = 1;
        HOVER_SHELL = 2;
    }

    @PostConstruct
    void addListeners() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.selectionHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), this.widgetHandler);
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
        this.eventBroker.unsubscribe(this.widgetHandler);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl me) {
        if (this.theStack == null) {
            List ps = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
            if (ps.size() == 0) {
                this.theStack = (MPartStack)this.modelService.find(this.toolControl.getElementId(), (MUIElement)this.window);
            } else {
                String toolControlId = this.toolControl.getElementId();
                int index = toolControlId.indexOf(40);
                String stackId = toolControlId.substring(0, index);
                String perspId = toolControlId.substring(index + 1, toolControlId.length() - 1);
                MPerspective persp = (MPerspective)this.modelService.find(perspId, (MUIElement)ps.get(0));
                if (persp != null) {
                    this.theStack = (MPartStack)this.modelService.find(stackId, (MUIElement)persp);
                }
            }
        }
        MElementContainer meParent = me.getParent();
        int orientation = 256;
        if (meParent instanceof MTrimBar) {
            this.bar = (MTrimBar)meParent;
            if (this.bar.getSide() == SideValue.RIGHT || this.bar.getSide() == SideValue.LEFT) {
                orientation = 512;
            }
        }
        this.trimStackTB = new ToolBar(parent, orientation | 0x800000 | 0x40);
        ToolItem restoreBtn = new ToolItem(this.trimStackTB, 8);
        restoreBtn.setImage(this.getRestoreImage(parent.getDisplay()));
        restoreBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TrimStack.this.restoreStack();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TrimStack.this.restoreStack();
            }
        });
        this.updateTrimStackItems();
    }

    /*
     * Unable to fully structure code
     */
    private void updateTrimStackItems() {
        if (this.trimStackTB == null || this.trimStackTB.isDisposed()) {
            return;
        }
        ctf = (CTabFolder)this.theStack.getWidget();
        if (ctf != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.trimStackTB.getItem(this.trimStackTB.getItemCount() - 1).dispose();
lbl7:
            // 2 sources

            ** while (this.trimStackTB.getItemCount() > 1)
        }
lbl8:
        // 1 sources

        var6_3 = items = ctf.getItems();
        var5_4 = items.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            item = var6_3[var4_5];
            newItem = new ToolItem(this.trimStackTB, 32);
            newItem.setData((Object)item);
            newItem.setImage(item.getImage());
            newItem.setToolTipText(item.getText());
            newItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem item = (ToolItem)e.widget;
                    CTabItem cti = (CTabItem)item.getData();
                    MUIElement me = (MUIElement)cti.getData("modelElement");
                    if (me instanceof MPlaceholder) {
                        me = ((MPlaceholder)me).getRef();
                    }
                    boolean show = item.getSelection();
                    TrimStack.this.partService.activate((MPart)me);
                    TrimStack.this.showStack(show);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ToolItem item = (ToolItem)e.widget;
                    CTabItem cti = (CTabItem)item.getData();
                    MUIElement me = (MUIElement)cti.getData("modelElement");
                    if (me instanceof MPlaceholder) {
                        me = ((MPlaceholder)me).getRef();
                    }
                    boolean show = item.getSelection();
                    TrimStack.this.partService.activate((MPart)me);
                    TrimStack.this.showStack(show);
                }
            });
            ++var4_5;
        }
        if (this.showShell != null && this.showShell.isVisible()) {
            this.updateSelection((MStackElement)this.theStack.getSelectedElement());
        }
        this.trimStackTB.pack();
        this.trimStackTB.getShell().layout(new Control[]{this.trimStackTB}, 4);
    }

    protected void showHover(boolean show, ToolItem ti) {
        CTabFolder ctf = (CTabFolder)this.theStack.getWidget();
        if (show) {
            Shell hoverShell = this.getShell(HOVER_SHELL, ti.getParent().getShell());
            ctf.setParent((Composite)hoverShell);
            hoverShell.layout(true);
            CTabItem cti = (CTabItem)ti.getData();
            MUIElement element = (MUIElement)cti.getData("modelElement");
            if (element instanceof MPlaceholder) {
                element = ((MPlaceholder)element).getRef();
            }
            if (element instanceof MPart) {
                MPart part = (MPart)element;
                this.partService.showPart(part, EPartService.PartState.VISIBLE);
            }
            Rectangle itemBounds = ti.getBounds();
            Point shellSize = hoverShell.getSize();
            Point loc = new Point(itemBounds.x - shellSize.x / 2, itemBounds.y + itemBounds.height);
            loc = ti.getDisplay().map((Control)ti.getParent(), null, loc);
            hoverShell.setLocation(loc);
            hoverShell.setVisible(true);
        } else if (this.hoverShell != null) {
            this.hoverShell.setVisible(false);
        }
    }

    void restoreStack() {
        this.showStack(false);
        this.theStack.setVisible(true);
        this.toolControl.setVisible(false);
    }

    @Execute
    public void showStack(@Named(value="show") boolean show) {
        CTabFolder ctf = (CTabFolder)this.theStack.getWidget();
        if (show) {
            this.showHover(false, null);
            this.inhibitHover = true;
            Shell showShell = this.getShell(SHOW_SHELL, this.trimStackTB.getShell());
            ctf.setParent((Composite)showShell);
            showShell.getDisplay().addFilter(3, this.mouseDownListener);
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
            this.updateSelection((MStackElement)this.theStack.getSelectedElement());
            this.setShellLocation((Composite)showShell);
            showShell.layout(true);
            showShell.open();
        } else {
            if (this.showShell != null) {
                this.showShell.setVisible(false);
                this.updateSelection(null);
                this.showShell.getDisplay().removeFilter(3, this.mouseDownListener);
            }
            if (ctf != null) {
                ctf.setMinimizeVisible(true);
                ctf.setMaximizeVisible(false);
                ctf.setMaximized(false);
            }
            this.inhibitHover = false;
        }
    }

    private void setShellLocation(Composite someShell) {
        Rectangle toolbarBounds = this.trimStackTB.getBounds();
        Point shellSize = this.showShell.getSize();
        Point loc = null;
        switch (this.bar.getSide().getValue()) {
            case 0: {
                loc = new Point(toolbarBounds.x - shellSize.x / 2, toolbarBounds.y + toolbarBounds.height);
                break;
            }
            case 1: {
                loc = new Point(toolbarBounds.x - shellSize.x / 2, toolbarBounds.y - shellSize.y);
                break;
            }
            case 3: {
                loc = new Point(toolbarBounds.x - shellSize.x, toolbarBounds.y);
                break;
            }
            case 2: {
                loc = new Point(toolbarBounds.x + toolbarBounds.width, toolbarBounds.y);
            }
        }
        loc = this.trimStackTB.getDisplay().map((Control)this.trimStackTB.getParent(), null, loc);
        someShell.setLocation(loc);
    }

    private void updateSelection(MStackElement selectedElement) {
        ToolItem[] items;
        ToolItem[] toolItemArray = items = this.trimStackTB.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            CTabItem cti = (CTabItem)item.getData();
            if (cti != null && !cti.isDisposed()) {
                item.setSelection(cti.getData("modelElement") == selectedElement);
            }
            ++n2;
        }
    }

    private Shell getShell(int shellType, Shell mainShell) {
        Shell theShell;
        if (shellType == SHOW_SHELL && this.showShell != null) {
            return this.showShell;
        }
        if (shellType == HOVER_SHELL && this.hoverShell != null) {
            return this.hoverShell;
        }
        if (shellType == HOVER_SHELL) {
            this.hoverShell = new Shell(mainShell, 0);
            this.hoverShell.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
            this.hoverShell.setSize(300, 200);
            theShell = this.hoverShell;
        } else {
            this.showShell = new Shell(mainShell, 16);
            this.showShell.setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
            this.showShell.setSize(600, 400);
            theShell = this.showShell;
            theShell.addListener(31, this.escapeListener);
        }
        theShell.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle bounds = ((Shell)composite).getClientArea();
                Control[] kids = composite.getChildren();
                if (kids.length == 1) {
                    kids[0].setBounds(0, 0, bounds.width, bounds.height);
                }
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(600, 400);
            }
        });
        return theShell;
    }

    private Image getRestoreImage(Display display) {
        if (restoreImage == null) {
            restoreImage = WorkbenchImages.getImage((String)"IMG_ETOOL_RESTORE_TRIMPART");
        }
        return restoreImage;
    }

    void addTransparentTooltips(ToolBar newTB) {
        newTB.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                if (TrimStack.this.inhibitHover) {
                    return;
                }
                ToolBar tb = (ToolBar)e.widget;
                Point loc = new Point(e.x, e.y);
                ToolItem ti = tb.getItem(loc);
                if (ti.getData() != null) {
                    TrimStack.this.showHover(true, ti);
                }
            }

            public void mouseExit(MouseEvent e) {
                TrimStack.this.showHover(false, null);
            }

            public void mouseEnter(MouseEvent e) {
                TrimStack.this.showHover(false, null);
            }
        });
        newTB.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                TrimStack.this.showHover(false, null);
            }

            public void mouseDown(MouseEvent e) {
                TrimStack.this.showHover(false, null);
            }

            public void mouseDoubleClick(MouseEvent e) {
                TrimStack.this.showHover(false, null);
            }
        });
        newTB.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TrimStack.this.showHover(false, null);
            }
        });
    }
}

