/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Parameter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindingTableContainer;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class E4CommandProcessor {
    public static void processCommands(IEclipseContext context, List<MCommand> commands) {
        Activator.trace("/trace/commands", "Initialize commands from model", null);
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        Category cat = cs.defineCategory(MApplication.class.getName(), "Application Category", null);
        for (MCommand cmd : commands) {
            IParameter[] parms = null;
            String id = cmd.getElementId();
            String name = cmd.getCommandName();
            List modelParms = cmd.getParameters();
            if (modelParms != null && !modelParms.isEmpty()) {
                ArrayList<Parameter> parmList = new ArrayList<Parameter>();
                for (MCommandParameter cmdParm : modelParms) {
                    parmList.add(new Parameter(cmdParm.getElementId(), cmdParm.getName(), null, null, cmdParm.isOptional()));
                }
                parms = parmList.toArray(new Parameter[parmList.size()]);
            }
            cs.defineCommand(id, name, null, cat, parms);
        }
    }

    public static void processBindings(IEclipseContext context, MBindingTableContainer bindingContainer) {
        Activator.trace("/trace/commands", "Initialize binding tables from model", null);
        final BindingTableManager bindingTables = (BindingTableManager)ContextInjectionFactory.make(BindingTableManager.class, (IEclipseContext)context);
        context.set(BindingTableManager.class.getName(), (Object)bindingTables);
        MBindingContext root = bindingContainer.getRootContext();
        if (root == null) {
            return;
        }
        final ContextManager manager = (ContextManager)context.get(ContextManager.class.getName());
        E4CommandProcessor.defineContexts(null, root, manager);
        for (MBindingTable bt : bindingContainer.getBindingTables()) {
            Context c = manager.getContext(bt.getBindingContextId());
            E4CommandProcessor.defineBindingTable(context, c, bindingTables, bt);
        }
        ((EObject)bindingContainer).eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.isTouch()) {
                    return;
                }
                if (notification.getEventType() == 3 && notification.getNewValue() instanceof MBindingTable) {
                    MBindingTable bt = (MBindingTable)notification.getNewValue();
                    Context bindingContext = manager.getContext(bt.getBindingContextId());
                    BindingTable table = new BindingTable(bindingContext);
                    bindingTables.addTable(table);
                }
            }
        });
    }

    private static void defineBindingTable(IEclipseContext context, Context bindingContext, BindingTableManager manager, MBindingTable bt) {
        BindingTable table = new BindingTable(bindingContext);
        manager.addTable(table);
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
        List bindings = bt.getBindings();
        for (MKeyBinding binding : bindings) {
            HashMap<String, String> parameters = null;
            List modelParms = binding.getParameters();
            if (modelParms != null && !modelParms.isEmpty()) {
                parameters = new HashMap<String, String>();
                for (MParameter mParm : modelParms) {
                    parameters.put(mParm.getName(), mParm.getValue());
                }
            }
            ParameterizedCommand cmd = cs.createCommand(binding.getCommand().getElementId(), parameters);
            TriggerSequence sequence = bs.createSequence(binding.getKeySequence());
            if (cmd == null || sequence == null) {
                System.err.println("Failed to handle binding: " + binding);
                continue;
            }
            Binding keyBinding = bs.createBinding(sequence, cmd, "org.eclipse.ui.defaultAcceleratorConfiguration", bindingContext.getId());
            table.addBinding(keyBinding);
        }
    }

    private static void defineContexts(MBindingContext parent, MBindingContext current, ContextManager manager) {
        Context context = manager.getContext(current.getElementId());
        if (!context.isDefined()) {
            context.define(current.getName(), current.getDescription(), parent == null ? null : parent.getElementId());
        }
        for (MBindingContext child : current.getChildren()) {
            E4CommandProcessor.defineContexts(current, child, manager);
        }
    }
}

