/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorActionBuilder;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class EditorReference
extends WorkbenchPartReference
implements IEditorReference {
    private static String MEMENTO_KEY = "memento";
    private IEditorInput input;
    private EditorDescriptor descriptor;
    private String factoryId;
    private EditorSite editorSite;
    private String descriptorId;
    private static HashMap<String, EditorActionBars> actionCache = new HashMap();

    EditorReference(IEclipseContext windowContext, IWorkbenchPage page, MPart part, IEditorInput input, EditorDescriptor descriptor) {
        block8: {
            IPersistableElement persistable;
            super(windowContext, page, part);
            this.input = input;
            this.descriptor = descriptor;
            if (input != null && (persistable = input.getPersistable()) != null) {
                this.factoryId = persistable.getFactoryId();
                XMLMemento root = XMLMemento.createWriteRoot("editor");
                root.putString("id", descriptor.getId());
                IMemento inputMem = root.createChild("input");
                inputMem.putString("factoryID", persistable.getFactoryId());
                persistable.saveState(inputMem);
                StringWriter writer = new StringWriter();
                try {
                    root.save(writer);
                    part.getPersistedState().put(MEMENTO_KEY, writer.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (descriptor == null) {
                try {
                    XMLMemento createReadRoot = XMLMemento.createReadRoot(new StringReader((String)this.getModel().getPersistedState().get(MEMENTO_KEY)));
                    IEditorRegistry registry = this.getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
                    this.descriptorId = createReadRoot.getString("id");
                    this.descriptor = (EditorDescriptor)registry.findEditor(this.descriptorId);
                    if (this.descriptor == null) {
                        this.setImageDescriptor(ImageDescriptor.getMissingImageDescriptor());
                        break block8;
                    }
                    this.setImageDescriptor(this.descriptor.getImageDescriptor());
                }
                catch (WorkbenchException e) {
                    WorkbenchPlugin.log((Throwable)((Object)e));
                }
            } else {
                this.descriptorId = this.descriptor.getId();
                this.setImageDescriptor(this.descriptor.getImageDescriptor());
            }
        }
    }

    public EditorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getId() {
        return this.descriptor.getId();
    }

    public String getFactoryId() {
        IEditorPart editor = this.getEditor(false);
        if (editor != null) {
            IPersistableElement persistable = editor.getEditorInput().getPersistable();
            if (persistable != null) {
                return persistable.getFactoryId();
            }
            return null;
        }
        return this.factoryId;
    }

    public String getName() {
        return this.input.getName();
    }

    private IEditorInput restoreInput(IMemento editorMem) throws PartInitException {
        IMemento inputMem = editorMem.getChild("input");
        String factoryID = null;
        if (inputMem != null) {
            factoryID = inputMem.getString("factoryID");
        }
        if (factoryID == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_no_input_factory_ID, (Object)this.getId(), (Object)this.getName()));
        }
        IAdaptable input = null;
        IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
        if (factory == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_bad_element_factory, (Object[])new Object[]{factoryID, this.getId(), this.getName()}));
        }
        input = factory.createElement(inputMem);
        if (input == null) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_create_element_returned_null, (Object[])new Object[]{factoryID, this.getId(), this.getName()}));
        }
        if (!(input instanceof IEditorInput)) {
            throw new PartInitException(NLS.bind((String)WorkbenchMessages.EditorManager_wrong_createElement_result, (Object[])new Object[]{factoryID, this.getId(), this.getName()}));
        }
        return (IEditorInput)input;
    }

    public IEditorPart getEditor(boolean restore) {
        return (IEditorPart)this.getPart(restore);
    }

    public boolean isPinned() {
        return false;
    }

    public IEditorInput getEditorInput() throws PartInitException {
        if (this.input == null) {
            try {
                XMLMemento createReadRoot = XMLMemento.createReadRoot(new StringReader((String)this.getModel().getPersistedState().get(MEMENTO_KEY)));
                this.input = this.restoreInput(createReadRoot);
            }
            catch (WorkbenchException e) {
                throw new PartInitException(e.getStatus());
            }
        }
        return this.input;
    }

    public IWorkbenchPart createPart() throws PartInitException {
        try {
            if (this.descriptor == null) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, NLS.bind((String)WorkbenchMessages.EditorManager_missing_editor_descriptor, (Object)this.descriptorId));
                IEditorRegistry registry = this.getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
                this.descriptor = (EditorDescriptor)registry.findEditor("org.eclipse.ui.internal.emptyEditorTab");
                return new ErrorEditorPart((IStatus)status);
            }
            if (this.descriptor.getId().equals("org.eclipse.ui.systemInPlaceEditor")) {
                IEditorPart part = ComponentSupport.getSystemInPlaceEditor();
                if (part == null) {
                    throw new PartInitException(WorkbenchMessages.EditorManager_no_in_place_support);
                }
                return part;
            }
            return this.descriptor.createEditor();
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            throw new PartInitException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, status.getCode(), status.getMessage(), status.getException()));
        }
    }

    public void initialize(IWorkbenchPart part) throws PartInitException {
        IConfigurationElement element = this.descriptor.getConfigurationElement();
        this.editorSite = new EditorSite(this.getModel(), part, element);
        if (element == null) {
            this.editorSite.setExtensionId(this.descriptor.getId());
        }
        ContextInjectionFactory.inject((Object)this.editorSite, (IEclipseContext)this.getModel().getContext());
        this.editorSite.setActionBars(EditorReference.createEditorActionBars((WorkbenchPage)this.getPage(), this.descriptor, this.editorSite));
        ((IEditorPart)part).init(this.editorSite, this.getEditorInput());
    }

    public PartSite getSite() {
        return this.editorSite;
    }

    private static EditorActionBars createEditorActionBars(WorkbenchPage page, EditorDescriptor desc, IEditorSite site) {
        EditorActionBuilder builder;
        String type = desc.getId();
        EditorActionBars actionBars = actionCache.get(type);
        if (actionBars != null) {
            actionBars.addRef();
            return actionBars;
        }
        actionBars = new EditorActionBars(page, site, type);
        actionBars.addRef();
        actionCache.put(type, actionBars);
        IEditorActionBarContributor contr = desc.createActionBarContributor();
        if (contr != null) {
            actionBars.setEditorContributor(contr);
            contr.init(actionBars, page);
        }
        if ((contr = (builder = new EditorActionBuilder()).readActionExtensions(desc)) != null) {
            actionBars.setExtensionContributor(contr);
            contr.init(actionBars, page);
        }
        return actionBars;
    }

    public static void disposeEditorActionBars(EditorActionBars actionBars) {
        actionBars.removeRef();
        if (actionBars.getRef() <= 0) {
            String type = actionBars.getEditorType();
            actionCache.remove(type);
            ICoolBarManager2 coolBar = (ICoolBarManager2)((WorkbenchWindow)actionBars.getPage().getWorkbenchWindow()).getCoolBarManager2();
            if (coolBar != null) {
                coolBar.refresh();
            }
            actionBars.dispose();
        }
    }
}

