/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ArgumentsFromContainerSelectionDialog
extends TrayDialog {
    private CheckboxTreeViewer fTree;
    private Button fSelectAllButton;
    private Button fDeselectAllButton;
    private Map fAllArguments;
    private String[] fArguments;
    private ITargetDefinition fTarget;

    public ArgumentsFromContainerSelectionDialog(Shell shell, ITargetDefinition target) {
        super(shell);
        this.fTarget = target;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ArgumentsFromContainerSelectionDialog_0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        IBundleContainer[] containers = this.fTarget.getBundleContainers();
        boolean foundArguments = false;
        if (containers != null) {
            this.fAllArguments = new HashMap(containers.length);
            int i = 0;
            while (i < containers.length) {
                String[] args = containers[i].getVMArguments();
                if (args != null) {
                    if (args.length > 0) {
                        this.fAllArguments.put(containers[i], args);
                        foundArguments = true;
                    } else {
                        this.fAllArguments.put(containers[i], new Object[]{new Status(4, PDEPlugin.getPluginId(), Messages.ArgumentsFromContainerSelectionDialog_1)});
                    }
                }
                ++i;
            }
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.import_arguments_dialog");
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 10, 10);
        ((GridLayout)comp.getLayout()).verticalSpacing = 10;
        Label infoLabel = SWTFactory.createLabel(comp, Messages.ArgumentsFromContainerSelectionDialog_2, 1);
        Composite treeComp = SWTFactory.createComposite(comp, 2, 1, 1808, 0, 0);
        this.fTree = new CheckboxTreeViewer(treeComp, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTree.setLabelProvider((IBaseLabelProvider)new StyledBundleLabelProvider(true, false));
        this.fTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object element) {
                Object args;
                if (element instanceof IBundleContainer && (args = ArgumentsFromContainerSelectionDialog.this.fAllArguments.get(element)) != null) {
                    return (Object[])args;
                }
                return new Object[0];
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object element) {
                if (element instanceof Map) {
                    return ((Map)element).keySet().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ArgumentsFromContainerSelectionDialog.this.updateCheckState(event.getElement());
                ArgumentsFromContainerSelectionDialog.this.updateOKButton();
            }
        });
        this.fTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty()) {
                    Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    ArgumentsFromContainerSelectionDialog.this.fTree.setChecked(selected, !ArgumentsFromContainerSelectionDialog.this.fTree.getChecked(selected));
                    ArgumentsFromContainerSelectionDialog.this.updateCheckState(selected);
                    ArgumentsFromContainerSelectionDialog.this.updateOKButton();
                }
            }
        });
        this.fTree.setAutoExpandLevel(-1);
        Composite buttonComp = SWTFactory.createComposite(treeComp, 1, 1, 1040, 0, 0);
        this.fSelectAllButton = SWTFactory.createPushButton(buttonComp, Messages.ArgumentsFromContainerSelectionDialog_3, null);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentsFromContainerSelectionDialog.this.fTree.setAllChecked(true);
                ArgumentsFromContainerSelectionDialog.this.updateOKButton();
            }
        });
        this.fDeselectAllButton = SWTFactory.createPushButton(buttonComp, Messages.ArgumentsFromContainerSelectionDialog_4, null);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArgumentsFromContainerSelectionDialog.this.fTree.setAllChecked(false);
                ArgumentsFromContainerSelectionDialog.this.updateOKButton();
            }
        });
        if (foundArguments) {
            this.fTree.setInput((Object)this.fAllArguments);
        } else {
            this.fTree.getControl().setEnabled(false);
            this.fSelectAllButton.setEnabled(false);
            this.fDeselectAllButton.setEnabled(false);
            infoLabel.setText(Messages.ArgumentsFromContainerSelectionDialog_5);
        }
        return comp;
    }

    protected boolean isResizable() {
        return true;
    }

    private void updateCheckState(Object element) {
        if (element instanceof IBundleContainer) {
            this.fTree.setSubtreeChecked(element, this.fTree.getChecked(element));
        } else {
            TreeItem[] containers = this.fTree.getTree().getItems();
            int i = 0;
            while (i < containers.length) {
                TreeItem[] arguments = containers[i].getItems();
                int checked = 0;
                int j = 0;
                while (j < arguments.length) {
                    if (arguments[j].getChecked()) {
                        ++checked;
                    }
                    ++j;
                }
                if (checked == 0) {
                    containers[i].setChecked(false);
                    containers[i].setGrayed(false);
                } else if (arguments.length > checked) {
                    containers[i].setChecked(true);
                    containers[i].setGrayed(true);
                } else {
                    containers[i].setChecked(true);
                    containers[i].setGrayed(false);
                }
                ++i;
            }
        }
    }

    private void updateOKButton() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            boolean ok = false;
            Object[] checked = this.fTree.getCheckedElements();
            int i = 0;
            while (i < checked.length) {
                if (checked[i] instanceof String) {
                    ok = true;
                    break;
                }
                ++i;
            }
            okButton.setEnabled(ok);
        }
    }

    public String[] getSelectedArguments() {
        return this.fArguments;
    }

    protected void okPressed() {
        ArrayList<String> arguments = new ArrayList<String>();
        Object[] checked = this.fTree.getCheckedElements();
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof String) {
                String arg = ((String)checked[i]).trim();
                if (arg.indexOf(32) > 0) {
                    arg = "\"" + arg + "\"";
                }
                arguments.add(arg);
            }
            ++i;
        }
        this.fArguments = arguments.toArray(new String[arguments.size()]);
        super.okPressed();
    }
}

