/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class TrimContributionHandler {
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    private Map<MTrimBar, List<MTrimElement>> trimContributions = new WeakHashMap<MTrimBar, List<MTrimElement>>();
    private EventHandler trimWidgetHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MTrimBar) {
                Object value = event.getProperty("NewValue");
                if (value == null) {
                    TrimContributionHandler.this.cleanUp((MTrimBar)element);
                } else {
                    TrimContributionHandler.this.contribute((MTrimBar)element);
                }
            }
        }
    };

    @PostConstruct
    void postConstruct() {
        this.broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/ui/UIElement", "widget"), this.trimWidgetHandler);
    }

    @PreDestroy
    void preDestroy() {
        this.broker.unsubscribe(this.trimWidgetHandler);
    }

    private void contribute(MTrimBar trimBar) {
        this.contribute(trimBar.getElementId(), trimBar);
    }

    private void contribute(String parentId, MTrimBar trimBar) {
        ArrayList<MTrimContribution> applicableContributions = new ArrayList<MTrimContribution>();
        for (MTrimContribution contribution : this.application.getTrimContributions()) {
            String targetId = contribution.getParentId();
            if (targetId == null || !targetId.equals(parentId)) continue;
            applicableContributions.add(contribution);
        }
        List<MTrimElement> contributions = ContributionsAnalyzer.addTrimBarContributions(trimBar, applicableContributions);
        this.trimContributions.put(trimBar, contributions);
    }

    private void cleanUp(MTrimBar trimBar) {
        List<MTrimElement> contributions = this.trimContributions.get(trimBar);
        if (contributions != null) {
            trimBar.getChildren().removeAll(contributions);
        }
    }
}

