/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.cleanupaddon;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CleanupAddon {
    @Inject
    protected IEventBroker eventBroker;
    Shell limbo;
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            String eventType = (String)event.getProperty("EventType");
            if ("REMOVE".equals(eventType)) {
                final MElementContainer container = (MElementContainer)changedObj;
                MElementContainer containerParent = container.getParent();
                if (container instanceof MApplication || container instanceof MPerspectiveStack || container instanceof MMenuElement || container instanceof MTrimBar) {
                    return;
                }
                if (container instanceof MWindow && containerParent instanceof MApplication) {
                    return;
                }
                Display display = Display.getCurrent();
                if (display != null && !container.getTags().contains("EditorStack")) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            boolean hide = true;
                            for (MUIElement child : container.getChildren()) {
                                if (!child.isToBeRendered()) continue;
                                hide = false;
                                break;
                            }
                            if (hide) {
                                container.setToBeRendered(false);
                            }
                            if (container.getChildren().size() == 0) {
                                MElementContainer parent = container.getParent();
                                if (parent != null) {
                                    parent.getChildren().remove(container);
                                } else if (container instanceof MWindow) {
                                    MUIElement eParent = (MUIElement)((EObjectImpl)container).eContainer();
                                    if (eParent instanceof MPerspective) {
                                        ((MPerspective)eParent).getWindows().remove(container);
                                    } else if (eParent instanceof MWindow) {
                                        ((MWindow)eParent).getWindows().remove(container);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }
    };
    private EventHandler visibilityChangeHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
            if (changedObj instanceof MTrimBar) {
                return;
            }
            if (changedObj.getWidget() instanceof Shell) {
                ((Shell)changedObj.getWidget()).setVisible(changedObj.isVisible());
            } else if (changedObj.getWidget() instanceof Control) {
                Control ctrl = (Control)changedObj.getWidget();
                MElementContainer parent = changedObj.getParent();
                if (changedObj.isVisible()) {
                    if (parent.getRenderer() != null) {
                        Object myParent = ((AbstractPartRenderer)parent.getRenderer()).getUIContainer(changedObj);
                        if (myParent instanceof Composite) {
                            Composite parentComp = (Composite)myParent;
                            ctrl.setParent(parentComp);
                            Control prevControl = null;
                            for (MUIElement childME : parent.getChildren()) {
                                if (childME == changedObj) break;
                                if (!(childME.getWidget() instanceof Control) || !childME.isVisible()) continue;
                                prevControl = (Control)childME.getWidget();
                            }
                            if (prevControl != null) {
                                ctrl.moveBelow(prevControl);
                            } else {
                                ctrl.moveAbove(null);
                            }
                            ctrl.getShell().layout(new Control[]{ctrl}, 4);
                        }
                        if (!parent.isVisible()) {
                            parent.setVisible(true);
                        }
                    }
                } else {
                    if (CleanupAddon.this.limbo == null) {
                        CleanupAddon.this.limbo = new Shell(ctrl.getDisplay(), 0);
                        CleanupAddon.this.limbo.setLayout(new Layout(){

                            protected void layout(Composite composite, boolean flushCache) {
                            }

                            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                                return new Point(600, 400);
                            }
                        });
                        CleanupAddon.this.limbo.setVisible(false);
                    }
                    Composite curParent = ctrl.getParent();
                    ctrl.setParent((Composite)CleanupAddon.this.limbo);
                    curParent.layout(true);
                    if (curParent.getShell() != curParent) {
                        curParent.getShell().layout(new Control[]{curParent}, 4);
                    }
                    boolean makeInvisible = true;
                    for (MUIElement kid : parent.getChildren()) {
                        if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                        makeInvisible = false;
                        break;
                    }
                    if (makeInvisible) {
                        parent.setVisible(false);
                    }
                }
            }
        }
    };
    private EventHandler renderingChangeHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
            MElementContainer container = null;
            container = changedObj.getCurSharedRef() != null ? changedObj.getCurSharedRef().getParent() : changedObj.getParent();
            if (container == null) {
                return;
            }
            MElementContainer containerElement = container;
            if (containerElement instanceof MWindow && containerElement.getParent() != null) {
                return;
            }
            if (containerElement.getTags().contains("EditorStack") || containerElement instanceof MPerspectiveStack) {
                return;
            }
            Boolean toBeRendered = (Boolean)event.getProperty("NewValue");
            if (toBeRendered.booleanValue()) {
                if (!container.isToBeRendered()) {
                    container.setToBeRendered(true);
                }
            } else {
                int visCount = 0;
                for (MUIElement element : container.getChildren()) {
                    if (!element.isToBeRendered()) continue;
                    ++visCount;
                }
                if (visCount == 0) {
                    container.setToBeRendered(false);
                }
            }
        }
    };

    @PostConstruct
    void init(IEclipseContext context) {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.renderingChangeHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"visible"), this.visibilityChangeHandler);
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.renderingChangeHandler);
        this.eventBroker.unsubscribe(this.visibilityChangeHandler);
    }
}

