/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimBarLayout
extends Layout {
    private boolean horizontal;
    public int marginLeft = 0;
    public int marginRight = 0;
    public int marginTop = 0;
    public int marginBottom = 0;
    public int wrapSpacing = 0;

    public TrimBarLayout(boolean horizontal) {
        this.horizontal = horizontal;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] kids;
        int totalSpace = this.horizontal ? wHint - (this.marginLeft + this.marginRight) : hHint - (this.marginTop + this.marginBottom);
        int totalMinor = this.horizontal ? this.marginTop + this.marginBottom : this.marginLeft + this.marginRight;
        int maxMinor = 0;
        int spaceLeft = totalSpace;
        int extraLines = 0;
        Control[] controlArray = kids = composite.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            if (!this.isSpacer(ctrl)) {
                int minor;
                ctrl.pack(true);
                Point ctrlSize = ctrl.getSize();
                int major = this.horizontal ? ctrlSize.x : ctrlSize.y;
                int n3 = minor = this.horizontal ? ctrlSize.y : ctrlSize.x;
                if (major <= spaceLeft) {
                    if (minor > maxMinor) {
                        maxMinor = minor;
                    }
                    spaceLeft -= major;
                } else {
                    ++extraLines;
                    totalMinor += maxMinor;
                    maxMinor = minor;
                    spaceLeft = totalSpace - major;
                }
            }
            ++n2;
        }
        totalMinor += maxMinor;
        if ((totalMinor += extraLines * this.wrapSpacing) == 0) {
            totalMinor = 1;
        }
        return this.horizontal ? new Point(wHint, totalMinor) : new Point(totalMinor, hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        composite.setRedraw(false);
        try {
            Rectangle bounds = composite.getBounds();
            int totalSpace = this.horizontal ? bounds.width - (this.marginLeft + this.marginRight) : bounds.height - (this.marginTop + this.marginBottom);
            ArrayList<Control> curLine = new ArrayList<Control>();
            ArrayList<Control> spacers = new ArrayList<Control>();
            int curMinor = this.horizontal ? this.marginTop : this.marginLeft;
            int maxMinor = 0;
            int spaceLeft = totalSpace;
            Control[] kids = composite.getChildren();
            Control curSpacer = null;
            Control[] controlArray = kids;
            int n = kids.length;
            int n2 = 0;
            while (n2 < n) {
                Control ctrl = controlArray[n2];
                if (this.isSpacer(ctrl)) {
                    curSpacer = ctrl;
                } else {
                    int minor;
                    Point ctrlSize = ctrl.getSize();
                    int major = this.horizontal ? ctrlSize.x : ctrlSize.y;
                    int n3 = minor = this.horizontal ? ctrlSize.y : ctrlSize.x;
                    if (major <= spaceLeft) {
                        if (minor > maxMinor) {
                            maxMinor = minor;
                        }
                        spaceLeft -= major;
                        if (curSpacer != null) {
                            spacers.add(curSpacer);
                            curLine.add(curSpacer);
                        }
                        curLine.add(ctrl);
                    } else {
                        this.tileLine(curLine, spacers, curMinor, maxMinor, spaceLeft);
                        spaceLeft = totalSpace;
                        curMinor += maxMinor + this.wrapSpacing;
                        maxMinor = 0;
                        spacers.clear();
                        curLine.clear();
                        if (curSpacer != null) {
                            spacers.add(curSpacer);
                            curLine.add(curSpacer);
                        }
                        curLine.add(ctrl);
                        spaceLeft -= major;
                    }
                    curSpacer = null;
                }
                ++n2;
            }
            this.tileLine(curLine, spacers, curMinor, maxMinor, spaceLeft);
        }
        finally {
            composite.setRedraw(true);
        }
    }

    private void tileLine(List<Control> curLine, List<Control> spacers, int curMinor, int maxMinor, int spaceLeft) {
        int[] spacerWidths = new int[spacers.size()];
        if (spacers.size() > 0) {
            int spacerWidth = spaceLeft / spacers.size();
            int count = 0;
            while (count < spacers.size()) {
                if (spaceLeft < spacerWidth) {
                    spacerWidth = spaceLeft;
                }
                spaceLeft -= spacerWidth;
                spacerWidths[count] = spacerWidth;
                ++count;
            }
        }
        int majorPos = this.horizontal ? this.marginLeft : this.marginTop;
        int spacerCount = 0;
        for (Control toTile : curLine) {
            Point ctrlSize = toTile.getSize();
            int ctrlMinor = this.horizontal ? ctrlSize.y : ctrlSize.x;
            int minorOffset = 0;
            if (ctrlMinor < maxMinor) {
                minorOffset = (maxMinor - ctrlMinor) / 2;
            }
            if (this.horizontal) {
                toTile.setLocation(majorPos, curMinor + minorOffset);
            } else {
                toTile.setLocation(curMinor + minorOffset, majorPos);
            }
            if (this.isSpacer(toTile)) {
                majorPos += spacerWidths[spacerCount++];
                continue;
            }
            int major = this.horizontal ? toTile.getSize().x : toTile.getSize().y;
            majorPos += major;
        }
    }

    private boolean isSpacer(Control ctrl) {
        MUIElement element = (MUIElement)ctrl.getData("modelElement");
        return element != null && element.getTags().contains("stretch");
    }
}

