/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MAdvancedFactory;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelServiceImpl
implements EModelService {
    private boolean match(MUIElement element, String id, Class clazz, List<String> tagsToMatch) {
        if (id != null && !id.equals(element.getElementId())) {
            return false;
        }
        if (clazz != null && !clazz.isInstance(element)) {
            return false;
        }
        if (tagsToMatch != null) {
            List elementTags = element.getTags();
            for (String tag : tagsToMatch) {
                if (elementTags.contains(tag)) continue;
                return false;
            }
        }
        return true;
    }

    private <T> void findElementsRecursive(MUIElement searchRoot, String id, Class<? extends T> type, List<String> tagsToMatch, List<T> elements) {
        if (this.match(searchRoot, id, type, tagsToMatch) && !elements.contains(searchRoot)) {
            elements.add(searchRoot);
        }
        if (searchRoot instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)searchRoot;
            List children = container.getChildren();
            for (MUIElement child : children) {
                this.findElementsRecursive(child, id, type, tagsToMatch, elements);
            }
        }
        if (searchRoot instanceof MTrimmedWindow) {
            MTrimmedWindow tw = (MTrimmedWindow)searchRoot;
            for (MTrimBar bar : tw.getTrimBars()) {
                this.findElementsRecursive((MUIElement)bar, id, type, tagsToMatch, elements);
            }
        }
        if (searchRoot instanceof MWindow) {
            MWindow window = (MWindow)searchRoot;
            for (MWindow dw : window.getWindows()) {
                this.findElementsRecursive((MUIElement)dw, id, type, tagsToMatch, elements);
            }
        }
        if (searchRoot instanceof MPerspective) {
            MPerspective persp = (MPerspective)searchRoot;
            for (MWindow dw : persp.getWindows()) {
                this.findElementsRecursive((MUIElement)dw, id, type, tagsToMatch, elements);
            }
        }
        if (searchRoot instanceof MPlaceholder) {
            MPlaceholder ph = (MPlaceholder)searchRoot;
            this.findElementsRecursive(ph.getRef(), id, type, tagsToMatch, elements);
        }
    }

    @Override
    public <T> List<T> findElements(MUIElement searchRoot, String id, Class<T> clazz, List<String> tagsToMatch) {
        ArrayList elements = new ArrayList();
        this.findElementsRecursive(searchRoot, id, clazz, tagsToMatch, elements);
        return elements;
    }

    @Override
    public MUIElement find(String id, MUIElement searchRoot) {
        if (id == null || id.length() == 0) {
            return null;
        }
        List elements = this.findElements(searchRoot, id, null, null);
        if (elements.size() > 0) {
            return (MUIElement)elements.get(0);
        }
        return null;
    }

    @Override
    public IEclipseContext getContainingContext(MUIElement element) {
        Object curParent = null;
        curParent = element.getCurSharedRef() != null ? element.getCurSharedRef().getParent() : (MUIElement)((EObject)element).eContainer();
        while (curParent != null) {
            if (curParent instanceof MContext) {
                return ((MContext)curParent).getContext();
            }
            curParent = curParent.getCurSharedRef() != null ? curParent.getCurSharedRef().getParent() : (MUIElement)((EObject)curParent).eContainer();
        }
        return null;
    }

    @Override
    public void bringToTop(MWindow window, MUIElement element) {
        MPlaceholder ph;
        MElementContainer parent;
        if (element instanceof MApplication) {
            return;
        }
        if (element instanceof MPartStack && !element.isVisible()) {
            MToolControl trimCtrl;
            MWindow window1 = this.getTopLevelWindowFor(element);
            String trimId = String.valueOf(element.getElementId()) + "(minimized)";
            MPerspective persp = this.getPerspectiveFor(element);
            if (persp != null) {
                trimId = String.valueOf(element.getElementId()) + '(' + persp.getElementId() + ')';
            }
            if ((trimCtrl = (MToolControl)this.find(trimId, (MUIElement)window1)) != null) {
                IEclipseContext ctxt = EclipseContextFactory.create();
                ctxt.set("show", (Object)true);
                ContextInjectionFactory.invoke((Object)trimCtrl.getObject(), Execute.class, (IEclipseContext)ctxt);
            }
        }
        if ((parent = element.getParent()) == null && (ph = this.findPlaceholderFor(window, element)) != null) {
            element = ph;
            parent = element.getParent();
        }
        if (parent != null) {
            if (!element.isToBeRendered()) {
                element.setToBeRendered(true);
            }
            parent.setSelectedElement(element);
            this.bringToTop(window, (MUIElement)parent);
        }
    }

    @Override
    public MPlaceholder findPlaceholderFor(MWindow window, MUIElement element) {
        List<MPerspectiveStack> psList = this.findElements((MUIElement)window, null, MPerspectiveStack.class, null);
        if (psList.size() != 1) {
            return null;
        }
        MPerspectiveStack pStack = psList.get(0);
        MPerspective persp = (MPerspective)pStack.getSelectedElement();
        if (persp == null) {
            return null;
        }
        List<MPlaceholder> phList = this.findElements((MUIElement)persp, null, MPlaceholder.class, null);
        for (MPlaceholder ph : phList) {
            if (ph.getRef() != element) continue;
            return ph;
        }
        return null;
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent) {
        this.move(element, newParent, -1, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, boolean leavePlaceholder) {
        this.move(element, newParent, -1, leavePlaceholder);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index) {
        this.move(element, newParent, index, false);
    }

    @Override
    public void move(MUIElement element, MElementContainer<MUIElement> newParent, int index, boolean leavePlaceholder) {
        MElementContainer curParent = element.getParent();
        int curIndex = curParent.getChildren().indexOf(element);
        newParent.getChildren().add(index, element);
        if (leavePlaceholder) {
            MPlaceholder ph = MAdvancedFactory.INSTANCE.createPlaceholder();
            ph.setRef(element);
            curParent.getChildren().add(curIndex, ph);
        }
    }

    public void swap(MPlaceholder placeholder) {
        MUIElement element = placeholder.getRef();
        MElementContainer elementParent = element.getParent();
        int elementIndex = elementParent.getChildren().indexOf(element);
        MElementContainer phParent = placeholder.getParent();
        int phIndex = phParent.getChildren().indexOf(placeholder);
        elementParent.getChildren().remove(element);
        phParent.getChildren().remove(placeholder);
        boolean onTop = element.isOnTop();
        boolean vis = element.isVisible();
        boolean tbr = element.isToBeRendered();
        element.setOnTop(placeholder.isOnTop());
        element.setVisible(placeholder.isVisible());
        element.setToBeRendered(placeholder.isToBeRendered());
        placeholder.setOnTop(onTop);
        placeholder.setVisible(vis);
        placeholder.setToBeRendered(tbr);
        elementParent.getChildren().add(elementIndex, placeholder);
        phParent.getChildren().add(phIndex, element);
    }

    private void combine(MPartSashContainerElement toInsert, MPartSashContainerElement relTo, MPartSashContainer newSash, boolean newFirst, int ratio) {
        MElementContainer curParent = relTo.getParent();
        int index = curParent.getChildren().indexOf(relTo);
        curParent.getChildren().remove(relTo);
        if (newFirst) {
            newSash.getChildren().add(toInsert);
            newSash.getChildren().add(relTo);
        } else {
            newSash.getChildren().add(relTo);
            newSash.getChildren().add(toInsert);
        }
        toInsert.setContainerData(Integer.toString(ratio));
        relTo.setContainerData(Integer.toString(100 - ratio));
        curParent.getChildren().add(index, newSash);
    }

    @Override
    public void insert(MPartSashContainerElement toInsert, MPartSashContainerElement relTo, int where, int ratio) {
        if (toInsert == null || relTo == null) {
            return;
        }
        if (ratio == 0) {
            ratio = 10;
        }
        if (ratio > 100) {
            ratio = 90;
        }
        boolean newFirst = where == 0 || where == 2;
        MElementContainer insertRoot = relTo.getParent();
        while (insertRoot != null && !(insertRoot instanceof MWindow) && !(insertRoot instanceof MPartSashContainer)) {
            relTo = (MPartSashContainerElement)insertRoot;
            insertRoot = insertRoot.getParent();
        }
        if (insertRoot instanceof MWindow) {
            MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
            newSash.setHorizontal(where == 2 || where == 3);
            this.combine(toInsert, relTo, newSash, newFirst, ratio);
        } else if (insertRoot instanceof MGenericTile) {
            MGenericTile curTile = (MGenericTile)insertRoot;
            if (curTile.isHorizontal() && (where == 0 || where == 1)) {
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(false);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, newFirst, ratio);
            } else if (!(curTile.isHorizontal() || where != 2 && where != 3)) {
                MPartSashContainer newSash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
                newSash.setHorizontal(true);
                newSash.setContainerData(relTo.getContainerData());
                this.combine(toInsert, relTo, newSash, newFirst, ratio);
            } else {
                int relToIndex = relTo.getParent().getChildren().indexOf(relTo);
                if (newFirst) {
                    curTile.getChildren().add(relToIndex, toInsert);
                } else {
                    curTile.getChildren().add(relToIndex + 1, toInsert);
                }
                int relToWeight = 100;
                if (relTo.getContainerData() != null) {
                    try {
                        relToWeight = Integer.parseInt(relTo.getContainerData());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                int toInsertWeight = (int)((double)ratio / 100.0 * (double)relToWeight + 0.5);
                relTo.setContainerData(Integer.toString(relToWeight -= toInsertWeight));
                toInsert.setContainerData(Integer.toString(toInsertWeight));
            }
        }
    }

    @Override
    public void detach(MPartSashContainerElement element, int x, int y, int width, int height) {
        MElementContainer curParent = element.getParent();
        while (curParent != null && !(curParent instanceof MPerspective) && !(curParent instanceof MWindow)) {
            curParent = curParent.getParent();
        }
        if (curParent == null) {
            return;
        }
        MTrimmedWindow newWindow = BasicFactoryImpl.INSTANCE.createTrimmedWindow();
        newWindow.setX(x);
        newWindow.setY(y);
        newWindow.setWidth(width);
        newWindow.setHeight(height);
        element.getParent().getChildren().remove(element);
        MWindowElement uiRoot = this.wrapElementForWindow(element);
        newWindow.getChildren().add(uiRoot);
        if (curParent instanceof MPerspective) {
            MPerspective persp = (MPerspective)curParent;
            persp.getWindows().add(newWindow);
            MWindow window = this.getTopLevelWindowFor((MUIElement)persp);
            IPresentationEngine renderingEngine = (IPresentationEngine)persp.getContext().get(IPresentationEngine.class);
            Object foo = renderingEngine.createGui((MUIElement)newWindow, window.getWidget());
            if (foo != null) {
                System.out.println(foo.toString());
            }
        } else if (curParent instanceof MWindow) {
            ((MWindow)curParent).getWindows().add(newWindow);
        }
    }

    private MWindowElement wrapElementForWindow(MPartSashContainerElement element) {
        MUIElement ref;
        if (element instanceof MWindowElement) {
            return (MWindowElement)element;
        }
        if (element instanceof MPlaceholder && (ref = ((MPlaceholder)element).getRef()) instanceof MPart) {
            MPartStack newPS = MBasicFactory.INSTANCE.createPartStack();
            newPS.getChildren().add((MPlaceholder)element);
            return newPS;
        }
        return null;
    }

    @Override
    public MTrimBar getTrim(MTrimmedWindow window, SideValue sv) {
        List bars = window.getTrimBars();
        for (MTrimBar bar : bars) {
            if (bar.getSide() != sv) continue;
            return bar;
        }
        MTrimBar newBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        newBar.setSide(sv);
        window.getTrimBars().add(newBar);
        return newBar;
    }

    @Override
    public MWindow getTopLevelWindowFor(MUIElement element) {
        EObjectImpl eObj = (EObjectImpl)element;
        while (!(eObj.eContainer() instanceof MApplication)) {
            eObj = (EObjectImpl)eObj.eContainer();
        }
        if (eObj instanceof MWindow) {
            return (MWindow)eObj;
        }
        return null;
    }

    @Override
    public MPerspective getPerspectiveFor(MUIElement element) {
        EObjectImpl eObj = (EObjectImpl)element;
        while (!(eObj.eContainer() instanceof MApplication) && !(eObj.eContainer() instanceof MPerspectiveStack)) {
            eObj = (EObjectImpl)eObj.eContainer();
        }
        if (eObj instanceof MPerspective) {
            return (MPerspective)eObj;
        }
        return null;
    }
}

