/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ToolBarContributionHandler {
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    private Map<MToolBar, List<MToolBarElement>> toolBarContributions = new WeakHashMap<MToolBar, List<MToolBarElement>>();
    private EventHandler partObjectHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object element;
            Object value = event.getProperty("NewValue");
            if (value != null && (element = event.getProperty("ChangedElement")) instanceof MPart) {
                ToolBarContributionHandler.this.contribute((MPart)element);
            }
        }
    };
    private EventHandler partWidgetHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object element;
            Object value = event.getProperty("NewValue");
            if (value == null && (element = event.getProperty("ChangedElement")) instanceof MPart) {
                ToolBarContributionHandler.this.cleanUp((MPart)element);
            }
        }
    };

    @PostConstruct
    void postConstruct() {
        this.broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/application/Contribution", "object"), this.partObjectHandler);
        this.broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/ui/UIElement", "widget"), this.partWidgetHandler);
    }

    @PreDestroy
    void preDestroy() {
        this.broker.unsubscribe(this.partObjectHandler);
        this.broker.unsubscribe(this.partWidgetHandler);
    }

    private void contribute(MPart part) {
        MToolBar toolBar = part.getToolbar();
        if (toolBar != null) {
            this.contribute(part.getElementId(), toolBar);
        }
    }

    private void cleanUp(MPart part) {
        List<MToolBarElement> contributions;
        MToolBar toolBar = part.getToolbar();
        if (toolBar != null && (contributions = this.toolBarContributions.get(toolBar)) != null) {
            toolBar.getChildren().removeAll(contributions);
        }
    }

    private void contribute(String parentId, MToolBar toolBar) {
        ArrayList<MToolBarContribution> applicableContributions = new ArrayList<MToolBarContribution>();
        for (MToolBarContribution contribution : this.application.getToolBarContributions()) {
            String targetId = contribution.getParentId();
            if (targetId == null || !targetId.equals(parentId)) continue;
            applicableContributions.add(contribution);
        }
        List<MToolBarElement> contributions = ContributionsAnalyzer.addToolBarContributions(toolBar, applicableContributions);
        this.toolBarContributions.put(toolBar, contributions);
    }
}

