/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.ExportTargetMetadata;

public class ExportActiveTargetJob
extends Job {
    private URI fDestination;
    private boolean fclearDestinationDirectory = false;

    public ExportActiveTargetJob(URI destination, boolean clearDestinationDirectory) {
        super("Export Current Target Definition Job");
        this.fDestination = destination;
        this.fclearDestinationDirectory = clearDestinationDirectory;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        if (!fileSystem.canWrite()) {
            return new Status(4, PDEPlugin.getPluginId(), "Destination directory not writable.");
        }
        IFileStore destination = fileSystem.getStore(this.fDestination);
        FeatureModelManager featureManager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] featureModels = featureManager.getModels();
        IPluginModelBase[] pluginModels = PluginRegistry.getExternalModels();
        IFileStore featureDir = destination.getChild("features");
        IFileStore pluginDir = destination.getChild("plugins");
        IFileStore metadataXML = destination.getChild("content.xml");
        IFileStore metadataJAR = destination.getChild("content.jar");
        int totalWork = featureModels.length + pluginModels.length;
        try {
            IFeatureModel model;
            monitor.beginTask(PDEUIMessages.ExportTargetDefinition_task, totalWork);
            if (this.fclearDestinationDirectory) {
                monitor.subTask(PDEUIMessages.ExportTargetDeleteOldData);
            }
            IProvisioningAgent agent = (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
            ExportTargetMetadata component = null;
            if (agent != null) {
                component = new ExportTargetMetadata(agent);
            }
            try {
                if (this.fclearDestinationDirectory) {
                    if (component != null) {
                        component.clearExporedRepository(this.fDestination);
                    }
                    if (featureDir.fetchInfo().exists()) {
                        featureDir.delete(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (pluginDir.fetchInfo().exists()) {
                        pluginDir.delete(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (metadataJAR.fetchInfo().exists()) {
                        metadataJAR.delete(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (metadataXML.fetchInfo().exists()) {
                        metadataXML.delete(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                if (!featureDir.fetchInfo().exists()) {
                    featureDir.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
                }
                if (!pluginDir.fetchInfo().exists()) {
                    pluginDir.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e1) {
                Status status = new Status(4, PDEPlugin.getPluginId(), "Failed to create destination directory.", (Throwable)e1);
                monitor.done();
                return status;
            }
            monitor.subTask(PDEUIMessages.ExportTargetExportFeatures);
            int i = 0;
            while (i < featureModels.length) {
                model = featureModels[i];
                if (model.isEnabled() && model instanceof ExternalFeatureModel) {
                    this.copy(model.getInstallLocation(), featureDir, fileSystem, monitor);
                }
                ++i;
            }
            monitor.subTask(PDEUIMessages.ExportTargetExportPlugins);
            i = 0;
            while (i < pluginModels.length) {
                model = pluginModels[i];
                this.copy(model.getInstallLocation(), pluginDir, fileSystem, monitor);
                ++i;
            }
            try {
                if (component != null) {
                    TargetDefinition definition = (TargetDefinition)TargetPlatformService.getDefault().getWorkspaceTargetHandle().getTargetDefinition();
                    IProfile profile = definition.getProfile();
                    IStatus status = component.exportMetadata(profile, this.fDestination, definition.getName());
                    if (status.isOK()) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), "Failed to export the target", (Throwable)e);
                return status;
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), "Failed to export the target", (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus copy(String src, IFileStore destinationParent, IFileSystem fileSystem, IProgressMonitor monitor) throws CoreException {
        Path srcPath = new Path(src);
        IFileStore source = fileSystem.getStore((IPath)srcPath);
        String elementName = srcPath.segment(srcPath.segmentCount() - 1);
        IFileStore destinationDirectory = destinationParent.getChild(elementName);
        if (destinationDirectory.fetchInfo().exists()) {
            monitor.worked(1);
            return Status.OK_STATUS;
        }
        if (source.fetchInfo().isDirectory()) {
            destinationDirectory.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
        }
        source.copy(destinationDirectory, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return Status.OK_STATUS;
    }
}

