/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    boolean dragging;
    int lastX;
    int lastY;
    int startX;
    int startY;
    static final int INCREMENT = 1;
    static final int PAGE_INCREMENT = 9;
    static final String[] AX_ATTRIBUTES = new String[]{"AXOrientation", "AXValue", "AXMaxValue", "AXMinValue"};

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
        int cursorStyle = (style & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, cursorStyle);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return 0;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 5;
        } else {
            width += 5;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.state |= 0x820;
        int features = 4;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control, int context) {
        this.fillBackground(control, context, null);
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        int[] stringRef = new int[1];
        OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
        int length = 0;
        if (stringRef[0] != 0) {
            length = OS.CFStringGetLength(stringRef[0]);
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(stringRef[0], range, buffer);
        String attributeName = new String(buffer);
        if (attributeName.equals("AXRole") || attributeName.equals("AXRoleDescription")) {
            String roleText = "AXSplitter";
            buffer = new char[roleText.length()];
            roleText.getChars(0, buffer.length, buffer, 0);
            stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (stringRef[0] != 0) {
                if (attributeName.equals("AXRole")) {
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                } else {
                    int stringRef2 = OS.HICopyAccessibilityRoleDescription(stringRef[0], 0);
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef2});
                    OS.CFRelease(stringRef2);
                }
                OS.CFRelease(stringRef[0]);
                code = 0;
            }
        } else if (attributeName.equals("AXOrientation")) {
            String orientation = (this.style & 0x200) != 0 ? "AXVerticalOrientation" : "AXHorizontalOrientation";
            buffer = new char[orientation.length()];
            orientation.getChars(0, buffer.length, buffer, 0);
            stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (stringRef[0] != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                OS.CFRelease(stringRef[0]);
                code = 0;
            }
        } else if (attributeName.equals("AXValue")) {
            Point location = this.getLocation();
            int value = (this.style & 0x200) != 0 ? location.x : location.y;
            OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{value});
            code = 0;
        } else if (attributeName.equals("AXMaxValue")) {
            Rect parentBounds = new Rect();
            OS.GetControlBounds(this.parent.handle, parentBounds);
            int maxValue = (this.style & 0x200) != 0 ? parentBounds.right - parentBounds.left : parentBounds.bottom - parentBounds.top;
            OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[]{maxValue});
            code = 0;
        } else if (attributeName.equals("AXMinValue")) {
            OS.SetEventParameter(theEvent, 1635022444, 1819242087, 4, new int[1]);
            code = 0;
        }
        if (this.accessible != null) {
            code = this.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        return result;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetCursor(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.display.setCursor(this.sizeCursor.handle);
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            Point location = this.getLocation();
            this.lastX = location.x;
            this.lastY = location.y;
        }
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                if ((modifiers[0] & 0x1000) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyCode[0] == 126 || keyCode[0] == 125) break;
                    xChange = keyCode[0] == 123 ? -stepSize : stepSize;
                } else {
                    if (keyCode[0] == 123 || keyCode[0] == 124) break;
                    yChange = keyCode[0] == 126 ? -stepSize : stepSize;
                }
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                Rectangle parentBounds = this.parent.getBounds();
                int parentWidth = parentBounds.width;
                int parentHeight = parentBounds.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendSelectionEvent(13, event, true);
                if (this.isDisposed() || !event.doit) break;
                this.setBounds(event.x, event.y, width, height);
                if (this.isDisposed()) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if (this.isDisposed()) {
                    return result;
                }
                int cursorX = event.x;
                int cursorY = event.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, boolean send, int chord, short x, short y, int modifiers) {
        boolean result = super.sendMouseEvent(type, button, count, detail, send, chord, x, y, modifiers);
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        short controlX = rect.left;
        short controlY = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        OS.GetControlBounds(this.parent.handle, rect);
        int parentWidth = rect.right - rect.left;
        int parentHeight = rect.bottom - rect.top;
        switch (type) {
            case 3: {
                if (button != 1 || count != 1) break;
                this.startX = x;
                this.startY = y;
                Event event = new Event();
                event.x = controlX;
                event.y = controlY;
                event.width = width;
                event.height = height;
                this.sendSelectionEvent(13, event, true);
                if (this.isDisposed()) {
                    return result;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                this.dragging = true;
                this.setBounds(event.x, event.y, width, height);
                break;
            }
            case 4: {
                if (!this.dragging) break;
                this.dragging = false;
                Event event = new Event();
                event.x = this.lastX;
                event.y = this.lastY;
                event.width = width;
                event.height = height;
                this.sendSelectionEvent(13, event, true);
                if (this.isDisposed()) {
                    return result;
                }
                if (!event.doit) break;
                this.setBounds(event.x, event.y, width, height);
                break;
            }
            case 5: {
                if (!this.dragging) break;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, x + controlX - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, y + controlY - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendSelectionEvent(13, event, true);
                if (this.isDisposed()) {
                    return result;
                }
                if (!event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                this.setBounds(event.x, event.y, width, height);
            }
        }
        return result;
    }

    int traversalCode(int key, int theEvent) {
        return 0;
    }
}

