/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ComboDrawData
extends DrawData {
    static final int ARROW_HEIGHT = 6;
    static final int MIN_ARROW_SIZE = 15;

    public ComboDrawData() {
        this.state = new int[2];
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int buttonHandle = theme.buttonHandle;
        int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
        int drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        int shadow_type = 2;
        if ((this.state[1] & 8) != 0) {
            shadow_type = 1;
        }
        int state_type = this.getStateType(1);
        int relief = OS.gtk_button_get_relief(buttonHandle);
        int interior_focus = theme.getWidgetProperty(buttonHandle, "interior-focus");
        int focus_line_width = theme.getWidgetProperty(buttonHandle, "focus-line-width");
        int focus_padding = theme.getWidgetProperty(buttonHandle, "focus-padding");
        int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythickness = OS.gtk_style_get_xthickness(gtkStyle);
        int arrow_width = 15;
        int arrow_height = 6;
        int x_border = xthickness + focus_padding;
        int y_border = ythickness + focus_padding;
        if (interior_focus == 0) {
            x_border += focus_line_width;
            y_border += focus_line_width;
        }
        int arrow_button_width = arrow_width + x_border * 2;
        int arrow_button_x = x + width - arrow_button_width;
        int arrow_x = arrow_button_x + (arrow_button_width - arrow_width) / 2;
        int arrow_y = y + (height - arrow_height) / 2 + 1;
        if (relief != 2 || (this.state[1] & 0x48) != 0) {
            byte[] detail = Converter.wcsToMbcs(null, "button", true);
            OS.gtk_paint_box(gtkStyle, drawable, state_type, shadow_type, null, buttonHandle, detail, arrow_button_x, y, arrow_button_width, height);
        }
        byte[] arrow_detail = Converter.wcsToMbcs(null, "arrow", true);
        int arrowHandle = theme.arrowHandle;
        OS.gtk_paint_arrow(gtkStyle, drawable, state_type, 2, null, arrowHandle, arrow_detail, 1, true, arrow_x, arrow_y, arrow_width, arrow_height);
        int entryHandle = theme.entryHandle;
        gtkStyle = OS.gtk_widget_get_style(entryHandle);
        theme.transferClipping(gc, gtkStyle);
        state_type = this.getStateType(0);
        byte[] detail = Converter.wcsToMbcs(null, "entry", true);
        OS.gtk_paint_shadow(gtkStyle, drawable, 0, 1, null, entryHandle, detail, x, y, width - arrow_button_width, height);
        xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        ythickness = OS.gtk_style_get_xthickness(gtkStyle);
        detail = Converter.wcsToMbcs(null, "entry_bg", true);
        OS.gtk_paint_flat_box(gtkStyle, drawable, state_type, 0, null, entryHandle, detail, x += xthickness, y += ythickness, (width -= 2 * xthickness) - arrow_button_width, height -= 2 * ythickness);
        if (this.clientArea != null) {
            this.clientArea.x = x;
            this.clientArea.y = y;
            this.clientArea.width = width - arrow_button_width;
            this.clientArea.height = height;
        }
    }

    int getStateType(int part) {
        if (part == 0) {
            int state_type = 0;
            if ((this.state[0] & 0x20) != 0) {
                state_type = 4;
            }
            return state_type;
        }
        return super.getStateType(part);
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        int arrow_button_width;
        int arrow_button_x;
        Rectangle arrowRect;
        if (!bounds.contains(position)) {
            return -1;
        }
        int buttonHandle = theme.buttonHandle;
        int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
        int interior_focus = theme.getWidgetProperty(buttonHandle, "interior-focus");
        int focus_line_width = theme.getWidgetProperty(buttonHandle, "focus-line-width");
        int focus_padding = theme.getWidgetProperty(buttonHandle, "focus-padding");
        int xthickness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythickness = OS.gtk_style_get_xthickness(gtkStyle);
        int arrow_width = 15;
        int x_border = xthickness + focus_padding;
        int y_border = ythickness + focus_padding;
        if (interior_focus == 0) {
            x_border += focus_line_width;
            y_border += focus_line_width;
        }
        if ((arrowRect = new Rectangle(arrow_button_x = bounds.x + bounds.width - (arrow_button_width = arrow_width + x_border * 2), bounds.y, arrow_button_width, bounds.height)).contains(position)) {
            return 1;
        }
        return 0;
    }
}

