/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    String displayText = "";
    int width;
    boolean moveable;
    boolean resizable = true;
    int sort = 0;
    String toolTipText;

    public TableColumn(Table parent, int style) {
        this(parent, style, TableColumn.checkNull((Table)parent).columns.length);
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style), index);
        if (index < 0 || index > parent.columns.length) {
            this.error(6);
        }
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    /*
     * Unable to fully structure code
     */
    void computeDisplayText(GC gc) {
        availableWidth = this.width - 2 * this.parent.getHeaderPadding();
        if (this.image != null) {
            availableWidth -= this.image.getBounds().width;
            availableWidth -= 3;
        }
        if (this.sort != 0) {
            availableWidth -= this.parent.arrowBounds.width;
            availableWidth -= 3;
        }
        text = this.text;
        textWidth = gc.textExtent((String)text, (int)8).x;
        if (textWidth <= availableWidth) {
            this.displayText = text;
            return;
        }
        ellipsisWidth = gc.stringExtent((String)"...").x;
        if ((availableWidth -= ellipsisWidth) <= 0) {
            this.displayText = "...";
            return;
        }
        index = Math.min(availableWidth / gc.getFontMetrics().getAverageCharWidth(), text.length());
        textWidth = gc.textExtent((String)text.substring((int)0, (int)index), (int)8).x;
        if (availableWidth == textWidth) {
            this.displayText = String.valueOf(text.substring(0, index)) + "...";
            return;
        }
        if (availableWidth >= textWidth) ** GOTO lbl32
        do {
            if (--index < 0) {
                this.displayText = "...";
                return;
            }
            text = text.substring(0, index);
        } while (availableWidth < (textWidth = gc.textExtent((String)text, (int)8).x));
        this.displayText = String.valueOf(text) + "...";
        return;
lbl-1000:
        // 1 sources

        {
            textWidth = gc.textExtent((String)text.substring((int)0, (int)(++index)), (int)8).x;
lbl32:
            // 2 sources

            ** while (textWidth < availableWidth)
        }
lbl33:
        // 1 sources

        this.displayText = String.valueOf(text.substring(0, index - 1)) + "...";
    }

    public void dispose() {
        TableColumn newColumn0;
        if (this.isDisposed()) {
            return;
        }
        Rectangle parentBounds = this.parent.clientArea;
        int x = this.getX();
        int index = this.getIndex();
        int orderIndex = this.getOrderIndex();
        int nextColumnAlignment = this.parent.columns.length > 1 ? this.parent.columns[1].getAlignment() : 16384;
        Table parent = this.parent;
        this.dispose(true);
        int width = parentBounds.width - x;
        parent.redraw(x, 0, width, parentBounds.height, false);
        if (index == 0 && ((parent.style & 0x20) != 0 || nextColumnAlignment != 16384) && parent.columns.length > 0 && (newColumn0 = parent.columns[0]).getOrderIndex() < orderIndex) {
            int newColumn0x = newColumn0.getX();
            parent.redraw(newColumn0x, 0, newColumn0.width, parentBounds.height, false);
            if (nextColumnAlignment != 16384 && parent.getHeaderVisible() && parent.drawCount <= 0) {
                parent.header.redraw(newColumn0x, 0, newColumn0.width, parent.header.getClientArea().height, false);
            }
        }
        if (parent.drawCount <= 0 && parent.getHeaderVisible()) {
            parent.header.redraw(x, 0, width, parent.getHeaderHeight(), false);
        }
    }

    void dispose(boolean notifyParent) {
        super.dispose();
        if (notifyParent) {
            this.parent.destroyItem(this);
        }
        this.parent = null;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    int getContentWidth(GC gc, boolean useDisplayText) {
        String text;
        int contentWidth = 0;
        String string = text = useDisplayText ? this.displayText : this.text;
        if (text.length() > 0) {
            contentWidth += gc.textExtent((String)text, (int)8).x;
        }
        if (this.image != null) {
            contentWidth += this.image.getBounds().width;
            if (text.length() > 0) {
                contentWidth += 3;
            }
        }
        if (this.sort != 0) {
            contentWidth += this.parent.arrowBounds.width;
            if (text.length() > 0 || this.image != null) {
                contentWidth += 3;
            }
        }
        return contentWidth;
    }

    int getIndex() {
        TableColumn[] columns = this.parent.columns;
        int i = 0;
        while (i < columns.length) {
            if (columns[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    int getOrderIndex() {
        TableColumn[] orderedColumns = this.parent.orderedColumns;
        if (orderedColumns == null) {
            return this.getIndex();
        }
        int i = 0;
        while (i < orderedColumns.length) {
            if (orderedColumns[i] == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        if (!this.parent.getHeaderVisible()) {
            return 0;
        }
        GC gc = new GC(this.parent);
        int result = this.getContentWidth(gc, false);
        gc.dispose();
        return result + 2 * this.parent.getHeaderPadding();
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    int getX() {
        TableColumn[] orderedColumns = this.parent.getOrderedColumns();
        int index = this.getOrderIndex();
        int result = -this.parent.horizontalOffset;
        int i = 0;
        while (i < index) {
            result += orderedColumns[i].width;
            ++i;
        }
        return result;
    }

    public void pack() {
        this.checkWidget();
        TableItem[] items = this.parent.items;
        int index = this.getIndex();
        int newWidth = this.getPreferredWidth();
        int i = 0;
        while (i < this.parent.itemsCount) {
            int width = items[i].getPreferredWidth(index);
            if (this.parent.isDisposed() || this.isDisposed()) {
                return;
            }
            if (!items[i].isDisposed()) {
                newWidth = Math.max(newWidth, width);
            }
            ++i;
        }
        if (newWidth != this.width) {
            this.parent.updateColumnWidth(this, newWidth);
        }
    }

    void paint(GC gc) {
        int padding = this.parent.getHeaderPadding();
        int x = this.getX();
        int startX = x + padding;
        if ((this.style & 0x4000) == 0) {
            int contentWidth = this.getContentWidth(gc, true);
            startX = (this.style & 0x20000) != 0 ? Math.max(startX, x + this.width - padding - contentWidth) : Math.max(startX, x + (this.width - contentWidth) / 2);
        }
        int headerHeight = this.parent.getHeaderHeight();
        gc.setClipping(x + padding, padding, this.width - 2 * padding, headerHeight - 2 * padding);
        if (this.image != null) {
            Rectangle imageBounds = this.image.getBounds();
            int drawHeight = Math.min(imageBounds.height, headerHeight - 2 * padding);
            gc.drawImage(this.image, 0, 0, imageBounds.width, imageBounds.height, startX, (headerHeight - drawHeight) / 2, imageBounds.width, drawHeight);
            startX += imageBounds.width + 3;
        }
        if (this.displayText.length() > 0) {
            gc.setForeground(this.display.getSystemColor(2));
            int fontHeight = this.parent.fontHeight;
            gc.drawText(this.displayText, startX, (headerHeight - fontHeight) / 2, 8);
            startX += gc.textExtent((String)this.displayText, (int)8).x + 3;
        }
        if (this.sort != 0) {
            Image image = this.sort == 1024 ? this.parent.getArrowDownImage() : this.parent.getArrowUpImage();
            int y = (headerHeight - this.parent.arrowBounds.height) / 2;
            gc.drawImage(image, startX, y);
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.getIndex();
        if (index == -1 || index == 0) {
            return;
        }
        if ((this.style & (alignment = TableColumn.checkBits(alignment, 16384, 0x1000000, 131072, 0, 0, 0))) != 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment;
        int x = this.getX();
        this.parent.redraw(x, 0, this.width, this.parent.clientArea.height, false);
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(x, 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setImage(Image value) {
        this.checkWidget();
        if (value == this.image) {
            return;
        }
        if (value != null && value.equals(this.image)) {
            return;
        }
        super.setImage(value);
        GC gc = new GC(this.parent);
        this.computeDisplayText(gc);
        gc.dispose();
        if (this.parent.headerImageHeight == 0) {
            int oldHeaderHeight = this.parent.getHeaderHeight();
            this.parent.setHeaderImageHeight(value.getBounds().height);
            if (oldHeaderHeight != this.parent.getHeaderHeight()) {
                if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
                    this.parent.header.redraw();
                }
                this.parent.redraw();
                return;
            }
        }
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
    }

    public void setResizable(boolean value) {
        this.checkWidget();
        this.resizable = value;
    }

    void setSortDirection(int value) {
        if (value == this.sort) {
            return;
        }
        boolean widthChange = value == 0 || this.sort == 0;
        this.sort = value;
        if (widthChange) {
            GC gc = new GC(this.parent);
            this.computeDisplayText(gc);
            gc.dispose();
        }
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setText(String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        if (value.equals(this.text)) {
            return;
        }
        super.setText(value);
        GC gc = new GC(this.parent);
        this.computeDisplayText(gc);
        gc.dispose();
        if (this.parent.drawCount <= 0 && this.parent.getHeaderVisible()) {
            this.parent.header.redraw(this.getX(), 1, this.width - 2, this.parent.getHeaderHeight() - 3, false);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string) {
            return;
        }
        if (this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        this.toolTipText = string;
        if (this.parent.toolTipShell == null) {
            return;
        }
        if (((Integer)this.parent.toolTipShell.getData()).intValue() != this.getIndex()) {
            return;
        }
        this.parent.headerUpdateToolTip(this.getX() + this.width / 2);
    }

    public void setWidth(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (this.width == value) {
            return;
        }
        this.parent.updateColumnWidth(this, value);
    }

    void updateFont(GC gc) {
        this.computeDisplayText(gc);
    }

    void updateWidth(GC gc) {
        String oldDisplayText = this.displayText;
        this.computeDisplayText(gc);
        if (this.parent.getHeaderVisible() && ((this.style & 0x4000) == 0 || !oldDisplayText.equals(this.displayText))) {
            int padding = this.parent.getHeaderPadding();
            this.parent.header.redraw(this.getX() + padding, 0, this.width - padding, this.parent.getHeaderHeight(), false);
        }
    }
}

