/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String TYPENAME = "TEXT";
    private static final int TYPEID = TextTransfer.registerType("TEXT");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        super.javaToNative(buffer, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        if (transferData.pData == 0 || !this.isSupportedType(transferData)) {
            return null;
        }
        int size = transferData.length;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[OS.strlen(transferData.pData)];
        OS.memmove(buffer, transferData.pData, buffer.length);
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        return new String(unicode);
    }

    protected String[] getTypeNames() {
        return new String[]{TYPENAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

