/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.contributions.model;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.examples.contributions.ContributionMessages;
import org.eclipse.ui.examples.contributions.model.IPersonService;
import org.eclipse.ui.examples.contributions.model.Person;
import org.eclipse.ui.services.IServiceLocator;

public class PersonWizardPage
extends WizardPage
implements Listener {
    private IServiceLocator locator;
    private Text surnameText;
    private Text givennameText;
    private Text idText;
    static /* synthetic */ Class class$0;

    public PersonWizardPage(IServiceLocator locator) {
        super("personWizardPage");
        this.locator = locator;
        this.setTitle(ContributionMessages.PersonWizardPage_title);
        this.setDescription(ContributionMessages.PersonWizardPage_descriptoin);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        topLevel.setLayout((Layout)gridLayout);
        Label l = new Label(topLevel, 131072);
        l.setText(ContributionMessages.PersonWizardPage_id_label);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.idText = new Text(topLevel, 4);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.idText.setLayoutData((Object)gridData);
        this.idText.addListener(16, (Listener)this);
        this.idText.addListener(2, (Listener)this);
        l = new Label(topLevel, 131072);
        l.setText(ContributionMessages.InfoEditor_surname);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.surnameText = new Text(topLevel, 4);
        gridData = new GridData(4, 0x1000000, true, false);
        this.surnameText.setLayoutData((Object)gridData);
        this.surnameText.addListener(16, (Listener)this);
        this.surnameText.addListener(2, (Listener)this);
        l = new Label(topLevel, 131072);
        l.setText(ContributionMessages.InfoEditor_givenname);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.givennameText = new Text(topLevel, 4);
        gridData = new GridData(4, 0x1000000, true, false);
        this.givennameText.setLayoutData((Object)gridData);
        this.givennameText.addListener(16, (Listener)this);
        this.givennameText.addListener(2, (Listener)this);
        this.setControl((Control)topLevel);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private boolean validatePage() {
        IPersonService service;
        if (this.getId() == 0) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.examples.contributions.model.IPersonService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((service = (IPersonService)this.locator.getService((Class)clazz)).getPerson(this.getId()) != null) {
            this.setErrorMessage(NLS.bind((String)ContributionMessages.PersonWizardPage_error_alreadyExists, (Object)new Integer(this.getId())));
            return false;
        }
        if (this.getSurname() == null || this.getSurname().length() == 0) {
            this.setErrorMessage(ContributionMessages.PersonWizardPage_error_missingSurname);
            return false;
        }
        if (this.getGivenname() == null || this.getGivenname().length() == 0) {
            this.setErrorMessage(ContributionMessages.PersonWizardPage_error_missingGivenname);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    int getId() {
        try {
            return Integer.parseInt(this.idText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    String getGivenname() {
        return this.givennameText.getText();
    }

    String getSurname() {
        return this.surnameText.getText();
    }

    boolean finish() {
        IPersonService service;
        Person person;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.examples.contributions.model.IPersonService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((person = (service = (IPersonService)this.locator.getService((Class)clazz)).createPerson(this.getId())) == null) {
            return false;
        }
        person.setGivenname(this.getGivenname());
        person.setSurname(this.getSurname());
        return true;
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }
}

