/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.menus.MenuHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSet {
    private IConfigurationElement configElement;
    private MApplication application;

    public ActionSet(MApplication application, IEclipseContext appContext, IConfigurationElement element) {
        this.application = application;
        this.configElement = element;
    }

    public void addToModel(ArrayList<MMenuContribution> contributions) {
        IConfigurationElement[] actions;
        IConfigurationElement[] menus;
        String idContrib = MenuHelper.getId(this.configElement);
        IConfigurationElement[] iConfigurationElementArray = menus = this.configElement.getChildren("menu");
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.addContribution(idContrib, contributions, element, true);
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = actions = this.configElement.getChildren("action");
        int n3 = actions.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement element = iConfigurationElementArray2[n];
            this.addContribution(idContrib, contributions, element, false);
            ++n;
        }
    }

    private void addContribution(String idContrib, ArrayList<MMenuContribution> contributions, IConfigurationElement element, boolean isMenu) {
        String path;
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.getTags().add("menuContribution:menu");
        String elementId = MenuHelper.getId(element);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(String.valueOf(idContrib) + "/" + elementId);
        } else {
            menuContribution.setElementId(elementId);
        }
        String string = path = isMenu ? MenuHelper.getPath(element) : MenuHelper.getMenuBarPath(element);
        if (path == null || path.length() == 0) {
            if (!isMenu) {
                return;
            }
            path = "additions";
        }
        Path menuPath = new Path(path);
        String parentId = "org.eclipse.ui.main.menu";
        String positionInParent = "after=" + menuPath.segment(0);
        int segmentCount = menuPath.segmentCount();
        if (segmentCount > 1) {
            parentId = menuPath.segment(segmentCount - 2);
            positionInParent = "after=" + menuPath.segment(segmentCount - 1);
        }
        menuContribution.setParentID(parentId);
        menuContribution.setPositionInParent(positionInParent);
        if (isMenu) {
            MMenu menu = MenuHelper.createMenuAddition(element);
            menuContribution.getChildren().add(menu);
        } else {
            MMenuElement action;
            if (parentId.equals("org.eclipse.ui.main.menu")) {
                E4Util.unsupported("****MC: bad pie: " + menuPath);
                parentId = "window";
                menuContribution.setParentID(parentId);
            }
            if ((action = MenuHelper.createLegacyActionAdditions(this.application, element)) != null) {
                menuContribution.getChildren().add(action);
            }
        }
        if (menuContribution.getChildren().size() > 0) {
            contributions.add(menuContribution);
        }
        if (isMenu) {
            this.processGroups(idContrib, contributions, element);
        }
    }

    private void processGroups(String idContrib, ArrayList<MMenuContribution> contributions, IConfigurationElement element) {
        IConfigurationElement[] children;
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.getTags().add("menuContribution:menu");
        String elementId = MenuHelper.getId(element);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(String.valueOf(idContrib) + "/" + elementId + ".groups");
        } else {
            menuContribution.setElementId(String.valueOf(elementId) + ".groups");
        }
        menuContribution.setParentID(elementId);
        menuContribution.setPositionInParent("after=additions");
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement sepAddition = iConfigurationElementArray[n2];
            String name = sepAddition.getAttribute("name");
            String tag = sepAddition.getName();
            MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
            sep.setElementId(name);
            if ("groupMarker".equals(tag)) {
                sep.setVisible(false);
            }
            menuContribution.getChildren().add(sep);
            ++n2;
        }
        if (menuContribution.getChildren().size() > 0) {
            contributions.add(menuContribution);
        }
    }

    MElementContainer<MMenuElement> findMenuFromPath(MElementContainer<MMenuElement> menu, Path menuPath, int segment) {
        int idx = MenuHelper.indexForId(menu, menuPath.segment(segment));
        if (idx == -1) {
            if (segment + 1 < menuPath.segmentCount() || !menuPath.hasTrailingSeparator()) {
                return null;
            }
            return menu;
        }
        MElementContainer item = (MElementContainer)menu.getChildren().get(idx);
        if (item.getChildren().size() == 0) {
            if (segment + 1 == menuPath.segmentCount()) {
                return menu;
            }
            return null;
        }
        return this.findMenuFromPath((MElementContainer<MMenuElement>)item, menuPath, segment + 1);
    }
}

